/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.ldap;

import org.ietf.ldap.LDAPAuthHandler;
import org.ietf.ldap.LDAPAuthProvider;
import org.ietf.ldap.LDAPBindHandler;
import org.ietf.ldap.LDAPConnection;
import org.ietf.ldap.LDAPControl;
import org.ietf.ldap.LDAPException;
import org.ietf.ldap.LDAPReferralException;
import org.ietf.ldap.LDAPReferralHandler;
import org.ietf.ldap.LDAPSearchConstraints;

public class LDAPConstraints
implements Cloneable {
    private com.novell.ldap.LDAPConstraints cons;
    private com.novell.ldap.LDAPReferralHandler refHandler = null;

    LDAPConstraints(com.novell.ldap.LDAPConstraints lDAPConstraints) {
        this.cons = lDAPConstraints;
    }

    LDAPConstraints(LDAPConstraints lDAPConstraints) {
        this(lDAPConstraints.getTimeLimit(), lDAPConstraints.getReferralFollowing(), null, lDAPConstraints.getHopLimit());
        this.refHandler = lDAPConstraints.getReferralHandler();
        if (lDAPConstraints instanceof LDAPSearchConstraints) {
            LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConstraints;
            com.novell.ldap.LDAPSearchConstraints lDAPSearchConstraints2 = (com.novell.ldap.LDAPSearchConstraints)this.cons;
            lDAPSearchConstraints2.setServerTimeLimit(lDAPSearchConstraints.getServerTimeLimit());
            lDAPSearchConstraints2.setDereference(lDAPSearchConstraints.getDereference());
            lDAPSearchConstraints2.setMaxResults(lDAPSearchConstraints.getMaxResults());
            lDAPSearchConstraints2.setBatchSize(lDAPSearchConstraints.getBatchSize());
        }
    }

    public Object clone() {
        try {
            Object object = super.clone();
            ((LDAPConstraints)object).cons = (com.novell.ldap.LDAPConstraints)this.cons.clone();
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
    }

    public LDAPConstraints() {
        this.cons = new com.novell.ldap.LDAPSearchConstraints();
    }

    public LDAPConstraints(int n, boolean bl, LDAPReferralHandler lDAPReferralHandler, int n2) {
        this.cons = new com.novell.ldap.LDAPSearchConstraints();
        this.cons.setTimeLimit(n);
        this.cons.setReferralFollowing(bl);
        this.cons.setHopLimit(n2);
        this.setReferralHandler(lDAPReferralHandler);
    }

    com.novell.ldap.LDAPConstraints getWrappedObject() {
        return this.cons;
    }

    public int getHopLimit() {
        return this.cons.getHopLimit();
    }

    public Object getProperty(String string) {
        return this.cons.getProperty(string);
    }

    public boolean getReferralFollowing() {
        return this.cons.getReferralFollowing();
    }

    public int getTimeLimit() {
        return this.cons.getTimeLimit();
    }

    public void setHopLimit(int n) {
        this.cons.setHopLimit(n);
    }

    public void setReferralHandler(LDAPReferralHandler lDAPReferralHandler) {
        if (lDAPReferralHandler == null) {
            this.cons.setReferralHandler(null);
            this.refHandler = null;
        } else if (lDAPReferralHandler instanceof LDAPBindHandler) {
            this.refHandler = new BindHandlerImpl((LDAPBindHandler)lDAPReferralHandler);
            this.cons.setReferralHandler(this.refHandler);
        } else if (lDAPReferralHandler instanceof LDAPAuthHandler) {
            this.refHandler = new AuthHandlerImpl((LDAPAuthHandler)lDAPReferralHandler);
            this.cons.setReferralHandler(this.refHandler);
        } else {
            throw new IllegalArgumentException("LDAPReferralHandler object must be either LDAPAuthHandler or LDAPBindHandler");
        }
    }

    com.novell.ldap.LDAPReferralHandler getReferralHandler() {
        return this.refHandler;
    }

    public void setReferralFollowing(boolean bl) {
        this.cons.setReferralFollowing(bl);
    }

    public void setTimeLimit(int n) {
        this.cons.setTimeLimit(n);
    }

    public LDAPControl[] getControls() {
        com.novell.ldap.LDAPControl[] lDAPControlArray = this.cons.getControls();
        if (lDAPControlArray == null) {
            return null;
        }
        LDAPControl[] lDAPControlArray2 = new LDAPControl[lDAPControlArray.length];
        for (int i = 0; i < lDAPControlArray.length; ++i) {
            lDAPControlArray2[i] = new LDAPControl(lDAPControlArray[i]);
        }
        return lDAPControlArray2;
    }

    public void setControls(LDAPControl lDAPControl) {
        this.cons.setControls(lDAPControl);
    }

    public void setControls(LDAPControl[] lDAPControlArray) {
        this.cons.setControls(lDAPControlArray);
    }

    public void setProperty(String string, Object object) throws LDAPException {
        try {
            this.cons.setProperty(string, object);
        }
        catch (com.novell.ldap.LDAPException lDAPException) {
            throw new LDAPException(lDAPException);
        }
    }

    private class AuthHandlerImpl
    implements com.novell.ldap.LDAPAuthHandler {
        LDAPAuthHandler ref;

        private AuthHandlerImpl(LDAPAuthHandler lDAPAuthHandler) {
            this.ref = lDAPAuthHandler;
        }

        public com.novell.ldap.LDAPAuthProvider getAuthProvider(String string, int n) {
            LDAPAuthProvider lDAPAuthProvider = this.ref.getAuthProvider(string, n);
            if (lDAPAuthProvider == null) {
                return null;
            }
            return lDAPAuthProvider.getWrappedObject();
        }
    }

    private class BindHandlerImpl
    implements com.novell.ldap.LDAPBindHandler {
        LDAPBindHandler ref;

        private BindHandlerImpl(LDAPBindHandler lDAPBindHandler) {
            this.ref = lDAPBindHandler;
        }

        public com.novell.ldap.LDAPConnection bind(String[] stringArray, com.novell.ldap.LDAPConnection lDAPConnection) throws com.novell.ldap.LDAPReferralException {
            try {
                LDAPConnection lDAPConnection2 = this.ref.bind(stringArray, new LDAPConnection(lDAPConnection));
                if (lDAPConnection2 == null) {
                    return null;
                }
                return lDAPConnection2.getWrappedObject();
            }
            catch (LDAPReferralException lDAPReferralException) {
                throw (com.novell.ldap.LDAPReferralException)lDAPReferralException.getWrappedObject();
            }
            catch (Throwable throwable) {
                throw new com.novell.ldap.LDAPReferralException(throwable.toString(), throwable);
            }
        }
    }
}

