/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerFileExclusiveReadLockStrategy
implements GenericFileExclusiveReadLockStrategy<File> {
    private static final Logger LOG = LoggerFactory.getLogger(MarkerFileExclusiveReadLockStrategy.class);
    private boolean markerFile = true;

    @Override
    public void prepareOnStartup(GenericFileOperations<File> operations, GenericFileEndpoint<File> endpoint) {
        String dir = endpoint.getConfiguration().getDirectory();
        File file = new File(dir);
        LOG.debug("Prepare on startup by deleting orphaned lock files from: {}", (Object)dir);
        StopWatch watch = new StopWatch();
        MarkerFileExclusiveReadLockStrategy.deleteLockFiles(file, endpoint.isRecursive());
        if (watch.taken() > 1000L) {
            LOG.info("Prepared on startup by deleting orphaned lock files from: {} took {} millis to complete.", (Object)dir, (Object)watch.taken());
        }
    }

    @Override
    public boolean acquireExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        if (!this.markerFile) {
            return true;
        }
        String lockFileName = MarkerFileExclusiveReadLockStrategy.getLockFileName(file);
        LOG.trace("Locking the file: {} using the lock file name: {}", file, (Object)lockFileName);
        boolean acquired = FileUtil.createNewFile(new File(lockFileName));
        exchange.setProperty("CamelFileLockFileAcquired", acquired);
        exchange.setProperty("CamelFileLockFileName", lockFileName);
        return acquired;
    }

    @Override
    public void releaseExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        if (!this.markerFile) {
            return;
        }
        String lockFileName = exchange.getProperty("CamelFileLockFileName", MarkerFileExclusiveReadLockStrategy.getLockFileName(file), String.class);
        File lock = new File(lockFileName);
        if (exchange.getProperty("CamelFileLockFileAcquired", false, Boolean.class).booleanValue()) {
            LOG.trace("Unlocking file: {}", (Object)lockFileName);
            boolean deleted = FileUtil.deleteFile(lock);
            LOG.trace("Lock file: {} was deleted: {}", (Object)lockFileName, (Object)deleted);
        } else {
            LOG.trace("Don't try to delete the Lock file: {} as camel doesn't get to lock before.", (Object)lockFileName);
        }
    }

    @Override
    public void setTimeout(long timeout) {
    }

    @Override
    public void setCheckInterval(long checkInterval) {
    }

    @Override
    public void setReadLockLoggingLevel(LoggingLevel readLockLoggingLevel) {
    }

    @Override
    public void setMarkerFiler(boolean markerFile) {
        this.markerFile = markerFile;
    }

    private static void deleteLockFiles(File dir, boolean recursive) {
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File file : files) {
            if (file.getName().startsWith(".")) continue;
            if (file.getName().endsWith(".camelLock")) {
                LOG.warn("Deleting orphaned lock file: " + file);
                FileUtil.deleteFile(file);
                continue;
            }
            if (!recursive || !file.isDirectory()) continue;
            MarkerFileExclusiveReadLockStrategy.deleteLockFiles(file, true);
        }
    }

    private static String getLockFileName(GenericFile<File> file) {
        return file.getAbsoluteFilePath() + ".camelLock";
    }
}

