/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command.store.proto;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.fusesource.hawtbuf.proto.CodedInputStream;
import org.fusesource.hawtbuf.proto.CodedOutputStream;
import org.fusesource.hawtbuf.proto.InvalidProtocolBufferException;
import org.fusesource.hawtbuf.proto.MessageBuffer;
import org.fusesource.hawtbuf.proto.MessageBufferSupport;
import org.fusesource.hawtbuf.proto.PBMessage;
import org.fusesource.hawtbuf.proto.PBMessageFactory;
import org.fusesource.hawtbuf.proto.PBMessageFramedCodec;
import org.fusesource.hawtbuf.proto.PBMessageUnframedCodec;

public class QueueEntryPB
implements PBMessageFactory<Bean, Buffer> {
    public static final QueueEntryPB FACTORY = new QueueEntryPB();
    public static final PBMessageFramedCodec<Buffer> FRAMED_CODEC = new PBMessageFramedCodec((PBMessageFactory)FACTORY);
    public static final PBMessageUnframedCodec<Buffer> UNFRAMED_CODEC = new PBMessageUnframedCodec((PBMessageFactory)FACTORY);

    public Bean create() {
        return new Bean();
    }

    public Bean parseUnframed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        return new Bean().mergeUnframed(data);
    }

    public Bean parseUnframed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return this.parseUnframed(new CodedInputStream(data));
    }

    public Buffer parseUnframed(org.fusesource.hawtbuf.Buffer data) throws InvalidProtocolBufferException {
        return new Buffer(data);
    }

    public Buffer parseUnframed(byte[] data) throws InvalidProtocolBufferException {
        return this.parseUnframed(new org.fusesource.hawtbuf.Buffer(data));
    }

    public Buffer parseFramed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        int length = data.readRawVarint32();
        int oldLimit = data.pushLimit(length);
        Buffer rc = this.parseUnframed(data.readRawBytes(length));
        data.popLimit(oldLimit);
        return rc;
    }

    public Buffer parseFramed(org.fusesource.hawtbuf.Buffer data) throws InvalidProtocolBufferException {
        try {
            CodedInputStream input = new CodedInputStream(data);
            Buffer rc = this.parseFramed(input);
            input.checkLastTagWas(0);
            return rc;
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("An IOException was thrown (should never happen in this method).", e);
        }
    }

    public Buffer parseFramed(byte[] data) throws InvalidProtocolBufferException {
        return this.parseFramed(new org.fusesource.hawtbuf.Buffer(data));
    }

    public Buffer parseFramed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return this.parseUnframed(MessageBufferSupport.readFrame((InputStream)data));
    }

    public static final class Buffer
    implements MessageBuffer<Bean, Buffer>,
    Getter {
        private Bean bean;
        private org.fusesource.hawtbuf.Buffer buffer;
        private int size = -1;
        private int hashCode;

        private Buffer(org.fusesource.hawtbuf.Buffer buffer) {
            this.buffer = buffer;
        }

        private Buffer(Bean bean) {
            this.bean = bean;
        }

        @Override
        public Bean copy() {
            return this.bean().copy();
        }

        @Override
        public Buffer freeze() {
            return this;
        }

        private Bean bean() {
            if (this.bean == null) {
                try {
                    this.bean = new Bean().mergeUnframed(new CodedInputStream(this.buffer));
                    this.bean.frozen = this;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException("An IOException was thrown (should never happen in this method).", e);
                }
            }
            return this.bean;
        }

        public String toString() {
            return this.bean().toString();
        }

        @Override
        public StringBuilder toString(StringBuilder sb, String prefix) {
            return this.bean().toString(sb, prefix);
        }

        @Override
        public boolean hasQueueKey() {
            return this.bean().hasQueueKey();
        }

        @Override
        public long getQueueKey() {
            return this.bean().getQueueKey();
        }

        @Override
        public boolean hasQueueSeq() {
            return this.bean().hasQueueSeq();
        }

        @Override
        public long getQueueSeq() {
            return this.bean().getQueueSeq();
        }

        @Override
        public boolean hasMessageKey() {
            return this.bean().hasMessageKey();
        }

        @Override
        public long getMessageKey() {
            return this.bean().getMessageKey();
        }

        @Override
        public boolean hasSize() {
            return this.bean().hasSize();
        }

        @Override
        public int getSize() {
            return this.bean().getSize();
        }

        @Override
        public boolean hasAttachment() {
            return this.bean().hasAttachment();
        }

        @Override
        public org.fusesource.hawtbuf.Buffer getAttachment() {
            return this.bean().getAttachment();
        }

        @Override
        public boolean hasRedeliveries() {
            return this.bean().hasRedeliveries();
        }

        @Override
        public int getRedeliveries() {
            return this.bean().getRedeliveries();
        }

        @Override
        public boolean hasExpiration() {
            return this.bean().hasExpiration();
        }

        @Override
        public long getExpiration() {
            return this.bean().getExpiration();
        }

        @Override
        public boolean hasMessageLocator() {
            return this.bean().hasMessageLocator();
        }

        @Override
        public org.fusesource.hawtbuf.Buffer getMessageLocator() {
            return this.bean().getMessageLocator();
        }

        @Override
        public boolean hasSender() {
            return this.bean().hasSender();
        }

        @Override
        public List<org.fusesource.hawtbuf.Buffer> getSenderList() {
            return this.bean().getSenderList();
        }

        @Override
        public int getSenderCount() {
            return this.bean().getSenderCount();
        }

        @Override
        public org.fusesource.hawtbuf.Buffer getSender(int index) {
            return this.bean().getSender(index);
        }

        public org.fusesource.hawtbuf.Buffer toUnframedBuffer() {
            if (this.buffer != null) {
                return this.buffer;
            }
            return MessageBufferSupport.toUnframedBuffer((MessageBuffer)this);
        }

        public org.fusesource.hawtbuf.Buffer toFramedBuffer() {
            return MessageBufferSupport.toFramedBuffer((MessageBuffer)this);
        }

        public byte[] toUnframedByteArray() {
            return this.toUnframedBuffer().toByteArray();
        }

        public byte[] toFramedByteArray() {
            return this.toFramedBuffer().toByteArray();
        }

        public void writeFramed(CodedOutputStream output) throws IOException {
            output.writeRawVarint32(this.serializedSizeUnframed());
            this.writeUnframed(output);
        }

        public void writeFramed(OutputStream output) throws IOException {
            CodedOutputStream codedOutput = new CodedOutputStream(output);
            this.writeFramed(codedOutput);
            codedOutput.flush();
        }

        public void writeUnframed(OutputStream output) throws IOException {
            CodedOutputStream codedOutput = new CodedOutputStream(output);
            this.writeUnframed(codedOutput);
            codedOutput.flush();
        }

        public void writeUnframed(CodedOutputStream output) throws IOException {
            if (this.buffer == null) {
                int size = this.serializedSizeUnframed();
                this.buffer = output.getNextBuffer(size);
                CodedOutputStream original = null;
                if (this.buffer == null) {
                    this.buffer = new org.fusesource.hawtbuf.Buffer(new byte[size]);
                    original = output;
                    output = new CodedOutputStream(this.buffer);
                }
                output.writeInt64(1, this.bean.getQueueKey());
                output.writeInt64(2, this.bean.getQueueSeq());
                output.writeInt64(3, this.bean.getMessageKey());
                if (this.bean.hasSize()) {
                    output.writeInt32(4, this.bean.getSize());
                }
                if (this.bean.hasAttachment()) {
                    output.writeBytes(5, this.bean.getAttachment());
                }
                if (this.bean.hasRedeliveries()) {
                    output.writeInt32(6, this.bean.getRedeliveries());
                }
                if (this.bean.hasExpiration()) {
                    output.writeSInt64(7, this.bean.getExpiration());
                }
                if (this.bean.hasMessageLocator()) {
                    output.writeBytes(8, this.bean.getMessageLocator());
                }
                if (this.bean.hasSender()) {
                    for (org.fusesource.hawtbuf.Buffer i : this.bean.getSenderList()) {
                        output.writeBytes(9, i);
                    }
                }
                if (original != null) {
                    output.checkNoSpaceLeft();
                    output = original;
                    output.writeRawBytes(this.buffer);
                }
            } else {
                output.writeRawBytes(this.buffer);
            }
        }

        public int serializedSizeFramed() {
            int t = this.serializedSizeUnframed();
            return CodedOutputStream.computeRawVarint32Size((int)t) + t;
        }

        public int serializedSizeUnframed() {
            if (this.buffer != null) {
                return this.buffer.length;
            }
            if (this.size != -1) {
                return this.size;
            }
            this.size = 0;
            this.size += CodedOutputStream.computeInt64Size((int)1, (long)this.getQueueKey());
            this.size += CodedOutputStream.computeInt64Size((int)2, (long)this.getQueueSeq());
            this.size += CodedOutputStream.computeInt64Size((int)3, (long)this.getMessageKey());
            if (this.hasSize()) {
                this.size += CodedOutputStream.computeInt32Size((int)4, (int)this.getSize());
            }
            if (this.hasAttachment()) {
                this.size += CodedOutputStream.computeBytesSize((int)5, (org.fusesource.hawtbuf.Buffer)this.getAttachment());
            }
            if (this.hasRedeliveries()) {
                this.size += CodedOutputStream.computeInt32Size((int)6, (int)this.getRedeliveries());
            }
            if (this.hasExpiration()) {
                this.size += CodedOutputStream.computeSInt64Size((int)7, (long)this.getExpiration());
            }
            if (this.hasMessageLocator()) {
                this.size += CodedOutputStream.computeBytesSize((int)8, (org.fusesource.hawtbuf.Buffer)this.getMessageLocator());
            }
            if (this.hasSender()) {
                for (org.fusesource.hawtbuf.Buffer i : this.getSenderList()) {
                    this.size += CodedOutputStream.computeBytesSize((int)9, (org.fusesource.hawtbuf.Buffer)i);
                }
            }
            return this.size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != Buffer.class) {
                return false;
            }
            return this.equals((Buffer)obj);
        }

        public boolean equals(Buffer obj) {
            return this.toUnframedBuffer().equals(obj.toUnframedBuffer());
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = 0x77408060 ^ this.toUnframedBuffer().hashCode();
            }
            return this.hashCode;
        }

        public boolean frozen() {
            return true;
        }
    }

    public static final class Bean
    implements Getter {
        Buffer frozen;
        Bean bean;
        private long f_queueKey = 0L;
        private boolean b_queueKey;
        private long f_queueSeq = 0L;
        private boolean b_queueSeq;
        private long f_messageKey = 0L;
        private boolean b_messageKey;
        private int f_size = 0;
        private boolean b_size;
        private org.fusesource.hawtbuf.Buffer f_attachment = null;
        private int f_redeliveries = 0;
        private boolean b_redeliveries;
        private long f_expiration = 0L;
        private boolean b_expiration;
        private org.fusesource.hawtbuf.Buffer f_messageLocator = null;
        private List<org.fusesource.hawtbuf.Buffer> f_sender;

        public Bean() {
            this.bean = this;
        }

        public Bean(Bean copy) {
            this.bean = copy;
        }

        @Override
        public Bean copy() {
            return new Bean(this.bean);
        }

        public boolean frozen() {
            return this.frozen != null;
        }

        @Override
        public Buffer freeze() {
            if (this.frozen == null) {
                this.frozen = new Buffer(this.bean);
                assert (this.deepFreeze());
            }
            return this.frozen;
        }

        private boolean deepFreeze() {
            this.frozen.serializedSizeUnframed();
            return true;
        }

        private void copyCheck() {
            assert (this.frozen == null) : "Modification not allowed after object has been fozen.  Try modifying a copy of this object.";
            if (this.bean != this) {
                this.copy(this.bean);
            }
        }

        private void copy(Bean other) {
            this.bean = this;
            this.f_queueKey = other.f_queueKey;
            this.b_queueKey = other.b_queueKey;
            this.f_queueSeq = other.f_queueSeq;
            this.b_queueSeq = other.b_queueSeq;
            this.f_messageKey = other.f_messageKey;
            this.b_messageKey = other.b_messageKey;
            this.f_size = other.f_size;
            this.b_size = other.b_size;
            this.f_attachment = other.f_attachment;
            this.f_redeliveries = other.f_redeliveries;
            this.b_redeliveries = other.b_redeliveries;
            this.f_expiration = other.f_expiration;
            this.b_expiration = other.b_expiration;
            this.f_messageLocator = other.f_messageLocator;
            this.f_sender = other.f_sender;
            if (this.f_sender != null && !other.frozen()) {
                this.f_sender = new ArrayList<org.fusesource.hawtbuf.Buffer>(this.f_sender);
            }
        }

        @Override
        public boolean hasQueueKey() {
            return this.bean.b_queueKey;
        }

        @Override
        public long getQueueKey() {
            return this.bean.f_queueKey;
        }

        public Bean setQueueKey(long queueKey) {
            this.copyCheck();
            this.b_queueKey = true;
            this.f_queueKey = queueKey;
            return this;
        }

        public void clearQueueKey() {
            this.copyCheck();
            this.b_queueKey = false;
            this.f_queueKey = 0L;
        }

        @Override
        public boolean hasQueueSeq() {
            return this.bean.b_queueSeq;
        }

        @Override
        public long getQueueSeq() {
            return this.bean.f_queueSeq;
        }

        public Bean setQueueSeq(long queueSeq) {
            this.copyCheck();
            this.b_queueSeq = true;
            this.f_queueSeq = queueSeq;
            return this;
        }

        public void clearQueueSeq() {
            this.copyCheck();
            this.b_queueSeq = false;
            this.f_queueSeq = 0L;
        }

        @Override
        public boolean hasMessageKey() {
            return this.bean.b_messageKey;
        }

        @Override
        public long getMessageKey() {
            return this.bean.f_messageKey;
        }

        public Bean setMessageKey(long messageKey) {
            this.copyCheck();
            this.b_messageKey = true;
            this.f_messageKey = messageKey;
            return this;
        }

        public void clearMessageKey() {
            this.copyCheck();
            this.b_messageKey = false;
            this.f_messageKey = 0L;
        }

        @Override
        public boolean hasSize() {
            return this.bean.b_size;
        }

        @Override
        public int getSize() {
            return this.bean.f_size;
        }

        public Bean setSize(int size) {
            this.copyCheck();
            this.b_size = true;
            this.f_size = size;
            return this;
        }

        public void clearSize() {
            this.copyCheck();
            this.b_size = false;
            this.f_size = 0;
        }

        @Override
        public boolean hasAttachment() {
            return this.bean.f_attachment != null;
        }

        @Override
        public org.fusesource.hawtbuf.Buffer getAttachment() {
            return this.bean.f_attachment;
        }

        public Bean setAttachment(org.fusesource.hawtbuf.Buffer attachment) {
            this.copyCheck();
            this.f_attachment = attachment;
            return this;
        }

        public void clearAttachment() {
            this.copyCheck();
            this.f_attachment = null;
        }

        @Override
        public boolean hasRedeliveries() {
            return this.bean.b_redeliveries;
        }

        @Override
        public int getRedeliveries() {
            return this.bean.f_redeliveries;
        }

        public Bean setRedeliveries(int redeliveries) {
            this.copyCheck();
            this.b_redeliveries = true;
            this.f_redeliveries = redeliveries;
            return this;
        }

        public void clearRedeliveries() {
            this.copyCheck();
            this.b_redeliveries = false;
            this.f_redeliveries = 0;
        }

        @Override
        public boolean hasExpiration() {
            return this.bean.b_expiration;
        }

        @Override
        public long getExpiration() {
            return this.bean.f_expiration;
        }

        public Bean setExpiration(long expiration) {
            this.copyCheck();
            this.b_expiration = true;
            this.f_expiration = expiration;
            return this;
        }

        public void clearExpiration() {
            this.copyCheck();
            this.b_expiration = false;
            this.f_expiration = 0L;
        }

        @Override
        public boolean hasMessageLocator() {
            return this.bean.f_messageLocator != null;
        }

        @Override
        public org.fusesource.hawtbuf.Buffer getMessageLocator() {
            return this.bean.f_messageLocator;
        }

        public Bean setMessageLocator(org.fusesource.hawtbuf.Buffer messageLocator) {
            this.copyCheck();
            this.f_messageLocator = messageLocator;
            return this;
        }

        public void clearMessageLocator() {
            this.copyCheck();
            this.f_messageLocator = null;
        }

        @Override
        public boolean hasSender() {
            return this.bean.f_sender != null && !this.bean.f_sender.isEmpty();
        }

        @Override
        public List<org.fusesource.hawtbuf.Buffer> getSenderList() {
            return this.bean.f_sender;
        }

        public List<org.fusesource.hawtbuf.Buffer> createSenderList() {
            this.copyCheck();
            if (this.f_sender == null) {
                this.f_sender = new ArrayList<org.fusesource.hawtbuf.Buffer>();
            }
            return this.bean.f_sender;
        }

        public Bean setSenderList(List<org.fusesource.hawtbuf.Buffer> sender) {
            this.copyCheck();
            this.f_sender = sender;
            return this;
        }

        @Override
        public int getSenderCount() {
            if (this.bean.f_sender == null) {
                return 0;
            }
            return this.bean.f_sender.size();
        }

        @Override
        public org.fusesource.hawtbuf.Buffer getSender(int index) {
            if (this.bean.f_sender == null) {
                return null;
            }
            return this.bean.f_sender.get(index);
        }

        public Bean setSender(int index, org.fusesource.hawtbuf.Buffer value) {
            this.createSenderList().set(index, value);
            return this;
        }

        public Bean addSender(org.fusesource.hawtbuf.Buffer value) {
            this.createSenderList().add(value);
            return this;
        }

        public Bean addAllSender(Iterable<? extends org.fusesource.hawtbuf.Buffer> collection) {
            MessageBufferSupport.addAll(collection, this.createSenderList());
            return this;
        }

        public void clearSender() {
            this.copyCheck();
            this.f_sender = null;
        }

        public String toString() {
            return this.toString(new StringBuilder(), "").toString();
        }

        @Override
        public StringBuilder toString(StringBuilder sb, String prefix) {
            if (this.hasQueueKey()) {
                sb.append(prefix + "queueKey: ");
                sb.append(this.getQueueKey());
                sb.append("\n");
            }
            if (this.hasQueueSeq()) {
                sb.append(prefix + "queueSeq: ");
                sb.append(this.getQueueSeq());
                sb.append("\n");
            }
            if (this.hasMessageKey()) {
                sb.append(prefix + "messageKey: ");
                sb.append(this.getMessageKey());
                sb.append("\n");
            }
            if (this.hasSize()) {
                sb.append(prefix + "size: ");
                sb.append(this.getSize());
                sb.append("\n");
            }
            if (this.hasAttachment()) {
                sb.append(prefix + "attachment: ");
                sb.append(this.getAttachment());
                sb.append("\n");
            }
            if (this.hasRedeliveries()) {
                sb.append(prefix + "redeliveries: ");
                sb.append(this.getRedeliveries());
                sb.append("\n");
            }
            if (this.hasExpiration()) {
                sb.append(prefix + "expiration: ");
                sb.append(this.getExpiration());
                sb.append("\n");
            }
            if (this.hasMessageLocator()) {
                sb.append(prefix + "messageLocator: ");
                sb.append(this.getMessageLocator());
                sb.append("\n");
            }
            if (this.hasSender()) {
                List<org.fusesource.hawtbuf.Buffer> l = this.getSenderList();
                for (int i = 0; i < l.size(); ++i) {
                    sb.append(prefix + "sender[" + i + "]: ");
                    sb.append(l.get(i));
                    sb.append("\n");
                }
            }
            return sb;
        }

        public Bean mergeUnframed(InputStream input) throws IOException {
            return this.mergeUnframed(new CodedInputStream(input));
        }

        public Bean mergeUnframed(CodedInputStream input) throws IOException {
            this.copyCheck();
            int tag;
            block12: while (((tag = input.readTag()) & 7) != 4) {
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        continue block12;
                    }
                    case 8: {
                        this.setQueueKey(input.readInt64());
                        continue block12;
                    }
                    case 16: {
                        this.setQueueSeq(input.readInt64());
                        continue block12;
                    }
                    case 24: {
                        this.setMessageKey(input.readInt64());
                        continue block12;
                    }
                    case 32: {
                        this.setSize(input.readInt32());
                        continue block12;
                    }
                    case 42: {
                        this.setAttachment(input.readBytes());
                        continue block12;
                    }
                    case 48: {
                        this.setRedeliveries(input.readInt32());
                        continue block12;
                    }
                    case 56: {
                        this.setExpiration(input.readSInt64());
                        continue block12;
                    }
                    case 66: {
                        this.setMessageLocator(input.readBytes());
                        continue block12;
                    }
                    case 74: 
                }
                this.createSenderList().add(input.readBytes());
            }
            return this;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != Bean.class) {
                return false;
            }
            return this.equals((Bean)obj);
        }

        public boolean equals(Bean obj) {
            if (this.hasQueueKey() ^ obj.hasQueueKey()) {
                return false;
            }
            if (this.hasQueueKey() && this.getQueueKey() != obj.getQueueKey()) {
                return false;
            }
            if (this.hasQueueSeq() ^ obj.hasQueueSeq()) {
                return false;
            }
            if (this.hasQueueSeq() && this.getQueueSeq() != obj.getQueueSeq()) {
                return false;
            }
            if (this.hasMessageKey() ^ obj.hasMessageKey()) {
                return false;
            }
            if (this.hasMessageKey() && this.getMessageKey() != obj.getMessageKey()) {
                return false;
            }
            if (this.hasSize() ^ obj.hasSize()) {
                return false;
            }
            if (this.hasSize() && this.getSize() != obj.getSize()) {
                return false;
            }
            if (this.hasAttachment() ^ obj.hasAttachment()) {
                return false;
            }
            if (this.hasAttachment() && !this.getAttachment().equals(obj.getAttachment())) {
                return false;
            }
            if (this.hasRedeliveries() ^ obj.hasRedeliveries()) {
                return false;
            }
            if (this.hasRedeliveries() && this.getRedeliveries() != obj.getRedeliveries()) {
                return false;
            }
            if (this.hasExpiration() ^ obj.hasExpiration()) {
                return false;
            }
            if (this.hasExpiration() && this.getExpiration() != obj.getExpiration()) {
                return false;
            }
            if (this.hasMessageLocator() ^ obj.hasMessageLocator()) {
                return false;
            }
            if (this.hasMessageLocator() && !this.getMessageLocator().equals(obj.getMessageLocator())) {
                return false;
            }
            if (this.hasSender() ^ obj.hasSender()) {
                return false;
            }
            return !this.hasSender() || this.getSenderList().equals(obj.getSenderList());
        }

        public int hashCode() {
            int rc = 2066384;
            if (this.hasQueueKey()) {
                rc ^= 0xBE718BAE ^ new Long(this.getQueueKey()).hashCode();
            }
            if (this.hasQueueSeq()) {
                rc ^= 0xBE71A9AE ^ new Long(this.getQueueSeq()).hashCode();
            }
            if (this.hasMessageKey()) {
                rc ^= 0x120B30F8 ^ new Long(this.getMessageKey()).hashCode();
            }
            if (this.hasSize()) {
                rc ^= 0x275421 ^ this.getSize();
            }
            if (this.hasAttachment()) {
                rc ^= 0x1C93543 ^ this.getAttachment().hashCode();
            }
            if (this.hasRedeliveries()) {
                rc ^= 0x755F3E25 ^ this.getRedeliveries();
            }
            if (this.hasExpiration()) {
                rc ^= 0x44E726CF ^ new Long(this.getExpiration()).hashCode();
            }
            if (this.hasMessageLocator()) {
                rc ^= 0xB887AAF ^ this.getMessageLocator().hashCode();
            }
            if (this.hasSender()) {
                rc ^= 0x93650655 ^ this.getSenderList().hashCode();
            }
            return rc;
        }

        public Bean mergeFrom(Getter other) {
            this.copyCheck();
            if (other.hasQueueKey()) {
                this.setQueueKey(other.getQueueKey());
            }
            if (other.hasQueueSeq()) {
                this.setQueueSeq(other.getQueueSeq());
            }
            if (other.hasMessageKey()) {
                this.setMessageKey(other.getMessageKey());
            }
            if (other.hasSize()) {
                this.setSize(other.getSize());
            }
            if (other.hasAttachment()) {
                this.setAttachment(other.getAttachment());
            }
            if (other.hasRedeliveries()) {
                this.setRedeliveries(other.getRedeliveries());
            }
            if (other.hasExpiration()) {
                this.setExpiration(other.getExpiration());
            }
            if (other.hasMessageLocator()) {
                this.setMessageLocator(other.getMessageLocator());
            }
            if (other.hasSender()) {
                this.getSenderList().addAll(other.getSenderList());
            }
            return this;
        }

        public void clear() {
            this.clearQueueKey();
            this.clearQueueSeq();
            this.clearMessageKey();
            this.clearSize();
            this.clearAttachment();
            this.clearRedeliveries();
            this.clearExpiration();
            this.clearMessageLocator();
            this.clearSender();
        }

        public void readExternal(DataInput in) throws IOException {
            byte[] b;
            assert (this.frozen == null) : "Modification not allowed after object has been fozen.  Try modifying a copy of this object.";
            this.bean = this;
            this.frozen = null;
            this.f_queueKey = in.readLong();
            this.b_queueKey = true;
            this.f_queueSeq = in.readLong();
            this.b_queueSeq = true;
            this.f_messageKey = in.readLong();
            this.b_messageKey = true;
            this.f_size = in.readInt();
            this.b_size = true;
            int size = in.readInt();
            if (size >= 0) {
                b = new byte[size];
                in.readFully(b);
                this.f_attachment = new org.fusesource.hawtbuf.Buffer(b);
            } else {
                this.f_attachment = null;
            }
            this.f_redeliveries = in.readInt();
            this.b_redeliveries = true;
            this.f_expiration = in.readLong();
            this.b_expiration = true;
            size = in.readInt();
            if (size >= 0) {
                b = new byte[size];
                in.readFully(b);
                this.f_messageLocator = new org.fusesource.hawtbuf.Buffer(b);
            } else {
                this.f_messageLocator = null;
            }
            size = in.readShort();
            if (size >= 0) {
                this.f_sender = new ArrayList<org.fusesource.hawtbuf.Buffer>(size);
                for (int i = 0; i < size; ++i) {
                    byte[] b2 = new byte[in.readInt()];
                    in.readFully(b2);
                    this.f_sender.add(new org.fusesource.hawtbuf.Buffer(b2));
                }
            } else {
                this.f_sender = null;
            }
        }

        public void writeExternal(DataOutput out) throws IOException {
            out.writeLong(this.bean.f_queueKey);
            out.writeLong(this.bean.f_queueSeq);
            out.writeLong(this.bean.f_messageKey);
            out.writeInt(this.bean.f_size);
            if (this.bean.f_attachment != null) {
                out.writeInt(this.bean.f_attachment.getLength());
                out.write(this.bean.f_attachment.getData(), this.bean.f_attachment.getOffset(), this.bean.f_attachment.getLength());
            } else {
                out.writeInt(-1);
            }
            out.writeInt(this.bean.f_redeliveries);
            out.writeLong(this.bean.f_expiration);
            if (this.bean.f_messageLocator != null) {
                out.writeInt(this.bean.f_messageLocator.getLength());
                out.write(this.bean.f_messageLocator.getData(), this.bean.f_messageLocator.getOffset(), this.bean.f_messageLocator.getLength());
            } else {
                out.writeInt(-1);
            }
            if (this.bean.f_sender != null) {
                out.writeShort(this.bean.f_sender.size());
                for (org.fusesource.hawtbuf.Buffer o : this.bean.f_sender) {
                    out.writeInt(o.getLength());
                    out.write(o.getData(), o.getOffset(), o.getLength());
                }
            } else {
                out.writeShort(-1);
            }
        }
    }

    public static interface Getter
    extends PBMessage<Bean, Buffer> {
        public boolean hasQueueKey();

        public long getQueueKey();

        public boolean hasQueueSeq();

        public long getQueueSeq();

        public boolean hasMessageKey();

        public long getMessageKey();

        public boolean hasSize();

        public int getSize();

        public boolean hasAttachment();

        public org.fusesource.hawtbuf.Buffer getAttachment();

        public boolean hasRedeliveries();

        public int getRedeliveries();

        public boolean hasExpiration();

        public long getExpiration();

        public boolean hasMessageLocator();

        public org.fusesource.hawtbuf.Buffer getMessageLocator();

        public boolean hasSender();

        public List<org.fusesource.hawtbuf.Buffer> getSenderList();

        public int getSenderCount();

        public org.fusesource.hawtbuf.Buffer getSender(int var1);

        public Bean copy();

        public Buffer freeze();

        public StringBuilder toString(StringBuilder var1, String var2);
    }
}

