/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.collectd.GenericIndexResourceType;
import org.opennms.netmgt.collectd.IfAliasResourceType;
import org.opennms.netmgt.collectd.IfResourceType;
import org.opennms.netmgt.collectd.NodeResourceType;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collectd.SnmpCollectionSet;
import org.opennms.netmgt.collectd.SnmpCollector;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.api.DataCollectionConfigDao;
import org.opennms.netmgt.config.datacollection.MibObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnmsSnmpCollection {
    private static final Logger LOG = LoggerFactory.getLogger(OnmsSnmpCollection.class);
    private final ServiceParameters m_params;
    private NodeResourceType m_nodeResourceType;
    private IfResourceType m_ifResourceType;
    private IfAliasResourceType m_ifAliasResourceType;
    private Map<String, ResourceType> m_genericIndexResourceTypes;
    private DataCollectionConfigDao m_dataCollectionConfigDao;
    private List<SnmpAttributeType> m_nodeAttributeTypes;
    private List<SnmpAttributeType> m_indexedAttributeTypes;
    private List<SnmpAttributeType> m_aliasAttributeTypes;

    public OnmsSnmpCollection(SnmpCollectionAgent agent, ServiceParameters params) {
        this(agent, params, null);
    }

    public OnmsSnmpCollection(SnmpCollectionAgent agent, ServiceParameters params, DataCollectionConfigDao config) {
        this.setDataCollectionConfigDao(config);
        this.m_params = params;
        if (Boolean.getBoolean("org.opennms.netmgt.collectd.OnmsSnmpCollection.loadResourceTypesInInit")) {
            this.getResourceTypes(agent);
        }
    }

    public ServiceParameters getServiceParameters() {
        return this.m_params;
    }

    public String getName() {
        return this.m_params.getCollectionName();
    }

    public int getSnmpPort(int current) {
        return this.m_params.getSnmpPort(current);
    }

    public int getSnmpRetries(int current) {
        return this.m_params.getSnmpRetries(current);
    }

    public int getSnmpTimeout(int current) {
        return this.m_params.getSnmpTimeout(current);
    }

    public String getSnmpReadCommunity(String current) {
        return this.m_params.getSnmpReadCommunity(current);
    }

    public String getSnmpWriteCommunity(String current) {
        return this.m_params.getSnmpWriteCommunity(current);
    }

    public InetAddress getSnmpProxyFor(InetAddress current) {
        return this.m_params.getSnmpProxyFor(current);
    }

    public int getSnmpVersion(int current) {
        return this.m_params.getSnmpVersion(current);
    }

    public int getSnmpMaxVarsPerPdu(int current) {
        return this.m_params.getSnmpMaxVarsPerPdu(current);
    }

    public int getSnmpMaxRepetitions(int current) {
        return this.m_params.getSnmpMaxRepetitions(current);
    }

    public int getSnmpMaxRequestSize(int current) {
        return this.m_params.getSnmpMaxRequestSize(current);
    }

    public String getSnmpSecurityName(String current) {
        return this.m_params.getSnmpSecurityName(current);
    }

    public String getSnmpAuthPassPhrase(String current) {
        return this.m_params.getSnmpAuthPassPhrase(current);
    }

    public String getSnmpAuthProtocol(String current) {
        return this.m_params.getSnmpAuthProtocol(current);
    }

    public String getSnmpPrivPassPhrase(String current) {
        return this.m_params.getSnmpPrivPassPhrase(current);
    }

    public String getSnmpPrivProtocol(String current) {
        return this.m_params.getSnmpPrivProtocol(current);
    }

    private DataCollectionConfigDao getDataCollectionConfigDao() {
        if (this.m_dataCollectionConfigDao == null) {
            this.setDataCollectionConfigDao(DataCollectionConfigFactory.getInstance());
        }
        return this.m_dataCollectionConfigDao;
    }

    public void setDataCollectionConfigDao(DataCollectionConfigDao config) {
        this.m_dataCollectionConfigDao = config;
    }

    public String getStorageFlag() {
        String collectionName = this.getName();
        String storageFlag = this.getDataCollectionConfigDao().getSnmpStorageFlag(collectionName);
        if (storageFlag == null) {
            LOG.warn("getStorageFlag: Configuration error, failed to retrieve SNMP storage flag for collection: {}", (Object)collectionName);
            storageFlag = SnmpCollector.SNMP_STORAGE_PRIMARY;
        }
        return storageFlag;
    }

    public String toString() {
        return this.getName();
    }

    public SnmpCollectionSet createCollectionSet(SnmpCollectionAgent agent) {
        return new SnmpCollectionSet(agent, this);
    }

    private List<SnmpAttributeType> getIndexedAttributeTypes(SnmpCollectionAgent agent) {
        if (this.m_indexedAttributeTypes == null) {
            this.m_indexedAttributeTypes = this.loadAttributeTypes(agent, -2);
        }
        return this.m_indexedAttributeTypes;
    }

    public List<SnmpAttributeType> getIndexedAttributeTypesForResourceType(SnmpCollectionAgent agent, ResourceType resourceType) {
        LinkedList<SnmpAttributeType> resAttrTypes = new LinkedList<SnmpAttributeType>();
        for (SnmpAttributeType attrType : this.getIndexedAttributeTypes(agent)) {
            if (!attrType.getResourceType().equals(resourceType)) continue;
            resAttrTypes.add(attrType);
        }
        return resAttrTypes;
    }

    public List<SnmpAttributeType> getNodeAttributeTypes(SnmpCollectionAgent agent) {
        if (this.m_nodeAttributeTypes == null) {
            this.m_nodeAttributeTypes = this.loadAttributeTypes(agent, -1);
        }
        return this.m_nodeAttributeTypes;
    }

    public List<SnmpAttributeType> loadAttributeTypes(SnmpCollectionAgent agent, int ifType) {
        String sysObjectId = agent.getSysObjectId();
        String hostAddress = agent.getHostAddress();
        List oidList = this.getDataCollectionConfigDao().getMibObjectList(this.getName(), sysObjectId, hostAddress, ifType);
        HashMap<String, AttributeGroupType> groupTypes = new HashMap<String, AttributeGroupType>();
        LinkedList<SnmpAttributeType> typeList = new LinkedList<SnmpAttributeType>();
        for (MibObject mibObject : oidList) {
            String instanceName = mibObject.getInstance();
            AttributeGroupType groupType = this.findGroup(groupTypes, mibObject);
            SnmpAttributeType attrType = SnmpAttributeType.create(this.getResourceType(agent, instanceName), this.getName(), mibObject, groupType);
            groupType.addAttributeType((CollectionAttributeType)attrType);
            typeList.add(attrType);
        }
        LOG.debug("getAttributeTypes({}, {}): {}", new Object[]{agent, ifType, typeList});
        return typeList;
    }

    private AttributeGroupType findGroup(Map<String, AttributeGroupType> groupTypes, MibObject mibObject) {
        AttributeGroupType groupType = groupTypes.get(mibObject.getGroupName());
        if (groupType == null) {
            groupType = new AttributeGroupType(mibObject.getGroupName(), mibObject.getGroupIfType());
            groupTypes.put(mibObject.getGroupName(), groupType);
        }
        return groupType;
    }

    public ResourceType getResourceType(SnmpCollectionAgent agent, String instanceName) {
        if ("ifIndex".equals(instanceName)) {
            return this.getIfResourceType(agent);
        }
        if (this.getGenericIndexResourceType(agent, instanceName) != null) {
            return this.getGenericIndexResourceType(agent, instanceName);
        }
        return this.getNodeResourceType(agent);
    }

    public NodeResourceType getNodeResourceType(SnmpCollectionAgent agent) {
        if (this.m_nodeResourceType == null) {
            this.m_nodeResourceType = new NodeResourceType(agent, this);
        }
        return this.m_nodeResourceType;
    }

    public IfResourceType getIfResourceType(SnmpCollectionAgent agent) {
        if (this.m_ifResourceType == null) {
            this.m_ifResourceType = new IfResourceType(agent, this);
        }
        return this.m_ifResourceType;
    }

    public IfAliasResourceType getIfAliasResourceType(SnmpCollectionAgent agent) {
        if (this.m_ifAliasResourceType == null) {
            this.m_ifAliasResourceType = new IfAliasResourceType(agent, this, this.m_params, this.getIfResourceType(agent));
        }
        return this.m_ifAliasResourceType;
    }

    public Collection<ResourceType> getGenericIndexResourceTypes(SnmpCollectionAgent agent) {
        return Collections.unmodifiableCollection(this.getGenericIndexResourceTypeMap(agent).values());
    }

    private Map<String, ResourceType> getGenericIndexResourceTypeMap(SnmpCollectionAgent agent) {
        if (this.m_genericIndexResourceTypes == null) {
            Collection configuredResourceTypes = this.getDataCollectionConfigDao().getConfiguredResourceTypes().values();
            HashMap<String, ResourceType> resourceTypes = new HashMap<String, ResourceType>();
            for (org.opennms.netmgt.config.datacollection.ResourceType configuredResourceType : configuredResourceTypes) {
                try {
                    resourceTypes.put(configuredResourceType.getName(), new GenericIndexResourceType(agent, this, configuredResourceType));
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Ignoring resource type {} ({}) because it is not properly configured.", (Object)configuredResourceType.getLabel(), (Object)configuredResourceType.getName());
                }
            }
            this.m_genericIndexResourceTypes = resourceTypes;
        }
        return this.m_genericIndexResourceTypes;
    }

    private ResourceType getGenericIndexResourceType(SnmpCollectionAgent agent, String name) {
        return this.getGenericIndexResourceTypeMap(agent).get(name);
    }

    private Collection<ResourceType> getResourceTypes(SnmpCollectionAgent agent) {
        HashSet<ResourceType> set = new HashSet<ResourceType>(3);
        set.add(this.getNodeResourceType(agent));
        set.add(this.getIfResourceType(agent));
        set.add(this.getIfAliasResourceType(agent));
        set.addAll(this.getGenericIndexResourceTypeMap(agent).values());
        return set;
    }

    public Collection<SnmpAttributeType> getAttributeTypes(SnmpCollectionAgent agent) {
        HashSet<SnmpAttributeType> set = new HashSet<SnmpAttributeType>();
        for (ResourceType resourceType : this.getResourceTypes(agent)) {
            set.addAll(resourceType.getAttributeTypes());
        }
        return set;
    }

    public Collection<? extends CollectionResource> getResources(SnmpCollectionAgent agent) {
        LinkedList<? extends SnmpCollectionResource> resources = new LinkedList<SnmpCollectionResource>();
        for (ResourceType resourceType : this.getResourceTypes(agent)) {
            resources.addAll(resourceType.getResources());
        }
        return resources;
    }

    boolean isSelectCollectionOnly() {
        return this.getStorageFlag().equals(SnmpCollector.SNMP_STORAGE_PRIMARY) || this.getStorageFlag().equals(SnmpCollector.SNMP_STORAGE_SELECT);
    }

    public List<SnmpAttributeType> loadAliasAttributeTypes(SnmpCollectionAgent agent) {
        IfAliasResourceType resType = this.getIfAliasResourceType(agent);
        MibObject ifAliasMibObject = new MibObject();
        ifAliasMibObject.setOid(".1.3.6.1.2.1.31.1.1.1.18");
        ifAliasMibObject.setAlias("ifAlias");
        ifAliasMibObject.setType("string");
        ifAliasMibObject.setInstance("ifIndex");
        ifAliasMibObject.setGroupName("aliasedResource");
        ifAliasMibObject.setGroupIfType("all");
        AttributeGroupType groupType = new AttributeGroupType(ifAliasMibObject.getGroupName(), ifAliasMibObject.getGroupIfType());
        SnmpAttributeType type = SnmpAttributeType.create(resType, resType.getCollectionName(), ifAliasMibObject, groupType);
        return Collections.singletonList(type);
    }

    public List<SnmpAttributeType> getAliasAttributeTypes(SnmpCollectionAgent agent) {
        if (this.m_aliasAttributeTypes == null) {
            this.m_aliasAttributeTypes = this.loadAliasAttributeTypes(agent);
        }
        return this.m_aliasAttributeTypes;
    }
}

