/*
 * Decompiled with CFR 0.152.
 */
package simple.http.serve;

import java.io.IOException;
import simple.http.serve.BufferedContent;
import simple.http.serve.Content;
import simple.http.serve.ContentException;
import simple.http.serve.ContentFactory;
import simple.http.serve.Context;
import simple.http.serve.StreamContent;
import simple.util.cache.TimeCache;

public class CacheContentFactory
implements ContentFactory {
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final int DEFAULT_SIZE = 8192;
    private static final int DEFAULT_LOCKS = 10;
    private static final int DEFAULT_LIMIT = 6;
    protected TimeCache cache;
    protected int size;

    protected CacheContentFactory() {
        this(8192);
    }

    public CacheContentFactory(int size) {
        this(size, 10, 6);
    }

    public CacheContentFactory(int size, int regions, int limit) {
        this.cache = new TimeCache(regions, limit);
        this.size = size;
    }

    public Content getInstance(Context context, String target) throws ContentException {
        try {
            if (target.indexOf(63) < 0) {
                return this.getContent(context, target, 60000);
            }
            return this.getContent(context, target);
        }
        catch (IOException e) {
            throw new ContentException(target);
        }
    }

    protected Content getContent(Context context, String target, int timeout) throws IOException {
        Object data = this.cache.lookup(target);
        if (data != null) {
            return (Content)data;
        }
        data = this.getContent(context, target);
        this.cache.cache(target, data, timeout);
        return (Content)data;
    }

    protected Content getContent(Context context, String target) throws IOException {
        if (context.getFile(target).length() <= (long)this.size) {
            return new BufferedContent(context, target);
        }
        return new StreamContent(context, target);
    }
}

