/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jmx.impl.connection.connectors;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionWrapper;
import org.opennms.netmgt.jmx.impl.connection.connectors.Jsr160ConnectionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Jsr160ConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(Jsr160ConnectionFactory.class);

    public static JmxServerConnectionWrapper getMBeanServerConnection(Map<String, ?> propertiesMap, InetAddress address) throws IOException {
        String factory = ParameterMap.getKeyedString(propertiesMap, (String)"factory", (String)"STANDARD");
        int port = ParameterMap.getKeyedInteger(propertiesMap, (String)"port", (int)1099);
        String protocol = ParameterMap.getKeyedString(propertiesMap, (String)"protocol", (String)"rmi");
        String urlPath = ParameterMap.getKeyedString(propertiesMap, (String)"urlPath", (String)"/jmxrmi");
        String username = ParameterMap.getKeyedString(propertiesMap, (String)"username", null);
        String password = ParameterMap.getKeyedString(propertiesMap, (String)"password", null);
        Object connectionWrapper = null;
        JMXServiceURL url = null;
        String hostAddress = InetAddressUtils.str((InetAddress)address);
        LOG.debug("JMX: {} - service:{}//{}:{}{}", new Object[]{factory, protocol, hostAddress, port, urlPath});
        if (factory == null || factory.equals("STANDARD")) {
            url = Jsr160ConnectionFactory.getUrl(address, port, protocol, urlPath);
            JMXConnector connector = JMXConnectorFactory.connect(url);
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            return new Jsr160ConnectionWrapper(connector, connection);
        }
        if (factory.equals("PASSWORD-CLEAR")) {
            HashMap<String, String[]> env = new HashMap<String, String[]>();
            String[] credentials = new String[]{username, password};
            env.put("jmx.remote.credentials", credentials);
            url = Jsr160ConnectionFactory.getUrl(address, port, protocol, urlPath);
            JMXConnector connector = JMXConnectorFactory.newJMXConnector(url, null);
            connector.connect(env);
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            return new Jsr160ConnectionWrapper(connector, connection);
        }
        throw new IOException("Unsupported connection factory: " + factory);
    }

    public static JMXServiceURL getUrl(InetAddress address, int port, String protocol, String urlPath) throws MalformedURLException {
        if (protocol.equalsIgnoreCase("jmxmp") || protocol.equalsIgnoreCase("remoting-jmx")) {
            return new JMXServiceURL(protocol, InetAddressUtils.str((InetAddress)address), port, urlPath);
        }
        return new JMXServiceURL("service:jmx:" + protocol + ":///jndi/" + protocol + "://" + InetAddressUtils.str((InetAddress)address) + ":" + port + urlPath);
    }
}

