/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb;

import java.io.FileWriter;
import java.io.Writer;
import java.util.List;
import org.opennms.core.xml.AbstractJaxbConfigDao;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.javamail.End2endMailConfig;
import org.opennms.netmgt.config.javamail.JavamailConfiguration;
import org.opennms.netmgt.config.javamail.ReadmailConfig;
import org.opennms.netmgt.config.javamail.SendmailConfig;
import org.opennms.netmgt.dao.api.JavaMailConfigurationDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessResourceFailureException;

public class DefaultJavamailConfigurationDao
extends AbstractJaxbConfigDao<JavamailConfiguration, JavamailConfiguration>
implements JavaMailConfigurationDao {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJavamailConfigurationDao.class);

    public DefaultJavamailConfigurationDao() {
        super(JavamailConfiguration.class, "Javamail configuration");
    }

    public DefaultJavamailConfigurationDao(Class<JavamailConfiguration> entityClass, String description) {
        super(entityClass, description);
    }

    public JavamailConfiguration translateConfig(JavamailConfiguration castorConfig) {
        return castorConfig;
    }

    public ReadmailConfig getDefaultReadmailConfig() {
        String name = ((JavamailConfiguration)this.getContainer().getObject()).getDefaultReadConfigName();
        return this.getReadMailConfig(name);
    }

    public void setDefaultReadmailConfig(String readmailConfigName) {
        if (this.getReadMailConfig(readmailConfigName) != null) {
            ((JavamailConfiguration)this.getContainer().getObject()).setDefaultReadConfigName(readmailConfigName);
        }
    }

    public ReadmailConfig getReadMailConfig(String name) {
        ReadmailConfig config = null;
        List<ReadmailConfig> configs = this.getReadmailConfigs();
        for (ReadmailConfig readmailConfig : configs) {
            if (!readmailConfig.getName().equals(name)) continue;
            config = readmailConfig;
        }
        return config;
    }

    public List<ReadmailConfig> getReadmailConfigs() {
        return ((JavamailConfiguration)this.getContainer().getObject()).getReadmailConfigCollection();
    }

    public SendmailConfig getDefaultSendmailConfig() {
        String name = ((JavamailConfiguration)this.getContainer().getObject()).getDefaultSendConfigName();
        return this.getSendMailConfig(name);
    }

    public void setDefaultSendmailConfig(String sendmailConfigName) {
        if (this.getSendMailConfig(sendmailConfigName) != null) {
            ((JavamailConfiguration)this.getContainer().getObject()).setDefaultSendConfigName(sendmailConfigName);
        }
    }

    public SendmailConfig getSendMailConfig(String name) {
        SendmailConfig config = null;
        List<SendmailConfig> configs = this.getSendmailConfigs();
        for (SendmailConfig sendmailConfig : configs) {
            if (!sendmailConfig.getName().equals(name)) continue;
            config = sendmailConfig;
        }
        return config;
    }

    public void addSendMailConfig(SendmailConfig sendmailConfig) {
        int index = -1;
        List<SendmailConfig> configs = this.getSendmailConfigs();
        for (int i = 0; i < configs.size(); ++i) {
            if (!configs.get(i).getName().equals(sendmailConfig.getName())) continue;
            index = i;
            break;
        }
        if (index > -1) {
            configs.remove(index);
            configs.add(index, sendmailConfig);
        } else {
            configs.add(sendmailConfig);
        }
    }

    public boolean removeSendMailConfig(String sendmailConfig) {
        int index = -1;
        List<SendmailConfig> configs = this.getSendmailConfigs();
        for (int i = 0; i < configs.size(); ++i) {
            if (!configs.get(i).getName().equals(sendmailConfig)) continue;
            index = i;
            break;
        }
        if (index > -1) {
            configs.remove(index);
            return true;
        }
        return false;
    }

    public List<SendmailConfig> getSendmailConfigs() {
        return ((JavamailConfiguration)this.getContainer().getObject()).getSendmailConfigCollection();
    }

    public End2endMailConfig getEnd2endConfig(String name) {
        End2endMailConfig config = null;
        List<End2endMailConfig> configs = this.getEnd2EndConfigs();
        for (End2endMailConfig end2endMailConfig : configs) {
            if (!end2endMailConfig.getName().equals(name)) continue;
            config = end2endMailConfig;
        }
        return config;
    }

    public void addReadMailConfig(ReadmailConfig readmailConfig) {
        int index = -1;
        List<ReadmailConfig> configs = this.getReadmailConfigs();
        for (int i = 0; i < configs.size(); ++i) {
            if (!configs.get(i).getName().equals(readmailConfig.getName())) continue;
            index = i;
            break;
        }
        if (index > -1) {
            configs.remove(index);
            configs.add(index, readmailConfig);
        } else {
            configs.add(readmailConfig);
        }
    }

    public boolean removeReadMailConfig(String readmailConfig) {
        int index = -1;
        List<ReadmailConfig> configs = this.getReadmailConfigs();
        for (int i = 0; i < configs.size(); ++i) {
            if (!configs.get(i).getName().equals(readmailConfig)) continue;
            index = i;
            break;
        }
        if (index > -1) {
            configs.remove(index);
            return true;
        }
        return false;
    }

    public List<End2endMailConfig> getEnd2EndConfigs() {
        return ((JavamailConfiguration)this.getContainer().getObject()).getEnd2endMailConfigCollection();
    }

    public void addEnd2endMailConfig(End2endMailConfig end2endConfig) {
        int index = -1;
        List<End2endMailConfig> configs = this.getEnd2EndConfigs();
        for (int i = 0; i < configs.size(); ++i) {
            if (!configs.get(i).getName().equals(end2endConfig.getName())) continue;
            index = i;
            break;
        }
        if (index > -1) {
            configs.remove(index);
            configs.add(index, end2endConfig);
        } else {
            configs.add(end2endConfig);
        }
    }

    public boolean removeEnd2endConfig(String end2endConfig) {
        int index = -1;
        List<End2endMailConfig> configs = this.getEnd2EndConfigs();
        for (int i = 0; i < configs.size(); ++i) {
            if (!configs.get(i).getName().equals(end2endConfig)) continue;
            index = i;
            break;
        }
        if (index > -1) {
            configs.remove(index);
            return true;
        }
        return false;
    }

    public void verifyMarshaledConfiguration() throws IllegalStateException {
    }

    public void reloadConfiguration() throws DataAccessResourceFailureException {
        this.getContainer().reload();
        this.verifyMarshaledConfiguration();
    }

    public synchronized void saveConfiguration() {
        try {
            JaxbUtils.marshal((Object)this.getContainer().getObject(), (Writer)new FileWriter(this.getContainer().getFile()));
        }
        catch (Exception e) {
            LOG.error("Can't save JavaMail configuration.", (Throwable)e);
        }
    }
}

