/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.opennms.netmgt.dao.api.BridgeMacLinkDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.topology.BridgeMacTopologyLink;
import org.springframework.orm.hibernate3.HibernateCallback;

public class BridgeMacLinkDaoHibernate
extends AbstractDaoHibernate<BridgeMacLink, Integer>
implements BridgeMacLinkDao {
    private static final String SQL_GET_MAC_LINKS = "select mlink.id as source_id, mlink.nodeid as source_nodeid, n.nodelabel as sourcenodelabel, n.nodesysoid as sourcenodesysoid, n.nodesyslocation as sourcenodelocation,  n.nodetype as sourcenodetype,  mlink.bridgeport as bridgeport, mlink.bridgeportifindex as bridgeportifindex, mlink.bridgeportifname as bridgeportifname, mlink.vlan as vlan, ip.nodeid as target_nodeid, np.nodelabel as targetnodelabel,np.nodesysoid as targetnodesysoid,np.nodesyslocation as targetnodelocation, np.nodetype as targetnodetype, ntm.physaddress as target_mac,  snmp.snmpifindex as target_ifindex, ip.ipaddr as target_ifname, snmp.snmpifindex as target_bridgeport, ip.id as target_id, mlink.bridgemaclinklastpolltime as lastPollTime from bridgemaclink as mlink left join ipnettomedia as ntm on mlink.macaddress = ntm.physaddress left join ipinterface ip on ip.ipaddr = ntm.netaddress left join snmpinterface snmp on ip.snmpInterfaceId = snmp.id left join node n on mlink.nodeid = n.nodeid left join node np on ip.nodeid = np.nodeid where ip.nodeid is not null order by source_nodeid, bridgeport;";
    private static final String SQL_GET_BRIDGE_LINKS = "select mlink.id as id, mlink.nodeid as source_nodeid, n.nodelabel as sourcenodelabel, n.nodesysoid as sourcenodesysoid, n.nodesyslocation as sourcenodelocation, n.nodetype as sourcenodetype, mlink.bridgeport as bridgeport, mlink.bridgeportifindex as bridgeportifindex, mlink.bridgeportifname as bridgeportifname, mlink.vlan as vlan, np.nodeid as target_nodeid, np.nodelabel as targetnodelabel, np.nodesysoid as targetnodesysoid, np.nodesyslocation as targetnodelocation, np.nodetype as targetnodetype, plink.macaddress as target_mac, plink.bridgeportifindex as target_ifindex, plink.bridgeportifname as target_ifname, plink.bridgeport as target_bridgeport, plink.id as target_id, mlink.bridgemaclinklastpolltime as lastPollTime from bridgemaclink as mlink left join bridgemaclink as plink on mlink.macaddress = plink.macaddress left join node n on mlink.nodeid = n.nodeid left join node np on plink.nodeid = np.nodeid where mlink.nodeid < plink.nodeid order by source_nodeid, bridgeport;";

    public BridgeMacLinkDaoHibernate() {
        super(BridgeMacLink.class);
    }

    public List<BridgeMacLink> findByNodeId(Integer id) {
        return this.find("from BridgeMacLink rec where rec.node.id = ?", id);
    }

    public BridgeMacLink getByNodeIdBridgePortMac(Integer id, Integer port, String mac) {
        return (BridgeMacLink)this.findUnique("from BridgeMacLink rec where rec.node.id = ?  and rec.bridgePort = ? and rec.macAddress = ? ", id, port, mac);
    }

    public List<BridgeMacLink> findByMacAddress(String mac) {
        return this.find("from BridgeMacLink rec where rec.macAddress = ?", mac);
    }

    public void deleteByNodeIdOlderThen(Integer nodeId, Date now) {
        for (BridgeMacLink elem : this.find("from BridgeMacLink rec where rec.node.id = ? and rec.bridgeMacLinkLastPollTime < ?", nodeId, now)) {
            this.delete(elem);
        }
    }

    private List<BridgeMacTopologyLink> convertObjectToTopologyLink(List<Object[]> list) {
        ArrayList<BridgeMacTopologyLink> topoLinks = new ArrayList<BridgeMacTopologyLink>();
        for (Object[] objs : list) {
            topoLinks.add(new BridgeMacTopologyLink((Integer)objs[0], (Integer)objs[1], (String)objs[2], (String)objs[3], (String)objs[4], OnmsNode.NodeType.getNodeTypeFromChar((char)((Character)objs[5]).charValue()), (Integer)objs[6], (Integer)objs[7], (String)objs[8], (Integer)objs[9], (Integer)objs[10], (String)objs[11], (String)objs[12], (String)objs[13], OnmsNode.NodeType.getNodeTypeFromChar((char)((Character)objs[14]).charValue()), (String)objs[15], (Integer)objs[16], (String)objs[17], (Integer)objs[18], (Integer)objs[19], (Date)objs[20]));
        }
        return topoLinks;
    }

    public List<BridgeMacTopologyLink> getAllBridgeLinksToIpAddrToNodes() {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<BridgeMacTopologyLink>>(){

            public List<BridgeMacTopologyLink> doInHibernate(Session session) throws HibernateException, SQLException {
                return BridgeMacLinkDaoHibernate.this.convertObjectToTopologyLink(session.createSQLQuery(BridgeMacLinkDaoHibernate.SQL_GET_MAC_LINKS).list());
            }
        });
    }

    public List<BridgeMacTopologyLink> getAllBridgeLinksToBridgeNodes() {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<BridgeMacTopologyLink>>(){

            public List<BridgeMacTopologyLink> doInHibernate(Session session) throws HibernateException, SQLException {
                return BridgeMacLinkDaoHibernate.this.convertObjectToTopologyLink(session.createSQLQuery(BridgeMacLinkDaoHibernate.SQL_GET_BRIDGE_LINKS).list());
            }
        });
    }
}

