/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jna;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opennms.netmgt.icmp.EchoPacket;
import org.opennms.netmgt.icmp.LogPrefixPreservingPingResponseCallback;
import org.opennms.netmgt.icmp.PingResponseCallback;
import org.opennms.netmgt.icmp.jna.JnaPingReply;
import org.opennms.netmgt.icmp.jna.JnaPingRequestId;
import org.opennms.netmgt.icmp.jna.V4Pinger;
import org.opennms.netmgt.icmp.jna.V6Pinger;
import org.opennms.protocols.rt.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JnaPingRequest
implements Request<JnaPingRequestId, JnaPingRequest, JnaPingReply>,
EchoPacket {
    private static final Logger LOG = LoggerFactory.getLogger(JnaPingRequest.class);
    private static long s_nextTid = 1L;
    private final JnaPingRequestId m_id;
    private final PingResponseCallback m_callback;
    private final int m_retries;
    private final long m_timeout;
    private final int m_packetsize;
    private long m_expiration = -1L;
    private final AtomicBoolean m_processed = new AtomicBoolean(false);

    public static final synchronized long getNextTID() {
        return s_nextTid++;
    }

    public JnaPingRequest(JnaPingRequestId id, long timeout, int retries, int packetsize, PingResponseCallback cb) {
        this.m_id = id;
        this.m_retries = retries;
        this.m_packetsize = packetsize;
        this.m_timeout = timeout;
        this.m_callback = new LogPrefixPreservingPingResponseCallback(cb);
    }

    public JnaPingRequest(InetAddress addr, int identifier, int sequenceId, long threadId, long timeout, int retries, int packetsize, PingResponseCallback cb) {
        this(new JnaPingRequestId(addr, identifier, sequenceId, threadId), timeout, retries, packetsize, cb);
    }

    public JnaPingRequest(InetAddress addr, int identifier, int sequenceId, long timeout, int retries, int packetsize, PingResponseCallback cb) {
        this(addr, identifier, sequenceId, JnaPingRequest.getNextTID(), timeout, retries, packetsize, cb);
    }

    public boolean processResponse(JnaPingReply reply) {
        try {
            LOG.debug("{}: Ping Response Received for request: {}", (Object)System.currentTimeMillis(), (Object)this);
            this.m_callback.handleResponse(this.getAddress(), (EchoPacket)reply);
        }
        finally {
            this.setProcessed(true);
        }
        return true;
    }

    public JnaPingRequest processTimeout() {
        try {
            JnaPingRequest returnval = null;
            if (this.isExpired()) {
                if (this.m_retries > 0) {
                    returnval = new JnaPingRequest(this.m_id, this.m_timeout, this.m_retries - 1, this.m_packetsize, this.m_callback);
                    LOG.debug("{}: Retrying Ping Request {}", (Object)System.currentTimeMillis(), (Object)returnval);
                } else {
                    LOG.debug("{}: Ping Request Timed out {}", (Object)System.currentTimeMillis(), (Object)this);
                    this.m_callback.handleTimeout(this.getAddress(), (EchoPacket)this);
                }
            }
            JnaPingRequest jnaPingRequest = returnval;
            return jnaPingRequest;
        }
        finally {
            this.setProcessed(true);
        }
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.m_expiration;
    }

    public long getDelay(TimeUnit unit) {
        return unit.convert(this.m_expiration - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public int compareTo(Delayed request) {
        long otherDelay;
        long myDelay = this.getDelay(TimeUnit.MILLISECONDS);
        if (myDelay < (otherDelay = request.getDelay(TimeUnit.MILLISECONDS))) {
            return -1;
        }
        if (myDelay == otherDelay) {
            return 0;
        }
        return 1;
    }

    public JnaPingRequestId getId() {
        return this.m_id;
    }

    public void processError(Throwable t) {
        try {
            this.m_callback.handleError(this.getAddress(), (EchoPacket)this, t);
        }
        finally {
            this.setProcessed(true);
        }
    }

    private void setProcessed(boolean processed) {
        this.m_processed.set(processed);
    }

    public boolean isProcessed() {
        return this.m_processed.get();
    }

    public void send(V4Pinger v4, V6Pinger v6) {
        InetAddress addr = this.getAddress();
        if (addr instanceof Inet4Address) {
            this.send(v4, (Inet4Address)addr);
        } else if (addr instanceof Inet6Address) {
            this.send(v6, (Inet6Address)addr);
        }
    }

    public InetAddress getAddress() {
        return this.m_id.getAddress();
    }

    public void send(V6Pinger v6, Inet6Address addr6) {
        try {
            LOG.debug("{}: Sending Ping Request: {}", (Object)System.currentTimeMillis(), (Object)this);
            this.m_expiration = System.currentTimeMillis() + this.m_timeout;
            v6.ping(addr6, this.m_id.getIdentifier(), this.m_id.getSequenceNumber(), this.m_id.getThreadId(), 1L, 0L, this.m_packetsize);
        }
        catch (Throwable t) {
            this.m_callback.handleError(this.getAddress(), (EchoPacket)this, t);
        }
    }

    public void send(V4Pinger v4, Inet4Address addr4) {
        try {
            LOG.debug("{}: Sending Ping Request: {}", (Object)System.currentTimeMillis(), (Object)this);
            this.m_expiration = System.currentTimeMillis() + this.m_timeout;
            v4.ping(addr4, this.m_id.getIdentifier(), this.m_id.getSequenceNumber(), this.m_id.getThreadId(), 1L, 0L, this.m_packetsize);
        }
        catch (Throwable t) {
            this.m_callback.handleError(this.getAddress(), (EchoPacket)this, t);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append("ID=").append(this.m_id).append(',');
        sb.append("Retries=").append(this.m_retries).append(",");
        sb.append("Timeout=").append(this.m_timeout).append(",");
        sb.append("Packet-Size=").append(this.m_packetsize).append(",");
        sb.append("Expiration=").append(this.m_expiration).append(',');
        sb.append("Callback=").append(this.m_callback);
        sb.append("]");
        return sb.toString();
    }

    public boolean isEchoReply() {
        return false;
    }

    public int getIdentifier() {
        return this.m_id.getIdentifier();
    }

    public int getSequenceNumber() {
        return this.m_id.getSequenceNumber();
    }

    public long getThreadId() {
        return this.m_id.getThreadId();
    }

    public long getReceivedTimeNanos() {
        throw new UnsupportedOperationException("EchoPacket.getReceivedTimeNanos is not yet implemented");
    }

    public long getSentTimeNanos() {
        throw new UnsupportedOperationException("EchoPacket.getSentTimeNanos is not yet implemented");
    }

    public double elapsedTime(TimeUnit timeUnit) {
        throw new UnsupportedOperationException("EchoPacket.elapsedTime is not yet implemented");
    }
}

