/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.netmgt.model.OnmsNode;

@Entity
@Table(name="bridgeMacLink")
public class BridgeMacLink {
    private Integer m_id;
    private OnmsNode m_node;
    private Integer m_bridgePort;
    private Integer m_bridgePortIfIndex;
    private String m_bridgePortIfName;
    private String m_macAddress;
    private Integer m_vlan;
    private BridgeDot1qTpFdbStatus m_status;
    private Date m_bridgeMacLinkCreateTime = new Date();
    private Date m_bridgeMacLinkLastPollTime;

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @Column(name="bridgePort", nullable=false)
    public Integer getBridgePort() {
        return this.m_bridgePort;
    }

    public void setBridgePort(Integer bridgePort) {
        this.m_bridgePort = bridgePort;
    }

    @Column(name="bridgePortIfIndex", nullable=true)
    public Integer getBridgePortIfIndex() {
        return this.m_bridgePortIfIndex;
    }

    public void setBridgePortIfIndex(Integer bridgePortIfIndex) {
        this.m_bridgePortIfIndex = bridgePortIfIndex;
    }

    @Column(name="bridgePortIfName", length=32, nullable=true)
    public String getBridgePortIfName() {
        return this.m_bridgePortIfName;
    }

    public void setBridgePortIfName(String bridgePortIfName) {
        this.m_bridgePortIfName = bridgePortIfName;
    }

    @Column(name="vlan", nullable=true)
    public Integer getVlan() {
        return this.m_vlan;
    }

    public void setVlan(Integer vlan) {
        this.m_vlan = vlan;
    }

    @Column(name="macAddress", length=12, nullable=false)
    public String getMacAddress() {
        return this.m_macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.m_macAddress = macAddress;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="bridgeMacLinkCreateTime", nullable=false)
    public Date getBridgeMacLinkCreateTime() {
        return this.m_bridgeMacLinkCreateTime;
    }

    public void setBridgeMacLinkCreateTime(Date bridgeMacLinkCreateTime) {
        this.m_bridgeMacLinkCreateTime = bridgeMacLinkCreateTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="bridgeMacLinkLastPollTime", nullable=false)
    public Date getBridgeMacLinkLastPollTime() {
        return this.m_bridgeMacLinkLastPollTime;
    }

    public void setBridgeMacLinkLastPollTime(Date bridgeMacLinkLastPollTime) {
        this.m_bridgeMacLinkLastPollTime = bridgeMacLinkLastPollTime;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("Nodeid", (Object)this.m_node.getId()).append("bridgePort", (Object)this.m_bridgePort).append("bridgePortIfIndex", (Object)this.m_bridgePortIfIndex).append("bridgePortIfName", (Object)this.m_bridgePortIfName).append("vlan", (Object)this.m_vlan).append("macAddress", (Object)this.m_macAddress).append("m_bridgeMacLinkCreateTime", (Object)this.m_bridgeMacLinkCreateTime).append("m_bridgeMacLinkLastPollTime", (Object)this.m_bridgeMacLinkLastPollTime).toString();
    }

    public void merge(BridgeMacLink element) {
        if (element == null) {
            return;
        }
        this.setBridgePortIfIndex(element.getBridgePortIfIndex());
        this.setBridgePortIfName(element.getBridgePortIfName());
        this.setVlan(element.getVlan());
        this.setBridgeMacLinkLastPollTime(element.getBridgeMacLinkCreateTime());
    }

    @Transient
    public BridgeDot1qTpFdbStatus getBridgeDot1qTpFdbStatus() {
        return this.m_status;
    }

    public void setBridgeDot1qTpFdbStatus(BridgeDot1qTpFdbStatus status) {
        this.m_status = status;
    }

    public static enum BridgeDot1qTpFdbStatus {
        DOT1D_TP_FDB_STATUS_OTHER(1),
        DOT1D_TP_FDB_STATUS_INVALID(2),
        DOT1D_TP_FDB_STATUS_LEARNED(3),
        DOT1D_TP_FDB_STATUS_SELF(4),
        DOT1D_TP_FDB_STATUS_MGMT(5);

        private int m_type;
        protected static final Map<Integer, String> s_typeMap;

        private BridgeDot1qTpFdbStatus(int type) {
            this.m_type = type;
        }

        public static String getTypeString(Integer code) {
            if (s_typeMap.containsKey(code)) {
                return s_typeMap.get(code);
            }
            return "other-vendor-specific";
        }

        public Integer getValue() {
            return this.m_type;
        }

        public static BridgeDot1qTpFdbStatus get(Integer code) {
            if (code == null) {
                throw new IllegalArgumentException("Cannot create BridgeDot1qTpFdbStatus from null code");
            }
            if (code <= 0) {
                throw new IllegalArgumentException("Cannot create BridgeDot1qTpFdbStatus from" + code + " code");
            }
            switch (code) {
                case 1: {
                    return DOT1D_TP_FDB_STATUS_OTHER;
                }
                case 2: {
                    return DOT1D_TP_FDB_STATUS_INVALID;
                }
                case 3: {
                    return DOT1D_TP_FDB_STATUS_LEARNED;
                }
                case 4: {
                    return DOT1D_TP_FDB_STATUS_SELF;
                }
                case 5: {
                    return DOT1D_TP_FDB_STATUS_MGMT;
                }
            }
            throw new IllegalArgumentException("Cannot create BridgeDot1qTpFdbStatus from code " + code);
        }

        static {
            s_typeMap = new HashMap<Integer, String>();
            s_typeMap.put(1, "other");
            s_typeMap.put(2, "invalid");
            s_typeMap.put(3, "learned");
            s_typeMap.put(4, "self");
            s_typeMap.put(5, "mgmt");
        }
    }
}

