/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.tcp;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import org.opennms.core.utils.InetAddressUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TcpRecordHandler
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TcpRecordHandler.class);
    private volatile boolean m_stop = false;
    private Thread m_context = null;
    private List<Object> m_xchange;
    private Socket m_connection;
    private OutputStream m_out;
    private StateManager[] m_tokenizer;

    private void closeStream() throws IOException {
        if (this.m_out != null) {
            this.m_out.close();
        }
        this.m_out = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newStream() throws IOException {
        LOG.debug("Opening new PipedOutputStream and adding it to the queue");
        PipedOutputStream pipeOut = new PipedOutputStream();
        try {
            PipedOutputStream pipedOutputStream = pipeOut;
            synchronized (pipedOutputStream) {
                List<Object> list = this.m_xchange;
                synchronized (list) {
                    this.m_xchange.add(pipeOut);
                    this.m_xchange.notify();
                }
                LOG.debug("Added pipe to the xchange list");
                pipeOut.wait();
                LOG.debug("Pipe Signaled");
            }
        }
        catch (InterruptedException e) {
            LOG.debug("An I/O error occured.", (Throwable)e);
            throw new IOException("The thread was interrupted");
        }
        LOG.debug("PipedOutputStream connected");
        this.m_out = pipeOut;
    }

    private void forward(char ch) throws IOException {
        try {
            if (this.m_out != null) {
                this.m_out.write(ch);
            }
        }
        catch (IOException e) {
            LOG.debug("An I/O error occured.", (Throwable)e);
            throw e;
        }
    }

    TcpRecordHandler(Socket s, List<Object> xchange) {
        this.m_xchange = xchange;
        this.m_connection = s;
        this.m_tokenizer = new StateManager[]{new StateManager(0, this){

            @Override
            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == '<') {
                    return 1;
                }
                return this.m_level;
            }
        }, new StateManager(1, this){

            @Override
            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == '/') {
                    return 2;
                }
                return 0;
            }
        }, new StateManager(2, this){

            @Override
            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == 'l') {
                    return 5;
                }
                if (Character.isLetterOrDigit(ch)) {
                    return 3;
                }
                return 0;
            }
        }, new StateManager(3, this){

            @Override
            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == ':') {
                    return 4;
                }
                if (Character.isLetterOrDigit(ch)) {
                    return this.m_level;
                }
                return 0;
            }
        }, new StateManager(4, this){

            @Override
            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == 'l') {
                    return 5;
                }
                return 0;
            }
        }, new StateManager(5, this){

            @Override
            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == 'o') {
                    return 6;
                }
                return 0;
            }
        }, new StateManager(6, this){

            @Override
            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == 'g') {
                    return 7;
                }
                return 0;
            }
        }, new StateManager(7, this){

            @Override
            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == '>') {
                    this.m_handler.closeStream();
                    return 8;
                }
                return 0;
            }
        }, new StateManager(8, this){

            @Override
            int next(char ch) throws IOException {
                if (ch == '<') {
                    this.onTransition(ch);
                    return 1;
                }
                return this.m_level;
            }

            @Override
            void onTransition(char ch) throws IOException {
                this.m_handler.newStream();
                super.onTransition(ch);
            }
        }};
    }

    boolean isAlive() {
        if (this.m_context != null) {
            return this.m_context.isAlive();
        }
        return false;
    }

    void stop() throws InterruptedException {
        this.m_stop = true;
        if (this.m_context != null) {
            LOG.debug("Interrupting thread {}", (Object)this.m_context.getName());
            this.m_context.interrupt();
            LOG.debug("Joining Thread {}", (Object)this.m_context.getName());
            this.m_context.join();
            LOG.debug("Thread {} Joined", (Object)this.m_context.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block24: {
            Thread thread = this.m_context = Thread.currentThread();
            synchronized (thread) {
                this.m_context.notifyAll();
            }
            if (this.m_stop) {
                LOG.debug("Stop flag set before thread startup, thread exiting");
                return;
            }
            LOG.debug("Thread started, remote is {}", (Object)InetAddressUtils.str((InetAddress)this.m_connection.getInetAddress()));
            BufferedInputStream socketIn = null;
            try {
                this.m_connection.setSoTimeout(500);
                socketIn = new BufferedInputStream(this.m_connection.getInputStream());
            }
            catch (IOException e) {
                if (!this.m_stop) {
                    LOG.warn("An I/O Exception occured.", (Throwable)e);
                }
                this.m_xchange.add(e);
                LOG.debug("Thread exiting due to socket exception, stop flag = {}", (Object)this.m_stop);
                return;
            }
            int level = 8;
            int ch = 0;
            boolean moreInput = true;
            while (moreInput) {
                block23: {
                    if (Thread.interrupted()) {
                        LOG.debug("Thread Interrupted");
                        break;
                    }
                    try {
                        ch = ((InputStream)socketIn).read();
                        if (ch == -1) {
                            moreInput = false;
                        }
                        break block23;
                    }
                    catch (InterruptedIOException e) {
                    }
                    catch (EOFException e) {
                        this.m_xchange.add(e);
                        moreInput = false;
                    }
                    catch (IOException e) {
                        this.m_xchange.add(e);
                        if (!this.m_stop) {
                            LOG.warn("An I/O error occured reading from the remote host.", (Throwable)e);
                        }
                        moreInput = false;
                    }
                    continue;
                }
                try {
                    level = this.m_tokenizer[level].next((char)ch);
                }
                catch (IOException e) {
                    if (!this.m_stop) {
                        LOG.warn("An I/O error occured writing to the processor stream.", (Throwable)e);
                        LOG.warn("Discarding the remainder of the event contents");
                        try {
                            this.closeStream();
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                    this.m_xchange.add(e);
                    moreInput = false;
                }
            }
            try {
                if (this.m_out != null) {
                    this.m_out.close();
                }
            }
            catch (IOException e) {
                if (this.m_stop) break block24;
                LOG.warn("An I/O Error occured closing the processor stream.", (Throwable)e);
            }
        }
        this.m_xchange.add(new EOFException("No More Input"));
        LOG.debug("Thread Terminated");
    }

    private static class StateManager {
        protected int m_level;
        protected TcpRecordHandler m_handler;

        StateManager(int level, TcpRecordHandler handler) {
            this.m_level = level;
            this.m_handler = handler;
        }

        int getLevel() {
            return this.m_level;
        }

        int next(char ch) throws IOException {
            this.onTransition(ch);
            return this.m_level;
        }

        void onTransition(char ch) throws IOException {
            this.m_handler.forward(ch);
        }
    }
}

