/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vmmgr;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.vmmgr.DatabaseChecker;
import org.opennms.netmgt.vmmgr.Starter;
import org.opennms.netmgt.vmmgr.StatusGetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller {
    private static final Logger LOG = LoggerFactory.getLogger(Controller.class);
    public static final String CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
    private static final String LOG4J_CATEGORY = "manager";
    private static final String OPENNMS_JVM_DISPLAY_NAME_SUBSTRING = "opennms_bootstrap.jar start";
    public static final String DEFAULT_JMX_RMI_URL = "service:jmx:rmi:///jndi/rmi://127.0.0.1:1099/jmxrmi";
    private boolean m_verbose = false;
    private String m_jmxUrl = "service:jmx:rmi:///jndi/rmi://127.0.0.1:1099/jmxrmi";
    private String m_pid = null;

    public static void main(String[] argv) {
        String command;
        Logging.putPrefix((String)LOG4J_CATEGORY);
        Controller c = new Controller();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-h")) {
                System.out.println("Usage: java org.opennms.netmgt.vmmgr.Controller [<options>] <command>");
                System.out.println("Accepted options:");
                System.out.println("        -p <pid>        PID of the OpenNMS process. Used when the process cannot be autodetected.");
                System.out.println("        -t <timeout>    HTTP connection timeout in seconds.  Defaults to 30.");
                System.out.println("        -u <URL>        JMX RMI URL. Used when we cannot automatically attach to the OpenNMS JVM.");
                System.out.println("        -v              Verbose mode.");
                System.out.println("");
                System.out.println("Accepted commands: start, stop, status, check, dumpThreads, exit");
                System.out.println("");
                System.out.println("The default JMX RMI URL is: service:jmx:rmi:///jndi/rmi://127.0.0.1:1099/jmxrmi");
                System.exit(0);
                continue;
            }
            if (argv[i].equals("-p")) {
                c.setPid(argv[i + 1]);
                ++i;
                continue;
            }
            if (argv[i].equals("-t")) {
                c.setRmiHandshakeTimeout(Integer.parseInt(argv[i + 1]) * 1000);
                ++i;
                continue;
            }
            if (argv[i].equals("-u")) {
                c.setJmxRmiUrl(argv[i + 1]);
                ++i;
                continue;
            }
            if (argv[i].equals("-v")) {
                c.setVerbose(true);
                continue;
            }
            if (i == argv.length - 1) break;
            System.err.println("Invalid command-line option: \"" + argv[i] + "\".  Use \"-h\" option for help.");
            System.exit(1);
        }
        if (argv.length == 0) {
            System.err.println("You must specify a command.  Use \"-h\" option for help");
            System.exit(1);
        }
        if ("start".equals(command = argv[argv.length - 1])) {
            c.start();
        } else if ("stop".equals(command)) {
            System.exit(c.stop());
        } else if ("status".equals(command)) {
            System.exit(c.status());
        } else if ("check".equals(command)) {
            System.exit(c.check());
        } else if ("dumpThreads".equals(command)) {
            System.exit(c.dumpThreads());
        } else if ("exit".equals(command)) {
            System.exit(c.exit());
        } else {
            System.err.println("Invalid command \"" + command + "\".");
            System.err.println("Use \"-h\" option for help.");
            System.exit(1);
        }
    }

    public void start() {
        Starter starter = new Starter();
        starter.startDaemon();
    }

    public int stop() {
        return this.invokeOperation("stop");
    }

    public int status() {
        StatusGetter statusGetter = new StatusGetter(this);
        try {
            statusGetter.queryStatus();
        }
        catch (Throwable t) {
            String message = "error invoking \"status\" operation: " + t.getMessage();
            LOG.error(message, t);
            System.err.println(message);
            return 1;
        }
        switch (statusGetter.getStatus()) {
            case NOT_RUNNING: 
            case CONNECTION_REFUSED: {
                return 3;
            }
            case PARTIALLY_RUNNING: {
                return 160;
            }
            case RUNNING: {
                return 0;
            }
        }
        LOG.error("Unknown status returned from statusGetter.getStatus(): {}", (Object)statusGetter.getStatus());
        return 1;
    }

    public int check() {
        try {
            new DatabaseChecker().check();
        }
        catch (Throwable t) {
            String message = "error invoking \"check\" operation: " + t.getMessage();
            LOG.error(message, t);
            System.err.println(message);
            return 1;
        }
        return 0;
    }

    public int dumpThreads() {
        return this.invokeOperation("dumpThreads");
    }

    public int exit() {
        return this.invokeOperation("doSystemExit");
    }

    public int invokeOperation(String operation) {
        try {
            this.doInvokeOperation(operation);
        }
        catch (Throwable t) {
            String message = "error invoking \"" + operation + "\" operation: " + t.getMessage();
            LOG.error(message, t);
            System.err.println(message);
            return 1;
        }
        return 0;
    }

    public Object doInvokeOperation(String operation) throws MalformedURLException, IOException, InstanceNotFoundException, MalformedObjectNameException, MBeanException, ReflectionException, NullPointerException {
        try (JMXConnector connector = JMXConnectorFactory.connect(new JMXServiceURL(this.getJmxUrl()));){
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            Object object = connection.invoke(ObjectName.getInstance("OpenNMS:Name=Manager"), operation, new Object[0], new String[0]);
            return object;
        }
    }

    public boolean isVerbose() {
        return this.m_verbose;
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public String getJmxUrl() {
        VirtualMachine vm = null;
        StringBuffer vmNames = new StringBuffer();
        boolean first = true;
        VirtualMachineDescriptor foundVm = null;
        for (VirtualMachineDescriptor vmDescr : VirtualMachine.list()) {
            if (!first) {
                vmNames.append(", ");
            }
            vmNames.append("\"" + vmDescr.displayName() + "\"");
            first = false;
            if (!vmDescr.displayName().contains(OPENNMS_JVM_DISPLAY_NAME_SUBSTRING)) continue;
            foundVm = vmDescr;
        }
        if (foundVm == null) {
            LOG.debug("Could not find OpenNMS JVM (\"opennms_bootstrap.jar start\") among JVMs (" + vmNames + ")");
        } else {
            try {
                vm = VirtualMachine.attach(foundVm);
                LOG.debug("Attached to OpenNMS JVM: " + foundVm.id() + " (" + foundVm.displayName() + ")");
            }
            catch (AttachNotSupportedException e) {
                LOG.warn("Cannot attach to OpenNMS JVM", (Throwable)e);
            }
            catch (IOException e) {
                LOG.warn("IOException when attaching to OpenNMS JVM", (Throwable)e);
            }
        }
        if (vm == null) {
            if (this.m_pid == null) {
                LOG.debug("No PID specified for OpenNMS JVM");
            } else {
                try {
                    vm = VirtualMachine.attach(this.m_pid);
                    LOG.debug("Attached to OpenNMS JVM with PID: " + this.m_pid);
                }
                catch (AttachNotSupportedException e) {
                    LOG.warn("Cannot attach to OpenNMS JVM at PID: " + this.m_pid, (Throwable)e);
                }
                catch (IOException e) {
                    LOG.debug("IOException when attaching to OpenNMS JVM at PID: " + this.m_pid + ": " + e.getMessage());
                }
            }
        }
        if (vm == null) {
            LOG.debug("Could not attach to JVM, falling back to JMX over RMI");
            return this.m_jmxUrl;
        }
        return Controller.getJmxUriFromVirtualMachine(vm);
    }

    public void setJmxRmiUrl(String jmxUrl) {
        this.m_jmxUrl = jmxUrl;
    }

    private static String getJmxUriFromVirtualMachine(VirtualMachine vm) {
        String connectorAddress = null;
        try {
            connectorAddress = vm.getAgentProperties().getProperty(CONNECTOR_ADDRESS);
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException when fetching JMX URI from JVM with ID: " + vm.id(), e);
        }
        if (connectorAddress == null) {
            LOG.info("Starting local management agent in JVM with ID: " + vm.id());
            try {
                vm.startLocalManagementAgent();
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException when starting local JMX management agent in JVM with ID: " + vm.id(), e);
            }
            try {
                connectorAddress = vm.getAgentProperties().getProperty(CONNECTOR_ADDRESS);
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException when fetching JMX URI from JVM with ID: " + vm.id(), e);
            }
        }
        return connectorAddress;
    }

    public String getPid() {
        return this.m_pid;
    }

    public void setPid(String pid) {
        this.m_pid = pid;
    }

    public int getRmiHandshakeTimeout() {
        return Integer.valueOf(System.getProperty("sun.rmi.transport.handshakeTimeout", "60000"));
    }

    public void setRmiHandshakeTimeout(int httpRequestReadTimeout) {
        System.setProperty("sun.rmi.transport.tcp.handshakeTimeout", String.valueOf(httpRequestReadTimeout));
    }
}

