/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RrdFileConstants {
    private static final Pattern GRAPHING_ESCAPE_PATTERN = File.separatorChar == '\\' ? Pattern.compile("([\\:\\%\\\\])") : Pattern.compile("([\\:\\%])");
    public static final int MAX_RRD_FILENAME_LENGTH = 1024;

    public static final boolean isValidRRDLatencyDir(File file, final String suffix) {
        if (!file.isDirectory()) {
            return false;
        }
        FilenameFilter rrdFilenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith(suffix);
            }
        };
        File[] nodeRRDs = file.listFiles(rrdFilenameFilter);
        return nodeRRDs != null && nodeRRDs.length > 0;
    }

    public static boolean isValidRRDName(String rrd) {
        if (rrd == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int length = rrd.length();
        if (length > 1024) {
            return false;
        }
        if (rrd.indexOf("..") >= 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char c = rrd.charAt(i);
            if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '_' || c == '.' || c == '-' || c == '/') continue;
            return false;
        }
        return true;
    }

    public static String convertToValidRrdName(String rrd) {
        if (rrd == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        StringBuffer buffer = new StringBuffer(rrd);
        if (rrd.length() > 1024) {
            buffer.setLength(1023);
        }
        int length = buffer.length();
        for (int i = 0; i < length; ++i) {
            char c = buffer.charAt(i);
            if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '_' || c == '.' || c == '-' || c == '/') continue;
            buffer.setCharAt(i, '_');
        }
        return buffer.toString();
    }

    public static String escapeForGraphing(String path) {
        Matcher matcher = GRAPHING_ESCAPE_PATTERN.matcher(path);
        return matcher.replaceAll("\\\\$1");
    }
}

