/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import org.hibernate.annotations.DiscriminatorOptions;
import org.springframework.core.style.ToStringCreator;

@Entity
@Table(name="monitoringSystems")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="type", discriminatorType=DiscriminatorType.STRING)
@DiscriminatorValue(value="System")
@DiscriminatorOptions(force=true)
@XmlAccessorType(value=XmlAccessType.NONE)
public class OnmsMonitoringSystem
implements Serializable {
    private static final long serialVersionUID = -5095710111103727832L;
    public static final String TYPE_OPENNMS = "OpenNMS";
    public static final String TYPE_REMOTE_POLLER = "Remote Poller";
    public static final String TYPE_MINION = "Minion";
    @XmlID
    @XmlAttribute(name="id")
    private String m_id;
    @XmlAttribute(name="label")
    private String m_label;
    @XmlAttribute(name="location")
    private String m_location;
    @XmlAttribute(name="type")
    private String m_type;
    @XmlAttribute(name="date")
    private Date m_lastUpdated;
    @XmlElementWrapper(name="properties")
    @XmlElement(name="property")
    private Map<String, String> m_properties = new HashMap<String, String>();

    public OnmsMonitoringSystem() {
    }

    public OnmsMonitoringSystem(String id, String location) {
        this.m_id = id;
        this.m_location = location;
    }

    @Id
    @Column(name="id", nullable=false)
    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    @Column(name="label")
    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    @Column(name="location", nullable=false)
    public String getLocation() {
        return this.m_location;
    }

    public void setLocation(String location) {
        this.m_location = location;
    }

    @Column(name="type", nullable=false, insertable=false, updatable=false)
    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    @Column(name="last_updated")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getLastUpdated() {
        return this.m_lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.m_lastUpdated = lastUpdated;
    }

    @ElementCollection
    @JoinTable(name="monitoringSystemsProperties", joinColumns={@JoinColumn(name="monitoringSystemId")})
    @MapKeyColumn(name="property", nullable=false)
    @Column(name="propertyValue")
    public Map<String, String> getProperties() {
        return this.m_properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.m_properties = properties;
    }

    public void setProperty(String property, String value) {
        this.m_properties.put(property, value);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.getId()).append("label", (Object)this.getLabel()).append("location", (Object)this.getLocation()).append("type", (Object)this.getType()).toString();
    }
}

