/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jmx.impl.connection.connectors;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionException;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionWrapper;
import org.opennms.netmgt.jmx.connection.JmxServerConnector;
import org.opennms.netmgt.jmx.impl.connection.connectors.DefaultConnectionWrapper;
import org.opennms.netmgt.jmx.impl.connection.connectors.PlatformMBeanServerConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultJmxConnector
implements JmxServerConnector {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJmxConnector.class);

    DefaultJmxConnector() {
    }

    public JmxServerConnectionWrapper createConnection(InetAddress ipAddress, Map<String, String> propertiesMap) throws JmxServerConnectionException {
        try {
            String factory = ParameterMap.getKeyedString(propertiesMap, (String)"factory", (String)"STANDARD");
            String port = ParameterMap.getKeyedString(propertiesMap, (String)"port", (String)"1099");
            String protocol = ParameterMap.getKeyedString(propertiesMap, (String)"protocol", (String)"rmi");
            String urlPath = ParameterMap.getKeyedString(propertiesMap, (String)"urlPath", (String)"/jmxrmi");
            String jmxPort = System.getProperty("com.sun.management.jmxremote.port");
            if (ipAddress != null && ipAddress.isLoopbackAddress() && port != null && (port.equals(jmxPort) || jmxPort == null && "18980".equals(port))) {
                return new PlatformMBeanServerConnector().createConnection(ipAddress, propertiesMap);
            }
            JMXServiceURL url = new JMXServiceURL("service:jmx:" + protocol + ":///jndi/" + protocol + "://" + InetAddressUtils.str((InetAddress)ipAddress) + ":" + port + urlPath);
            LOG.debug("JMX: {} - {}", (Object)factory, (Object)url);
            HashMap<String, String[]> env = new HashMap<String, String[]>();
            if ("PASSWORD-CLEAR".equals(factory)) {
                String username = propertiesMap.get("username");
                String password = propertiesMap.get("password");
                String[] credentials = new String[]{username, password};
                env.put("jmx.remote.credentials", credentials);
            }
            JMXConnector connector = JMXConnectorFactory.connect(url, env);
            try {
                connector.connect(env);
            }
            catch (SecurityException x) {
                throw new JmxServerConnectionException("Security exception: bad credentials", (Exception)x);
            }
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            DefaultConnectionWrapper connectionWrapper = new DefaultConnectionWrapper(connector, connection);
            return connectionWrapper;
        }
        catch (MalformedURLException e) {
            throw new JmxServerConnectionException((IOException)e);
        }
        catch (IOException e) {
            throw new JmxServerConnectionException(e);
        }
    }
}

