/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jicmp.jna;

import com.sun.jna.Structure;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.opennms.jicmp.jna.NativeDatagramSocket;

public class sun_sockaddr_in6
extends Structure {
    public short sin6_family;
    public byte[] sin6_port = new byte[2];
    public byte[] sin6_flowinfo = new byte[4];
    public byte[] sin6_addr = new byte[16];
    public byte[] sin6_scope_id = new byte[4];
    public byte[] __sin6_src_id = new byte[4];

    public sun_sockaddr_in6(int family, byte[] addr, byte[] port) {
        this.sin6_family = (short)(0xFFFF & family);
        this.assertLen("port", port, 2);
        this.sin6_port = port;
        this.sin6_flowinfo = new byte[4];
        this.assertLen("address", addr, 16);
        this.sin6_addr = addr;
        this.sin6_scope_id = new byte[4];
    }

    public sun_sockaddr_in6() {
        this(0, new byte[16], new byte[2]);
    }

    public sun_sockaddr_in6(InetAddress address, int port) {
        this(NativeDatagramSocket.AF_INET6, address.getAddress(), new byte[]{(byte)(0xFF & port >> 8), (byte)(0xFF & port)});
    }

    @Override
    protected List<String> getFieldOrder() {
        return Arrays.asList("sin6_family", "sin6_port", "sin6_flowinfo", "sin6_addr", "sin6_scope_id", "__sin6_src_id");
    }

    private void assertLen(String field, byte[] addr, int len) {
        if (addr.length != len) {
            throw new IllegalArgumentException(field + " length must be " + len + " bytes but was " + addr.length + " bytes.");
        }
    }

    public InetAddress getAddress() {
        try {
            return InetAddress.getByAddress(this.sin6_addr);
        }
        catch (UnknownHostException ex) {
            return null;
        }
    }

    public void setAddress(InetAddress address) {
        byte[] addr = address.getAddress();
        this.assertLen("address", addr, 16);
        this.sin6_addr = addr;
    }

    public int getPort() {
        int port = 0;
        for (int i = 0; i < 2; ++i) {
            port = port << 8 | this.sin6_port[i] & 0xFF;
        }
        return port;
    }

    public void setPort(int port) {
        byte[] p = new byte[]{(byte)(0xFF & port >> 8), (byte)(0xFF & port)};
        this.assertLen("port", p, 2);
        this.sin6_port = p;
    }
}

