/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opennms.core.utils.LazyList;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.support.AbstractTopLevelResourceType;
import org.opennms.netmgt.dao.support.LazyChildResourceLoader;
import org.opennms.netmgt.dao.support.NodeResourceType;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.springframework.orm.ObjectRetrievalFailureException;

public final class NodeSourceResourceType
extends AbstractTopLevelResourceType {
    private static final Set<OnmsAttribute> s_emptyAttributeSet = Collections.unmodifiableSet(new HashSet());
    private final ResourceDao m_resourceDao;
    private final NodeDao m_nodeDao;

    public NodeSourceResourceType(ResourceDao resourceDao, NodeDao nodeDao) {
        this.m_resourceDao = resourceDao;
        this.m_nodeDao = nodeDao;
    }

    public String getLabel() {
        return "Foreign Source";
    }

    public String getName() {
        return "nodeSource";
    }

    public String getLinkForResource(OnmsResource resource) {
        return "element/node.jsp?node=" + resource.getName();
    }

    @Override
    public List<OnmsResource> getTopLevelResources() {
        return Collections.emptyList();
    }

    @Override
    public OnmsResource getResourceByName(String nodeSource) {
        String[] ident = ResourceTypeUtils.getFsAndFidFromNodeSource((String)nodeSource);
        OnmsNode node = this.m_nodeDao.findByForeignId(ident[0], ident[1]);
        if (node == null) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)nodeSource, "Top-level resource of resource type node could not be found: " + nodeSource, null);
        }
        return this.createResourceForNode(node);
    }

    protected static ResourcePath getResourcePathForNode(OnmsNode node) {
        if (!ResourceTypeUtils.isStoreByForeignSource()) {
            return NodeResourceType.getResourcePathForNode(node);
        }
        return ResourcePath.get((String[])new String[]{"snmp", "fs", node.getForeignSource(), node.getForeignId()});
    }

    public OnmsResource createResourceForNode(OnmsNode node) {
        String label = String.format("%s:%s", node.getForeignSource(), node.getForeignId());
        ResourcePath path = NodeSourceResourceType.getResourcePathForNode(node);
        LazyChildResourceLoader loader = new LazyChildResourceLoader(this.m_resourceDao);
        OnmsResource resource = new OnmsResource(label, label, (OnmsResourceType)this, s_emptyAttributeSet, (List)new LazyList((LazyList.Loader)loader), path);
        resource.setEntity((OnmsEntity)node);
        loader.setParent(resource);
        return resource;
    }
}

