/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.snmp4j;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opennms.netmgt.snmp.AbstractSnmpValue;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Opaque;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;

class Snmp4JValue
extends AbstractSnmpValue {
    Variable m_value;

    Snmp4JValue(Variable value) {
        if (value == null) {
            throw new NullPointerException("value attribute cannot be null");
        }
        this.m_value = value;
    }

    Snmp4JValue(int syntax, byte[] initialBytes) {
        byte[] bytes = initialBytes == null ? null : (byte[])initialBytes.clone();
        switch (syntax) {
            case 2: {
                this.m_value = new Integer32(new BigInteger(bytes).intValue());
                break;
            }
            case 65: {
                this.m_value = new Counter32(new BigInteger(bytes).longValue());
                break;
            }
            case 70: {
                this.m_value = new Counter64(new BigInteger(bytes).longValue());
                break;
            }
            case 67: {
                this.m_value = new TimeTicks(new BigInteger(bytes).longValue());
                break;
            }
            case 66: {
                this.m_value = new UnsignedInteger32(new BigInteger(bytes).longValue());
                break;
            }
            case 64: {
                try {
                    this.m_value = new IpAddress(InetAddress.getByAddress(bytes));
                    break;
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException("unable to create InetAddress from bytes: " + e.getMessage());
                }
            }
            case 6: {
                this.m_value = new OID(new String(bytes));
                break;
            }
            case 4: {
                this.m_value = new OctetString(bytes);
                break;
            }
            case 68: {
                this.m_value = new Opaque(bytes);
                break;
            }
            case 130: {
                this.m_value = Null.endOfMibView;
                break;
            }
            case 129: {
                this.m_value = Null.noSuchInstance;
                break;
            }
            case 128: {
                this.m_value = Null.noSuchObject;
                break;
            }
            case 5: {
                this.m_value = new Null();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid syntax " + syntax);
            }
        }
        if (this.m_value == null) {
            throw new IllegalArgumentException("value object created from syntax " + syntax + " is null");
        }
    }

    public byte[] getBytes() {
        switch (this.m_value.getSyntax()) {
            case 2: 
            case 65: 
            case 66: 
            case 67: 
            case 70: {
                return this.toBigInteger().toByteArray();
            }
            case 64: {
                return this.toInetAddress().getAddress();
            }
            case 6: {
                return this.toSnmpObjId().toString().getBytes();
            }
            case 4: {
                return ((OctetString)this.m_value).getValue();
            }
            case 68: {
                return ((Opaque)this.m_value).getValue();
            }
            case 5: 
            case 128: 
            case 129: 
            case 130: {
                return new byte[0];
            }
        }
        throw new IllegalArgumentException("cannot convert " + this.m_value + " to a byte array");
    }

    public int getType() {
        return this.m_value.getSyntax();
    }

    public boolean isEndOfMib() {
        return this.m_value.getSyntax() == 130;
    }

    public boolean isNumeric() {
        switch (this.m_value.getSyntax()) {
            case 2: 
            case 65: 
            case 66: 
            case 67: 
            case 70: {
                return true;
            }
        }
        return false;
    }

    public int toInt() {
        switch (this.m_value.getSyntax()) {
            case 70: {
                return (int)((Counter64)this.m_value).getValue();
            }
            case 2: {
                return ((Integer32)this.m_value).getValue();
            }
            case 65: 
            case 66: 
            case 67: {
                return (int)((UnsignedInteger32)this.m_value).getValue();
            }
        }
        return Integer.parseInt(this.m_value.toString());
    }

    public long toLong() {
        switch (this.m_value.getSyntax()) {
            case 70: {
                return ((Counter64)this.m_value).getValue();
            }
            case 2: {
                return ((Integer32)this.m_value).getValue();
            }
            case 65: 
            case 66: 
            case 67: {
                return ((UnsignedInteger32)this.m_value).getValue();
            }
            case 4: {
                return this.convertStringToLong();
            }
        }
        return Long.parseLong(this.m_value.toString());
    }

    private long convertStringToLong() {
        return Double.valueOf(this.m_value.toString()).longValue();
    }

    public String toDisplayString() {
        switch (this.m_value.getSyntax()) {
            case 6: {
                return SnmpObjId.get((int[])((OID)this.m_value).getValue()).toString();
            }
            case 67: {
                return Long.toString(this.toLong());
            }
            case 4: {
                return this.toStringDottingCntrlChars(((OctetString)this.m_value).getValue());
            }
            case 5: {
                return "";
            }
        }
        return this.m_value.toString();
    }

    private String toStringDottingCntrlChars(byte[] value) {
        byte[] results = new byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            results[i] = Character.isISOControl((char)value[i]) ? 46 : value[i];
        }
        return new String(results);
    }

    public InetAddress toInetAddress() {
        switch (this.m_value.getSyntax()) {
            case 64: {
                return ((IpAddress)this.m_value).getInetAddress();
            }
        }
        throw new IllegalArgumentException("cannot convert " + this.m_value + " to an InetAddress");
    }

    public String toHexString() {
        switch (this.m_value.getSyntax()) {
            case 4: {
                return ((OctetString)this.m_value).toHexString().replaceAll(":", "");
            }
        }
        throw new IllegalArgumentException("cannot convert " + this.m_value + " to a HexString");
    }

    public String toString() {
        return this.toDisplayString();
    }

    public BigInteger toBigInteger() {
        switch (this.m_value.getSyntax()) {
            case 70: {
                Counter64 cnt = (Counter64)this.m_value;
                if (cnt.getValue() > 0L) {
                    return BigInteger.valueOf(cnt.getValue());
                }
                return new BigInteger(cnt.toString());
            }
            case 2: {
                return BigInteger.valueOf(((Integer32)this.m_value).getValue());
            }
            case 65: 
            case 66: 
            case 67: {
                return BigInteger.valueOf(((UnsignedInteger32)this.m_value).getValue());
            }
        }
        return new BigInteger(this.m_value.toString());
    }

    public SnmpObjId toSnmpObjId() {
        switch (this.m_value.getSyntax()) {
            case 6: {
                return SnmpObjId.get((int[])((OID)this.m_value).getValue());
            }
        }
        throw new IllegalArgumentException("cannot convert " + this.m_value + " to an SnmpObjId");
    }

    public boolean isDisplayable() {
        if (this.isNumeric()) {
            return true;
        }
        if (this.getType() == 6 || this.getType() == 64) {
            return true;
        }
        if (this.getType() == 4) {
            return Snmp4JValue.allBytesDisplayable((byte[])this.getBytes());
        }
        return false;
    }

    public boolean isNull() {
        return this.getType() == 5;
    }

    public Variable getVariable() {
        return this.m_value;
    }

    public boolean isError() {
        switch (this.getType()) {
            case 128: 
            case 129: {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.m_value == null) {
            return 5231;
        }
        return this.m_value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        Snmp4JValue that = (Snmp4JValue)((Object)obj);
        return this.m_value == null ? that.m_value == null : this.m_value.equals(that.m_value);
    }
}

