/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Bind;
import org.jivesoftware.smack.packet.DefaultPacketExtension;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class PacketParserUtils {
    private static final Logger LOGGER = Logger.getLogger(PacketParserUtils.class.getName());

    public static XmlPullParser newXmppParser() throws XmlPullParserException {
        XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        return parser;
    }

    public static Message parseMessage(XmlPullParser parser) throws Exception {
        Message message = new Message();
        String id = parser.getAttributeValue("", "id");
        message.setPacketID(id == null ? "ID_NOT_AVAILABLE" : id);
        message.setTo(parser.getAttributeValue("", "to"));
        message.setFrom(parser.getAttributeValue("", "from"));
        message.setType(Message.Type.fromString(parser.getAttributeValue("", "type")));
        String language = PacketParserUtils.getLanguageAttribute(parser);
        String defaultLanguage = null;
        if (language != null && !"".equals(language.trim())) {
            message.setLanguage(language);
            defaultLanguage = language;
        } else {
            defaultLanguage = Packet.getDefaultLanguage();
        }
        boolean done = false;
        String thread = null;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String xmlLang;
                String elementName = parser.getName();
                String namespace = parser.getNamespace();
                if (elementName.equals("subject")) {
                    xmlLang = PacketParserUtils.getLanguageAttribute(parser);
                    if (xmlLang == null) {
                        xmlLang = defaultLanguage;
                    }
                    String subject = PacketParserUtils.parseElementText(parser);
                    if (message.getSubject(xmlLang) != null) continue;
                    message.addSubject(xmlLang, subject);
                    continue;
                }
                if (elementName.equals("body")) {
                    xmlLang = PacketParserUtils.getLanguageAttribute(parser);
                    if (xmlLang == null) {
                        xmlLang = defaultLanguage;
                    }
                    String body = PacketParserUtils.parseElementText(parser);
                    if (message.getBody(xmlLang) != null) continue;
                    message.addBody(xmlLang, body);
                    continue;
                }
                if (elementName.equals("thread")) {
                    if (thread != null) continue;
                    thread = parser.nextText();
                    continue;
                }
                if (elementName.equals("error")) {
                    message.setError(PacketParserUtils.parseError(parser));
                    continue;
                }
                message.addExtension(PacketParserUtils.parsePacketExtension(elementName, namespace, parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("message")) continue;
            done = true;
        }
        message.setThread(thread);
        return message;
    }

    public static String parseElementText(XmlPullParser parser) throws XmlPullParserException, IOException {
        String res;
        assert (parser.getEventType() == 2);
        if (parser.isEmptyElementTag()) {
            res = "";
        } else {
            int event = parser.next();
            if (event != 4) {
                if (event == 3) {
                    return "";
                }
                throw new XmlPullParserException("Non-empty element tag not followed by text, while Mixed Content (XML 3.2.2) is disallowed");
            }
            res = parser.getText();
            event = parser.next();
            if (event != 3) {
                throw new XmlPullParserException("Non-empty element tag contains child-elements, while Mixed Content (XML 3.2.2) is disallowed");
            }
        }
        return res;
    }

    public static String parseElement(XmlPullParser parser) throws XmlPullParserException, IOException {
        return PacketParserUtils.parseElement(parser, false);
    }

    public static String parseElement(XmlPullParser parser, boolean fullNamespaces) throws XmlPullParserException, IOException {
        assert (parser.getEventType() == 2);
        return PacketParserUtils.parseContentDepth(parser, parser.getDepth(), fullNamespaces);
    }

    public static String parseContent(XmlPullParser parser) throws XmlPullParserException, IOException {
        assert (parser.getEventType() == 2);
        if (parser.isEmptyElementTag()) {
            return "";
        }
        parser.next();
        return PacketParserUtils.parseContentDepth(parser, parser.getDepth(), false);
    }

    public static String parseContentDepth(XmlPullParser parser, int depth) throws XmlPullParserException, IOException {
        return PacketParserUtils.parseContentDepth(parser, depth, false);
    }

    public static String parseContentDepth(XmlPullParser parser, int depth, boolean fullNamespaces) throws XmlPullParserException, IOException {
        XmlStringBuilder xml = new XmlStringBuilder();
        int event = parser.getEventType();
        boolean isEmptyElement = false;
        String namespaceElement = null;
        while (true) {
            if (event == 2) {
                String namespace;
                xml.halfOpenElement(parser.getName());
                if ((namespaceElement == null || fullNamespaces) && StringUtils.isNotEmpty(namespace = parser.getNamespace())) {
                    xml.attribute("xmlns", namespace);
                    namespaceElement = parser.getName();
                }
                for (int i = 0; i < parser.getAttributeCount(); ++i) {
                    xml.attribute(parser.getAttributeName(i), parser.getAttributeValue(i));
                }
                if (parser.isEmptyElementTag()) {
                    xml.closeEmptyElement();
                    isEmptyElement = true;
                } else {
                    xml.rightAngelBracket();
                }
            } else if (event == 3) {
                if (isEmptyElement) {
                    isEmptyElement = false;
                } else {
                    xml.closeElement(parser.getName());
                }
                if (namespaceElement != null && namespaceElement.equals(parser.getName())) {
                    namespaceElement = null;
                }
                if (parser.getDepth() <= depth) {
                    break;
                }
            } else if (event == 4) {
                xml.append(parser.getText());
            }
            event = parser.next();
        }
        return xml.toString();
    }

    public static Presence parsePresence(XmlPullParser parser) throws Exception {
        Presence.Type type = Presence.Type.available;
        String typeString = parser.getAttributeValue("", "type");
        if (typeString != null && !typeString.equals("")) {
            try {
                type = Presence.Type.valueOf(typeString);
            }
            catch (IllegalArgumentException iae) {
                LOGGER.warning("Found invalid presence type " + typeString);
            }
        }
        Presence presence = new Presence(type);
        presence.setTo(parser.getAttributeValue("", "to"));
        presence.setFrom(parser.getAttributeValue("", "from"));
        String id = parser.getAttributeValue("", "id");
        presence.setPacketID(id == null ? "ID_NOT_AVAILABLE" : id);
        String language = PacketParserUtils.getLanguageAttribute(parser);
        if (language != null && !"".equals(language.trim())) {
            presence.setLanguage(language);
        }
        presence.setPacketID(id == null ? "ID_NOT_AVAILABLE" : id);
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String elementName = parser.getName();
                String namespace = parser.getNamespace();
                if (elementName.equals("status")) {
                    presence.setStatus(parser.nextText());
                    continue;
                }
                if (elementName.equals("priority")) {
                    try {
                        int priority = Integer.parseInt(parser.nextText());
                        presence.setPriority(priority);
                    }
                    catch (NumberFormatException nfe) {
                    }
                    catch (IllegalArgumentException iae) {
                        presence.setPriority(0);
                    }
                    continue;
                }
                if (elementName.equals("show")) {
                    String modeText = parser.nextText();
                    try {
                        presence.setMode(Presence.Mode.valueOf(modeText));
                    }
                    catch (IllegalArgumentException iae) {
                        LOGGER.warning("Found invalid presence mode " + modeText);
                    }
                    continue;
                }
                if (elementName.equals("error")) {
                    presence.setError(PacketParserUtils.parseError(parser));
                    continue;
                }
                try {
                    presence.addExtension(PacketParserUtils.parsePacketExtension(elementName, namespace, parser));
                }
                catch (Exception e) {
                    LOGGER.warning("Failed to parse extension packet in Presence packet.");
                }
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("presence")) continue;
            done = true;
        }
        return presence;
    }

    public static IQ parseIQ(XmlPullParser parser, XMPPConnection connection) throws Exception {
        Packet iqPacket = null;
        XMPPError error = null;
        String id = parser.getAttributeValue("", "id");
        String to = parser.getAttributeValue("", "to");
        String from = parser.getAttributeValue("", "from");
        IQ.Type type = IQ.Type.fromString(parser.getAttributeValue("", "type"));
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String elementName = parser.getName();
                String namespace = parser.getNamespace();
                if (elementName.equals("error")) {
                    error = PacketParserUtils.parseError(parser);
                    continue;
                }
                if (elementName.equals("query") && namespace.equals("jabber:iq:roster")) {
                    iqPacket = PacketParserUtils.parseRoster(parser);
                    continue;
                }
                if (elementName.equals("query") && namespace.equals("jabber:iq:register")) {
                    iqPacket = PacketParserUtils.parseRegistration(parser);
                    continue;
                }
                if (elementName.equals("bind") && namespace.equals("urn:ietf:params:xml:ns:xmpp-bind")) {
                    iqPacket = PacketParserUtils.parseResourceBinding(parser);
                    continue;
                }
                Object provider = ProviderManager.getIQProvider(elementName, namespace);
                if (provider != null) {
                    if (provider instanceof IQProvider) {
                        iqPacket = ((IQProvider)provider).parseIQ(parser);
                        continue;
                    }
                    if (!(provider instanceof Class)) continue;
                    iqPacket = (IQ)PacketParserUtils.parseWithIntrospection(elementName, (Class)provider, parser);
                    continue;
                }
                if (IQ.Type.RESULT != type) continue;
                iqPacket = new UnparsedResultIQ(PacketParserUtils.parseContent(parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("iq")) continue;
            done = true;
        }
        if (iqPacket == null) {
            if (IQ.Type.GET == type || IQ.Type.SET == type) {
                iqPacket = new IQ(){

                    @Override
                    public String getChildElementXML() {
                        return null;
                    }
                };
                iqPacket.setPacketID(id);
                iqPacket.setTo(from);
                iqPacket.setFrom(to);
                ((IQ)iqPacket).setType(IQ.Type.ERROR);
                iqPacket.setError(new XMPPError(XMPPError.Condition.feature_not_implemented));
                connection.sendPacket(iqPacket);
                return null;
            }
            iqPacket = new IQ(){

                @Override
                public String getChildElementXML() {
                    return null;
                }
            };
        }
        iqPacket.setPacketID(id);
        iqPacket.setTo(to);
        iqPacket.setFrom(from);
        ((IQ)iqPacket).setType(type);
        iqPacket.setError(error);
        return iqPacket;
    }

    private static RosterPacket parseRoster(XmlPullParser parser) throws Exception {
        RosterPacket roster = new RosterPacket();
        boolean done = false;
        RosterPacket.Item item = null;
        String version = parser.getAttributeValue("", "ver");
        roster.setVersion(version);
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String groupName;
                if (parser.getName().equals("item")) {
                    String jid = parser.getAttributeValue("", "jid");
                    String name = parser.getAttributeValue("", "name");
                    item = new RosterPacket.Item(jid, name);
                    String ask = parser.getAttributeValue("", "ask");
                    RosterPacket.ItemStatus status = RosterPacket.ItemStatus.fromString(ask);
                    item.setItemStatus(status);
                    String subscription = parser.getAttributeValue("", "subscription");
                    RosterPacket.ItemType type = RosterPacket.ItemType.valueOf(subscription != null ? subscription : "none");
                    item.setItemType(type);
                    continue;
                }
                if (!parser.getName().equals("group") || item == null || (groupName = parser.nextText()) == null || groupName.trim().length() <= 0) continue;
                item.addGroupName(groupName);
                continue;
            }
            if (eventType != 3) continue;
            if (parser.getName().equals("item")) {
                roster.addRosterItem(item);
            }
            if (!parser.getName().equals("query")) continue;
            done = true;
        }
        return roster;
    }

    private static Registration parseRegistration(XmlPullParser parser) throws Exception {
        Registration registration = new Registration();
        HashMap<String, String> fields = null;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getNamespace().equals("jabber:iq:register")) {
                    String name = parser.getName();
                    String value = "";
                    if (fields == null) {
                        fields = new HashMap<String, String>();
                    }
                    if (parser.next() == 4) {
                        value = parser.getText();
                    }
                    if (!name.equals("instructions")) {
                        fields.put(name, value);
                        continue;
                    }
                    registration.setInstructions(value);
                    continue;
                }
                registration.addExtension(PacketParserUtils.parsePacketExtension(parser.getName(), parser.getNamespace(), parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("query")) continue;
            done = true;
        }
        registration.setAttributes(fields);
        return registration;
    }

    private static Bind parseResourceBinding(XmlPullParser parser) throws IOException, XmlPullParserException {
        Bind bind = new Bind();
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("resource")) {
                    bind.setResource(parser.nextText());
                    continue;
                }
                if (!parser.getName().equals("jid")) continue;
                bind.setJid(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("bind")) continue;
            done = true;
        }
        return bind;
    }

    public static Collection<String> parseMechanisms(XmlPullParser parser) throws Exception {
        ArrayList<String> mechanisms = new ArrayList<String>();
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String elementName = parser.getName();
                if (!elementName.equals("mechanism")) continue;
                mechanisms.add(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("mechanisms")) continue;
            done = true;
        }
        return mechanisms;
    }

    public static Collection<String> parseCompressionMethods(XmlPullParser parser) throws IOException, XmlPullParserException {
        ArrayList<String> methods = new ArrayList<String>();
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String elementName = parser.getName();
                if (!elementName.equals("method")) continue;
                methods.add(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("compression")) continue;
            done = true;
        }
        return methods;
    }

    public static SASLMechanism.SASLFailure parseSASLFailure(XmlPullParser parser) throws Exception {
        String condition = null;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("failure")) continue;
                condition = parser.getName();
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("failure")) continue;
            done = true;
        }
        return new SASLMechanism.SASLFailure(condition);
    }

    public static StreamError parseStreamError(XmlPullParser parser) throws IOException, XmlPullParserException {
        int depth = parser.getDepth();
        boolean done = false;
        String code = null;
        String text = null;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String namespace = parser.getNamespace();
                if (!"urn:ietf:params:xml:ns:xmpp-streams".equals(namespace)) continue;
                String name = parser.getName();
                if (name.equals("text") && !parser.isEmptyElementTag()) {
                    parser.next();
                    text = parser.getText();
                    continue;
                }
                code = name;
                continue;
            }
            if (eventType != 3 || depth != parser.getDepth()) continue;
            done = true;
        }
        return new StreamError(code, text);
    }

    public static XMPPError parseError(XmlPullParser parser) throws Exception {
        String errorNamespace = "urn:ietf:params:xml:ns:xmpp-stanzas";
        String type = null;
        String message = null;
        String condition = null;
        ArrayList<PacketExtension> extensions = new ArrayList<PacketExtension>();
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if (!parser.getAttributeName(i).equals("type")) continue;
            type = parser.getAttributeValue("", "type");
        }
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("text")) {
                    message = parser.nextText();
                    continue;
                }
                String elementName = parser.getName();
                String namespace = parser.getNamespace();
                if ("urn:ietf:params:xml:ns:xmpp-stanzas".equals(namespace)) {
                    condition = elementName;
                    continue;
                }
                extensions.add(PacketParserUtils.parsePacketExtension(elementName, namespace, parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("error")) continue;
            done = true;
        }
        XMPPError.Type errorType = XMPPError.Type.CANCEL;
        try {
            if (type != null) {
                errorType = XMPPError.Type.valueOf(type.toUpperCase(Locale.US));
            }
        }
        catch (IllegalArgumentException iae) {
            LOGGER.log(Level.SEVERE, "Could not find error type for " + type.toUpperCase(Locale.US), iae);
        }
        return new XMPPError(errorType, condition, message, extensions);
    }

    public static PacketExtension parsePacketExtension(String elementName, String namespace, XmlPullParser parser) throws Exception {
        Object provider = ProviderManager.getExtensionProvider(elementName, namespace);
        if (provider != null) {
            if (provider instanceof PacketExtensionProvider) {
                return ((PacketExtensionProvider)provider).parseExtension(parser);
            }
            if (provider instanceof Class) {
                return (PacketExtension)PacketParserUtils.parseWithIntrospection(elementName, (Class)provider, parser);
            }
        }
        DefaultPacketExtension extension = new DefaultPacketExtension(elementName, namespace);
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String name = parser.getName();
                if (parser.isEmptyElementTag()) {
                    extension.setValue(name, "");
                    continue;
                }
                eventType = parser.next();
                if (eventType != 4) continue;
                String value = parser.getText();
                extension.setValue(name, value);
                continue;
            }
            if (eventType != 3 || !parser.getName().equals(elementName)) continue;
            done = true;
        }
        return extension;
    }

    private static String getLanguageAttribute(XmlPullParser parser) {
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String attributeName = parser.getAttributeName(i);
            if (!"xml:lang".equals(attributeName) && (!"lang".equals(attributeName) || !"xml".equals(parser.getAttributePrefix(i)))) continue;
            return parser.getAttributeValue(i);
        }
        return null;
    }

    public static Object parseWithIntrospection(String elementName, Class<?> objectClass, XmlPullParser parser) throws Exception {
        boolean done = false;
        Object object = objectClass.newInstance();
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String name = parser.getName();
                String stringValue = parser.nextText();
                Class<?> propertyType = object.getClass().getMethod("get" + Character.toUpperCase(name.charAt(0)) + name.substring(1), new Class[0]).getReturnType();
                Object value = PacketParserUtils.decode(propertyType, stringValue);
                object.getClass().getMethod("set" + Character.toUpperCase(name.charAt(0)) + name.substring(1), propertyType).invoke(object, value);
                continue;
            }
            if (eventType != 3 || !parser.getName().equals(elementName)) continue;
            done = true;
        }
        return object;
    }

    private static Object decode(Class<?> type, String value) throws Exception {
        if (type.getName().equals("java.lang.String")) {
            return value;
        }
        if (type.getName().equals("boolean")) {
            return Boolean.valueOf(value);
        }
        if (type.getName().equals("int")) {
            return Integer.valueOf(value);
        }
        if (type.getName().equals("long")) {
            return Long.valueOf(value);
        }
        if (type.getName().equals("float")) {
            return Float.valueOf(value);
        }
        if (type.getName().equals("double")) {
            return Double.valueOf(value);
        }
        if (type.getName().equals("java.lang.Class")) {
            return Class.forName(value);
        }
        return null;
    }

    public static class UnparsedResultIQ
    extends IQ {
        private final String str;

        public UnparsedResultIQ(String content) {
            this.str = content;
        }

        @Override
        public String getChildElementXML() {
            return this.str;
        }
    }
}

