/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.RrdResourceAttributeUtils;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.rrd.RrdMetaDataUtils;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class FilesystemResourceStorageDao
implements ResourceStorageDao,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(FilesystemResourceStorageDao.class);
    @Autowired
    private RrdStrategy<?, ?> m_rrdStrategy;
    private static String RRD_EXTENSION = null;
    private File m_rrdDirectory;
    private static Predicate<Path> isRrdFile = new Predicate<Path>(){

        @Override
        public boolean test(Path path) {
            File file = path.toFile();
            return file.isFile() && file.getName().endsWith(RRD_EXTENSION);
        }
    };

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
        this.setRrdExtension(this.m_rrdStrategy.getDefaultFileExtension());
    }

    public boolean exists(ResourcePath path, int depth) {
        Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0, (Object)"depth must be non-negative");
        return this.exists(this.toFile(path).toPath(), depth);
    }

    public boolean existsWithin(ResourcePath path, int depth) {
        Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0, (Object)"depth must be non-negative");
        return this.existsWithin(this.toFile(path).toPath(), depth);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<ResourcePath> children(ResourcePath path, int depth) {
        Preconditions.checkArgument((depth > 0 ? 1 : 0) != 0, (Object)"depth must be positive");
        File root = this.toFile(path);
        if (!root.isDirectory()) {
            return Collections.emptySet();
        }
        try (Stream<Path> stream = Files.list(root.toPath());){
            Set<ResourcePath> set = stream.filter(p -> p.toFile().isDirectory()).filter(p -> this.exists((Path)p, depth - 1)).map(p -> ResourcePath.get((ResourcePath)path, (String[])new String[]{p.toFile().getName()})).collect(Collectors.toSet());
            return set;
        }
        catch (IOException e) {
            LOG.error("Failed to list {}. Returning empty set of children.", (Object)path, (Object)e);
            return Collections.emptySet();
        }
    }

    public Set<OnmsAttribute> getAttributes(ResourcePath path) {
        return RrdResourceAttributeUtils.getAttributesAtRelativePath(this.m_rrdDirectory, this.toRelativePath(path), RRD_EXTENSION);
    }

    public void setStringAttribute(ResourcePath path, String key, String value) {
        try {
            RrdResourceAttributeUtils.updateStringProperty(this.toFile(path), value, key);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String getStringAttribute(ResourcePath path, String key) {
        return RrdResourceAttributeUtils.getStringProperty(this.toFile(path), key);
    }

    public Map<String, String> getStringAttributes(ResourcePath path) {
        Properties props = RrdResourceAttributeUtils.getStringProperties(this.m_rrdDirectory, this.toRelativePath(path));
        return Maps.fromProperties((Properties)props);
    }

    public void updateMetricToResourceMappings(ResourcePath path, Map<String, String> metricsNameToResourceNames) {
        RrdResourceAttributeUtils.updateDsProperties(this.toFile(path), metricsNameToResourceNames);
    }

    public Map<String, String> getMetaData(ResourcePath path) {
        return RrdMetaDataUtils.readMetaDataFile((File)this.getRrdDirectory(), (String)this.toRelativePath(path));
    }

    public boolean delete(ResourcePath path) {
        return FileUtils.deleteQuietly((File)this.toFile(path));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean exists(Path root, int depth) {
        if (!root.toFile().isDirectory()) {
            return false;
        }
        try (Stream<Path> stream = Files.list(root);){
            if (depth == 0) {
                boolean bl2 = stream.anyMatch(isRrdFile);
                return bl2;
            }
            boolean bl = stream.anyMatch(p -> this.exists((Path)p, depth - 1));
            return bl;
        }
        catch (IOException e) {
            LOG.error("Failed to list {}. Marking path as non-existent.", (Object)root, (Object)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean existsWithin(Path root, int depth) {
        if (depth < 0) return false;
        if (!root.toFile().isDirectory()) {
            return false;
        }
        try (Stream<Path> stream = Files.list(root);){
            boolean bl = stream.anyMatch(p -> isRrdFile.test((Path)p) || this.existsWithin((Path)p, depth - 1));
            return bl;
        }
        catch (IOException e) {
            LOG.error("Failed to list {}. Marking path as non-existent.", (Object)root, (Object)e);
            return false;
        }
    }

    private File toFile(ResourcePath path) {
        return Paths.get(this.m_rrdDirectory.getAbsolutePath(), path.elements()).toFile();
    }

    private String toRelativePath(ResourcePath path) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String el : path) {
            if (!first) {
                sb.append(File.separator);
            } else {
                first = false;
            }
            sb.append(el);
        }
        return sb.toString();
    }

    public void setRrdDirectory(File rrdDirectory) {
        this.m_rrdDirectory = rrdDirectory;
    }

    public File getRrdDirectory() {
        return this.m_rrdDirectory;
    }

    public void setRrdStrategy(RrdStrategy<?, ?> rrdStrategy) {
        this.m_rrdStrategy = rrdStrategy;
        this.setRrdExtension(this.m_rrdStrategy.getDefaultFileExtension());
    }

    public void setRrdExtension(String rrdExtension) {
        RRD_EXTENSION = rrdExtension;
    }
}

