/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.rancid;

import java.util.HashMap;
import org.opennms.rancid.InventoryNode;
import org.opennms.rancid.RancidNodeAuthentication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RancidNode {
    public static String DEVICE_TYPE_ALTEON = "alteon";
    public static String DEVICE_TYPE_BAYNET = "baynet";
    public static String DEVICE_TYPE_CISCO_CATOS = "cat5";
    public static String DEVICE_TYPE_CISCO_IOS = "cisco";
    public static String DEVICE_TYPE_CISCO_CSS = "css";
    public static String DEVICE_TYPE_ENTERASYS = "enterasys";
    public static String DEVICE_TYPE_JUNOS = "erx";
    public static String DEVICE_TYPE_EXTREME = "extreme";
    public static String DEVICE_TYPE_EZT3 = "ezt3";
    public static String DEVICE_TYPE_FORCE10 = "force10";
    public static String DEVICE_TYPE_FOUNDRY = "foundry";
    public static String DEVICE_TYPE_HITACHI = "hitachi";
    public static String DEVICE_TYPE_HPPROCURVE = "hp";
    public static String DEVICE_TYPE_JUNIPER = "juniper";
    public static String DEVICE_TYPE_MRTD = "mrtd";
    public static String DEVICE_TYPE_NETSCALAR = "netscalar";
    public static String DEVICE_TYPE_NETSCREEN = "netscreen";
    public static String DEVICE_TYPE_REDBACK = "redback";
    public static String DEVICE_TYPE_RIVERSTONE = "riverstone";
    public static String DEVICE_TYPE_TNT = "tnt";
    public static String DEVICE_TYPE_ZEBRA = "zebra";
    private String deviceName;
    private String deviceType;
    private boolean stateUp = true;
    private String comment;
    private int TotalRevisions;
    private String HeadRevision;
    private String rootConfigurationUrl;
    private String group;
    private RancidNodeAuthentication m_auth;
    private HashMap<String, InventoryNode> nodeVersions;

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (null == this.deviceName ? 0 : this.deviceName.hashCode());
        hash = 31 * hash + (null == this.group ? 0 : this.group.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            throw new IllegalArgumentException("The comparison object is either null or of the wrong class");
        }
        RancidNode that = (RancidNode)obj;
        if (this.deviceName.equalsIgnoreCase(that.deviceName) && this.group.equalsIgnoreCase(that.group)) {
            equal = true;
        }
        return equal;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("RANCID Node: ");
        bldr.append(this.deviceName);
        bldr.append(" of Group: ");
        bldr.append(this.group);
        return bldr.toString();
    }

    public RancidNode() {
        this(null, null);
    }

    public RancidNode(String group, String deviceName) {
        this.group = group;
        if (deviceName != null) {
            this.deviceName = deviceName.toLowerCase();
        }
        this.nodeVersions = new HashMap();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        if (deviceName != null) {
            this.deviceName = deviceName.toLowerCase();
        }
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public boolean isStateUp() {
        return this.stateUp;
    }

    public void setStateUp(boolean stateUp) {
        this.stateUp = stateUp;
    }

    public String getState() {
        if (this.isStateUp()) {
            return "up";
        }
        return "down";
    }

    public HashMap<String, InventoryNode> getNodeVersions() {
        return this.nodeVersions;
    }

    public void setNodeVersions(HashMap<String, InventoryNode> nodeVersions) {
        this.nodeVersions = nodeVersions;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setRootConfigurationUrl(String rootConfigurationUrl) {
        this.rootConfigurationUrl = rootConfigurationUrl;
    }

    public String getRootConfigurationUrl() {
        return this.rootConfigurationUrl;
    }

    public int getTotalRevisions() {
        return this.TotalRevisions;
    }

    public void setTotalRevisions(String TotalRevisions) {
        this.TotalRevisions = Integer.parseInt(TotalRevisions);
    }

    public String getHeadRevision() {
        return this.HeadRevision;
    }

    public void setHeadRevision(String HeadRevision) {
        this.HeadRevision = HeadRevision;
    }

    public void setAuth(RancidNodeAuthentication auth) {
        this.m_auth = auth;
    }

    public RancidNodeAuthentication getAuth() {
        return this.m_auth;
    }

    public void addInventoryNode(String version, InventoryNode invNode) {
        this.nodeVersions.put(version, invNode);
    }
}

