/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jicmp.jna;

import com.sun.jna.Structure;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class sockaddr_in
extends Structure {
    public short sin_family;
    public byte[] sin_port;
    public byte[] sin_addr;
    public byte[] sin_zero = new byte[8];

    public sockaddr_in(int family, byte[] addr, byte[] port) {
        this.sin_family = (short)(0xFFFF & family);
        this.assertLen("port", port, 2);
        this.sin_port = port == null ? null : (byte[])port.clone();
        this.assertLen("address", addr, 4);
        this.sin_addr = addr == null ? null : (byte[])addr.clone();
    }

    public sockaddr_in() {
        this(0, new byte[4], new byte[2]);
    }

    public sockaddr_in(InetAddress address, int port) {
        this(2, address.getAddress(), new byte[]{(byte)(0xFF & port >> 8), (byte)(0xFF & port)});
    }

    private void assertLen(String field, byte[] addr, int len) {
        if (addr.length != len) {
            throw new IllegalArgumentException(field + " length must be " + len + " bytes");
        }
    }

    public InetAddress getAddress() {
        try {
            return InetAddress.getByAddress(this.sin_addr);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public void setAddress(InetAddress address) {
        byte[] addr = address.getAddress();
        this.assertLen("address", addr, 4);
        this.sin_addr = addr;
    }

    public int getPort() {
        int port = 0;
        for (int i = 0; i < 2; ++i) {
            port = port << 8 | this.sin_port[i] & 0xFF;
        }
        return port;
    }

    public void setPort(int port) {
        byte[] p = new byte[]{(byte)(0xFF & port >> 8), (byte)(0xFF & port)};
        this.assertLen("port", p, 2);
        this.sin_port = p;
    }
}

