/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.bootstrap;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.server.RMISocketFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.opennms.bootstrap.HostRMIServerSocketFactory;
import org.opennms.bootstrap.OpenNMSProxyLoginModule;

public abstract class Bootstrap {
    private static final boolean DEBUG = Boolean.getBoolean("opennms.bootstrap.debug");
    protected static final String BOOT_PROPERTIES_NAME = "bootstrap.properties";
    protected static final String RRD_PROPERTIES_NAME = "rrd-configuration.properties";
    protected static final String LIBRARY_PROPERTIES_NAME = "libraries.properties";
    protected static final String OPENNMS_PROPERTIES_NAME = "opennms.properties";
    protected static final String OPENNMS_PROPERTIES_D_NAME = "opennms.properties.d";
    protected static final String OPENNMS_HOME_PROPERTY = "opennms.home";
    private static FileFilter m_dirFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };
    private static FilenameFilter m_jarFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    };
    private static HostRMIServerSocketFactory m_rmiServerSocketFactory;
    private static FilenameFilter m_propertiesFilter;

    public static ClassLoader loadClasses(String dirStr, boolean recursive, boolean append) throws MalformedURLException {
        LinkedList<URL> urls = new LinkedList<URL>();
        if (append) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (URL u : ((URLClassLoader)classLoader).getURLs()) {
                urls.add(u);
            }
        }
        StringTokenizer toke = new StringTokenizer(dirStr, File.pathSeparator);
        while (toke.hasMoreTokens()) {
            String token = toke.nextToken();
            Bootstrap.loadClasses(new File(token), recursive, urls);
        }
        if (DEBUG) {
            System.err.println("urls:");
            for (URL u : urls) {
                System.err.println("  " + u);
            }
        }
        return Bootstrap.newClassLoader(urls);
    }

    public static ClassLoader loadClasses(File dir, boolean recursive) throws MalformedURLException {
        LinkedList<URL> urls = new LinkedList<URL>();
        Bootstrap.loadClasses(dir, recursive, urls);
        return Bootstrap.newClassLoader(urls);
    }

    public static ClassLoader newClassLoader(List<URL> urls) {
        URL[] urlsArray = urls.toArray(new URL[0]);
        return URLClassLoader.newInstance(urlsArray);
    }

    public static void loadClasses(File dir, boolean recursive, List<URL> urls) throws MalformedURLException {
        Object[] children;
        Object[] dirlist;
        urls.add(dir.toURI().toURL());
        if (recursive && (dirlist = dir.listFiles(m_dirFilter)) != null) {
            Arrays.sort(dirlist);
            for (Object childDir : dirlist) {
                Bootstrap.loadClasses((File)childDir, recursive, urls);
            }
        }
        if ((children = dir.listFiles(m_jarFilter)) != null) {
            Arrays.sort(children);
            for (Object childFile : children) {
                urls.add(((File)childFile).toURI().toURL());
            }
        }
    }

    protected static List<File> getPropertiesFiles(File opennmsHome) {
        Object[] properties;
        File etc = new File(opennmsHome, "etc");
        ArrayList<File> propertiesFiles = new ArrayList<File>();
        propertiesFiles.add(new File(etc, BOOT_PROPERTIES_NAME));
        propertiesFiles.add(new File(etc, RRD_PROPERTIES_NAME));
        propertiesFiles.add(new File(etc, LIBRARY_PROPERTIES_NAME));
        propertiesFiles.add(new File(etc, OPENNMS_PROPERTIES_NAME));
        File opennmsPropertiesDotD = new File(etc, OPENNMS_PROPERTIES_D_NAME);
        if (opennmsPropertiesDotD.isDirectory() && (properties = opennmsPropertiesDotD.listFiles(m_propertiesFilter)) != null) {
            Arrays.sort(properties);
            propertiesFiles.addAll(Arrays.asList(properties));
        }
        return propertiesFiles;
    }

    protected static void loadSystemProperties(File opennmsHome) throws IOException {
        Map<String, String> systemProperties = System.getProperties().entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
        for (File propertiesFile : Bootstrap.getPropertiesFiles(opennmsHome)) {
            try {
                FileInputStream is = new FileInputStream(propertiesFile);
                Throwable throwable = null;
                try {
                    if (DEBUG) {
                        System.err.println("Loading system properties from: " + propertiesFile.getAbsolutePath());
                    }
                    Properties props = new Properties();
                    props.load(is);
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        String key = entry.getKey().toString();
                        String value = entry.getValue().toString();
                        if (systemProperties.containsKey(key)) {
                            if (!DEBUG) continue;
                            System.err.println("Skipping: " + key);
                            continue;
                        }
                        System.setProperty(key, value);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)is).close();
                }
            }
            catch (FileNotFoundException e2) {
                if (!DEBUG) continue;
                System.err.println("Skipping: " + propertiesFile.getAbsolutePath());
            }
        }
    }

    protected static boolean isValidOpenNMSHome(File opennmsHome) {
        File etc = new File(opennmsHome, "etc");
        File opennmsProperties = new File(etc, OPENNMS_PROPERTIES_NAME);
        return opennmsProperties.exists();
    }

    protected static File findOpenNMSHome() throws Exception {
        File opennmsHome;
        String opennmsHomeProperty = System.getProperty(OPENNMS_HOME_PROPERTY);
        if (opennmsHomeProperty != null && Bootstrap.isValidOpenNMSHome(opennmsHome = new File(opennmsHomeProperty))) {
            return opennmsHome;
        }
        opennmsHome = Bootstrap.findOpenNMSHome();
        if (opennmsHome == null) {
            System.err.println("Could not determine OpenNMS home directory.  Use \"-Dopennms.home=...\" option to Java to specify a specific OpenNMS home directory.  E.g.: \"java -Dopennms.home=... -jar ...\".");
            System.exit(1);
        } else if (!Bootstrap.isValidOpenNMSHome(opennmsHome)) {
            throw new RuntimeException("Unable to determine the location $OPENNMS_HOME.");
        }
        System.setProperty(OPENNMS_HOME_PROPERTY, opennmsHome.getAbsolutePath());
        return opennmsHome;
    }

    public static File findOpenNMSHomeUsingJarPath() {
        ClassLoader l = Thread.currentThread().getContextClassLoader();
        try {
            URL subUrl;
            String classFile = Bootstrap.class.getName().replace('.', '/') + ".class";
            URL url = l.getResource(classFile);
            if (url.getProtocol().equals("jar") && (subUrl = new URL(url.getFile())).getProtocol().equals("file")) {
                String filePath = subUrl.getFile();
                int i = filePath.lastIndexOf(33);
                File file = new File(filePath.substring(0, i));
                return file.getParentFile().getParentFile();
            }
        }
        catch (MalformedURLException e) {
            return null;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        File opennmsHome = Bootstrap.findOpenNMSHome();
        Bootstrap.loadSystemProperties(opennmsHome);
        String classToExec = System.getProperty("opennms.manager.class", "org.opennms.netmgt.vmmgr.Controller");
        String classToExecMethod = System.getProperty("opennms.manager.method", "main");
        String[] classToExecArgs = args;
        Bootstrap.executeClass(classToExec, classToExecMethod, classToExecArgs, false);
    }

    protected static void executeClass(String classToExec, String classToExecMethod, String[] classToExecArgs, boolean appendClasspath) throws ClassNotFoundException, NoSuchMethodException, IOException {
        Bootstrap.executeClass(classToExec, classToExecMethod, classToExecArgs, appendClasspath, false);
    }

    protected static void executeClass(String classToExec, String classToExecMethod, String[] classToExecArgs, boolean appendClasspath, boolean recurse) throws ClassNotFoundException, NoSuchMethodException, IOException {
        String dir = System.getProperty("opennms.classpath");
        if (dir == null) {
            dir = System.getProperty(OPENNMS_HOME_PROPERTY) + File.separator + "classes" + File.pathSeparator + System.getProperty(OPENNMS_HOME_PROPERTY) + File.separator + "lib" + File.pathSeparator + System.getProperty(OPENNMS_HOME_PROPERTY) + File.separator + "etc";
        }
        dir = dir + File.pathSeparator + System.getProperty("java.home") + File.separator + ".." + File.separator + "lib" + File.separator + "tools.jar";
        if (System.getProperty("org.opennms.protocols.icmp.interfaceJar") != null) {
            dir = dir + File.pathSeparator + System.getProperty("org.opennms.protocols.icmp.interfaceJar");
        }
        if (System.getProperty("org.opennms.rrd.interfaceJar") != null) {
            dir = dir + File.pathSeparator + System.getProperty("org.opennms.rrd.interfaceJar");
        }
        if (DEBUG) {
            System.err.println("dir = " + dir);
        }
        ClassLoader cl = Bootstrap.loadClasses(dir, recurse, appendClasspath);
        Bootstrap.configureRMI(cl);
        if (classToExec != null) {
            String className = classToExec;
            Class[] classes = new Class[]{classToExecArgs.getClass()};
            final Object[] methodArgs = new Object[]{classToExecArgs};
            Class<?> c = cl.loadClass(className);
            final Method method = c.getMethod(classToExecMethod, classes);
            Runnable execer = new Runnable(){

                @Override
                public void run() {
                    try {
                        method.invoke(null, methodArgs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
            };
            Thread bootstrapper = new Thread(execer, "Main");
            bootstrapper.setContextClassLoader(cl);
            bootstrapper.start();
        }
    }

    private static void configureRMI(ClassLoader cl) throws IOException {
        if (m_rmiServerSocketFactory != null) {
            return;
        }
        String host = System.getProperty("opennms.poller.server.serverHost", "localhost");
        if ("localhost".equals(host) || "127.0.0.1".equals(host) || "::1".equals(host)) {
            if (System.getProperty("java.rmi.server.hostname") == null) {
                System.setProperty("java.rmi.server.hostname", host);
            }
            m_rmiServerSocketFactory = new HostRMIServerSocketFactory("localhost");
            RMISocketFactory.setSocketFactory(m_rmiServerSocketFactory);
        }
        OpenNMSProxyLoginModule.setClassloader(cl);
    }

    static {
        m_propertiesFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".properties");
            }
        };
    }
}

