/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vmmgr;

import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.List;
import javax.management.MBeanServer;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.config.ServiceConfigFactory;
import org.opennms.netmgt.config.service.Service;
import org.opennms.netmgt.config.service.types.InvokeAtType;
import org.opennms.netmgt.vmmgr.Invoker;
import org.opennms.netmgt.vmmgr.InvokerResult;
import org.opennms.netmgt.vmmgr.InvokerService;
import org.opennms.netmgt.vmmgr.Manager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Starter {
    private static final Logger LOG = LoggerFactory.getLogger(Starter.class);
    private static final String LOG4J_CATEGORY = "manager";

    private void setLogPrefix() {
        Logging.putPrefix((String)LOG4J_CATEGORY);
    }

    public void startDaemon() {
        try {
            this.setLogPrefix();
            this.setDefaultProperties();
            this.start();
        }
        catch (Exception e) {
            this.die("Exception during startup: " + e.getMessage(), e);
        }
    }

    private void setDefaultProperties() {
        this.setupFileResourceProperty("opennms.library.jicmp", System.mapLibraryName("jicmp"), "Initialization of ICMP socket will likely fail.");
        this.setupFileResourceProperty("opennms.library.jrrd", System.mapLibraryName("jrrd"), "Initialization of RRD code will likely fail if the JniRrdStrategy is used.");
        this.setupFileResourceProperty("jcifs.properties", "jcifs.properties", "Initialization of JCIFS will likely fail or may be improperly configured.");
    }

    private void setupFileResourceProperty(String propertyName, String file, String notFoundWarning) {
        if (System.getProperty(propertyName) == null) {
            LOG.debug("System property '{}' not set.  Searching for file '{}' in the class path.", (Object)propertyName, (Object)file);
            URL url = this.getClass().getClassLoader().getResource(file);
            if (url != null) {
                LOG.info("Found file '{}' at '{}'.  Setting '{}' to this path.", new Object[]{file, url.getPath(), propertyName});
                System.setProperty(propertyName, url.getPath());
            } else {
                LOG.warn("Did not find file '{}' in the class path. {} Set the property '{}' to the location of the file.", new Object[]{file, notFoundWarning, propertyName});
            }
        } else {
            LOG.debug("System property '{}' already set to '{}'.", (Object)propertyName, (Object)System.getProperty(propertyName));
        }
    }

    private void die(String message, Throwable t) {
        LOG.error(message, t);
        System.exit(1);
    }

    public void die(String message) {
        this.die(message, null);
    }

    private void start() {
        LOG.debug("Beginning startup");
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Invoker invoker = new Invoker();
        invoker.setServer(server);
        invoker.setAtType(InvokeAtType.START);
        List<InvokerService> services = InvokerService.createServiceList(new ServiceConfigFactory().getServices());
        invoker.setServices(services);
        invoker.instantiateClasses();
        List<InvokerResult> resultInfo = invoker.invokeMethods();
        for (InvokerResult result : resultInfo) {
            if (result == null || result.getThrowable() == null) continue;
            Service service = result.getService();
            String name = service.getName();
            String className = service.getClassName();
            String message = "An error occurred while attempting to start the \"" + name + "\" service (class " + className + ").  " + "Shutting down and exiting.";
            LOG.error(message, result.getThrowable());
            System.err.println(message);
            result.getThrowable().printStackTrace();
            Manager manager = new Manager();
            manager.stop();
            manager.doSystemExit();
            return;
        }
        LOG.debug("Startup complete");
    }
}

