/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.poller.remote;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.swing.JOptionPane;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.opennms.netmgt.icmp.NullPinger;
import org.opennms.netmgt.icmp.Pinger;
import org.opennms.netmgt.icmp.PingerFactory;
import org.opennms.netmgt.poller.remote.PollerFrontEnd;
import org.opennms.netmgt.poller.remote.support.DefaultPollerFrontEnd;
import org.opennms.poller.remote.AuthenticationBean;
import org.opennms.poller.remote.GroovyGui;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class Main
implements Runnable {
    private static final Logger LOG;
    protected final String[] m_args;
    protected URI m_uri = null;
    protected String m_locationName;
    protected String m_username = null;
    protected String m_password = null;
    protected boolean m_gui = false;
    protected boolean m_disableIcmp = false;

    private static void copyJnlpSystemProperties() {
        Properties systemPropertiesClone = (Properties)System.getProperties().clone();
        for (String prefix : new String[]{"jnlp.", "javaws."}) {
            systemPropertiesClone.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(propKey, value) -> {
                String key = (String)propKey;
                if (key.startsWith(prefix)) {
                    String newKey = key.substring(prefix.length());
                    System.out.printf("Copying system property %s to %s\n", key, newKey);
                    System.setProperty(newKey, (String)value);
                }
            }));
        }
    }

    private Main(String[] args) {
        this.m_args = Arrays.copyOf(args, args.length);
    }

    public void initializePinger() {
        block4: {
            if (this.m_disableIcmp) {
                LOG.info("Disabling ICMP by user request.");
                System.setProperty("org.opennms.netmgt.icmp.pingerClass", "org.opennms.netmgt.icmp.NullPinger");
                PingerFactory.setInstance((Pinger)new NullPinger());
                return;
            }
            String pingerClass = System.getProperty("org.opennms.netmgt.icmp.pingerClass");
            if (pingerClass == null) {
                LOG.info("System property org.opennms.netmgt.icmp.pingerClass is not set; using JnaPinger by default");
                System.setProperty("org.opennms.netmgt.icmp.pingerClass", "org.opennms.netmgt.icmp.jna.JnaPinger");
            }
            LOG.info("Pinger class: {}", (Object)System.getProperty("org.opennms.netmgt.icmp.pingerClass"));
            try {
                Pinger pinger = PingerFactory.getInstance();
                pinger.ping(InetAddress.getLoopbackAddress());
            }
            catch (Throwable t) {
                LOG.warn("Unable to get pinger instance.  Setting pingerClass to NullPinger.  For details, see: http://www.opennms.org/wiki/ICMP_could_not_be_initialized");
                System.setProperty("org.opennms.netmgt.icmp.pingerClass", "org.opennms.netmgt.icmp.NullPinger");
                PingerFactory.setInstance((Pinger)new NullPinger());
                if (!this.m_gui) break block4;
                String message = "ICMP (ping) could not be initialized: " + t.getMessage() + "\nDisabling ICMP and using the NullPinger instead.\nFor details, see: http://www.opennms.org/wiki/ICMP_could_not_be_initialized";
                JOptionPane.showMessageDialog(null, message, "ICMP Not Available", 2);
            }
        }
    }

    private void getAuthenticationInfo() {
        if (this.m_uri == null || this.m_uri.getScheme() == null) {
            throw new RuntimeException("no URI specified!");
        }
        if (this.m_uri.getScheme().equals("rmi")) {
            return;
        }
        if (this.m_username == null) {
            GroovyGui gui = Main.createGui();
            gui.createAndShowGui();
            AuthenticationBean auth = gui.getAuthenticationBean();
            this.m_username = auth.getUsername();
            this.m_password = auth.getPassword();
        }
        if (this.m_username != null) {
            SecurityContextHolder.setStrategyName((String)"MODE_GLOBAL");
            SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)this.m_username, (Object)this.m_password));
        }
    }

    private static GroovyGui createGui() {
        try {
            return (GroovyGui)Class.forName("org.opennms.groovy.poller.remote.ConfigurationGui").newInstance();
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to find Configuration GUI!", e);
        }
    }

    @Override
    public void run() {
        try {
            this.parseArguments(this.m_args);
            this.initializePinger();
            this.getAuthenticationInfo();
            AbstractApplicationContext context = this.createAppContext();
            PollerFrontEnd frontEnd = this.getPollerFrontEnd(context);
            if (!this.m_gui && !frontEnd.isRegistered()) {
                if (this.m_locationName == null) {
                    LOG.error("No location name provided.  You must pass a location name the first time you start the remote poller!");
                    System.exit(27);
                } else {
                    frontEnd.register(this.m_locationName);
                }
            }
        }
        catch (Throwable e) {
            LOG.error("Exception occurred during registration!", e);
            System.exit(27);
        }
    }

    private void parseArguments(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption("h", "help", false, "this help");
        options.addOption("d", "debug", false, "write debug messages to the log");
        options.addOption("g", "gui", false, "start a GUI (default: false)");
        options.addOption("i", "disable-icmp", false, "disable ICMP/ping (overrides -Dorg.opennms.netmgt.icmp.pingerClass=)");
        options.addOption("l", "location", true, "the location name of this remote poller");
        options.addOption("u", "url", true, "the URL for OpenNMS (example: https://server-name/opennms-remoting)");
        options.addOption("n", "name", true, "the name of the user to connect as");
        options.addOption("p", "password", true, "the password to use when connecting");
        PosixParser parser = new PosixParser();
        CommandLine cl = parser.parse(options, args);
        if (cl.hasOption("h")) {
            Main.usage(options);
            System.exit(1);
        }
        if (cl.hasOption("d")) {
            // empty if block
        }
        if (cl.hasOption("i")) {
            this.m_disableIcmp = true;
        }
        if (cl.hasOption("l")) {
            this.m_locationName = cl.getOptionValue("l");
        }
        if (cl.hasOption("u")) {
            String arg = cl.getOptionValue("u").toLowerCase();
            try {
                this.m_uri = new URI(arg);
            }
            catch (URISyntaxException e) {
                Main.usage(options);
                e.printStackTrace();
                System.exit(2);
            }
        } else {
            Main.usage(options);
            System.exit(3);
        }
        if (cl.hasOption("g")) {
            this.m_gui = true;
        }
        if (cl.hasOption("n")) {
            this.m_username = cl.getOptionValue("n");
            this.m_password = cl.getOptionValue("p");
            if (this.m_password == null) {
                this.m_password = "";
            }
        }
        if (this.m_username == null) {
            this.m_username = System.getProperty("opennms.poller.server.username");
            if (this.m_username != null) {
                this.m_password = System.getProperty("opennms.poller.server.password");
                if (this.m_password == null) {
                    this.m_password = "";
                }
            }
        }
    }

    private static void usage(Options o) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(Main.class.getName() + " -u [URL] [options]", o);
    }

    private AbstractApplicationContext createAppContext() {
        File homeDir = new File(System.getProperty("user.home"));
        String homeUrl = homeDir.toURI().toString();
        if (homeUrl.endsWith("/")) {
            homeUrl = homeUrl.substring(0, homeUrl.length() - 1);
        }
        LOG.info("user.home.url = {}", (Object)homeUrl);
        System.setProperty("user.home.url", homeUrl);
        String serverURI = this.m_uri.toString().replaceAll("/*$", "");
        LOG.info("opennms.poller.server.url = {}", (Object)serverURI);
        System.setProperty("opennms.poller.server.url", serverURI);
        LOG.info("location name = {}", (Object)this.m_locationName);
        ArrayList<String> configs = new ArrayList<String>();
        configs.add("classpath:/META-INF/opennms/applicationContext-remotePollerBackEnd-" + this.m_uri.getScheme() + ".xml");
        configs.add("classpath:/META-INF/opennms/applicationContext-pollerFrontEnd.xml");
        if (this.m_gui) {
            configs.add("classpath:/META-INF/opennms/applicationContext-ws-gui.xml");
        }
        final ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(configs.toArray(new String[0]));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Main.shutdownContextAndExit((AbstractApplicationContext)context);
            }
        });
        return context;
    }

    private PollerFrontEnd getPollerFrontEnd(final AbstractApplicationContext context) {
        PollerFrontEnd frontEnd = (PollerFrontEnd)context.getBean("pollerFrontEnd");
        frontEnd.addPropertyChangeListener(new PropertyChangeListener(){

            private boolean shouldExit(PropertyChangeEvent e) {
                LOG.info("shouldExit: received property change event for property: {}; oldvalue: {}; newvalue: {}", new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
                String propName = e.getPropertyName();
                Object newValue = e.getNewValue();
                if (DefaultPollerFrontEnd.PollerFrontEndStates.exitNecessary.toString().equals(propName) && Boolean.TRUE.equals(newValue)) {
                    LOG.info("shouldExit: Exiting because exitNecessary is TRUE");
                    return true;
                }
                if (DefaultPollerFrontEnd.PollerFrontEndStates.started.toString().equals(propName) && Boolean.FALSE.equals(newValue)) {
                    LOG.info("shouldExit: Exiting because started is now false");
                    return true;
                }
                LOG.info("shouldExit: not exiting");
                return false;
            }

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (this.shouldExit(e)) {
                    Main.shutdownContextAndExit(context);
                }
            }
        });
        return frontEnd;
    }

    private static void shutdownContextAndExit(AbstractApplicationContext context) {
        int returnCode = 0;
        if (context.isActive()) {
            try {
                LOG.info("Shutting down PollerFrontEnd scheduler");
                ((Scheduler)context.getBean("scheduler")).shutdown();
            }
            catch (SchedulerException ex) {
                LOG.warn("Shutting down PollerFrontEnd scheduler failed", (Throwable)ex);
                returnCode = 10;
            }
            LOG.info("PollerFrontEnd scheduler shutdown complete");
            context.close();
        }
        final int returnCodeValue = returnCode;
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.exit(returnCodeValue);
            }
        }.start();
    }

    public static void main(String[] args) {
        try {
            String killSwitchFileName = System.getProperty("opennms.poller.killSwitch.resource");
            File killSwitch = null;
            if (!"".equals(killSwitchFileName) && killSwitchFileName != null && !(killSwitch = new File(killSwitchFileName)).exists()) {
                try {
                    killSwitch.createNewFile();
                }
                catch (IOException e) {
                    LOG.error("Could not create kill switch file at path {}", (Object)killSwitchFileName, (Object)e);
                }
            }
            new Main(args).run();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        Main.copyJnlpSystemProperties();
        LOG = LoggerFactory.getLogger(Main.class);
    }
}

