/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.javamail;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.event.TransportListener;
import javax.mail.internet.MimeMessage;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.javamail.JavaMailer2;
import org.opennms.javamail.JavaMailerConfig;
import org.opennms.javamail.JavaMailerException;
import org.opennms.netmgt.config.javamail.JavamailProperty;
import org.opennms.netmgt.config.javamail.SendmailConfig;
import org.opennms.netmgt.config.javamail.SendmailMessage;
import org.opennms.netmgt.config.javamail.SendmailProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.MimeMailMessage;

public class JavaSendMailer
extends JavaMailer2 {
    private static final Logger LOG = LoggerFactory.getLogger(JavaSendMailer.class);
    private Properties m_properties;
    private SendmailConfig m_config;
    private MimeMailMessage m_message;
    private Session m_session;

    public JavaSendMailer(SendmailConfig config, boolean useJmProps) throws JavaMailerException {
        this.m_config = config;
        try {
            this.m_session = Session.getInstance((Properties)this.createProps(useJmProps), (Authenticator)this.createAuthenticator());
            this.m_message = this.buildMimeMessage(config.getSendmailMessage());
            if (this.m_config.isDebug()) {
                this.m_session.setDebugOut(new PrintStream(new JavaMailer2.LoggingByteArrayOutputStream()));
            }
            this.m_session.setDebug(this.m_config.getDebug());
        }
        catch (IOException e) {
            throw new JavaMailerException("IO problem creating session", e);
        }
    }

    public JavaSendMailer(SendmailConfig config) throws JavaMailerException {
        this(config, true);
    }

    public MimeMailMessage buildMimeMessage(SendmailMessage msg) {
        if (this.m_config.getSendmailMessage() != msg) {
            this.m_config.setSendmailMessage(msg);
        }
        MimeMailMessage mimeMsg = new MimeMailMessage(new MimeMessage(this.m_session));
        mimeMsg.setFrom(this.m_config.getSendmailMessage().getFrom());
        mimeMsg.setTo(this.m_config.getSendmailMessage().getTo());
        mimeMsg.setSubject(this.m_config.getSendmailMessage().getSubject());
        return mimeMsg;
    }

    public Authenticator createAuthenticator() {
        Authenticator auth = this.m_config.isUseAuthentication() ? new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(JavaSendMailer.this.m_config.getUserAuth().getUserName(), JavaSendMailer.this.m_config.getUserAuth().getPassword());
            }
        } : null;
        return auth;
    }

    private Properties createProps(boolean useJmProps) throws IOException {
        Properties props = this.generatePropsFromConfig(this.m_config.getJavamailPropertyCollection());
        this.configureProperties(props, useJmProps);
        return Session.getDefaultInstance((Properties)new Properties()).getProperties();
    }

    private Properties generatePropsFromConfig(List<JavamailProperty> javamailPropertyCollection) {
        Properties props = new Properties();
        for (JavamailProperty property : javamailPropertyCollection) {
            props.put(property.getName(), property.getValue());
        }
        return props;
    }

    private void configureProperties(Properties sendmailConfigDefinedProps, boolean useJmProps) {
        Properties props = null;
        try {
            props = JavaMailerConfig.getProperties();
            if (useJmProps) {
                this.m_config.setDebug(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.debug", (boolean)this.m_config.getDebug()));
                this.m_config.getSendmailHost().setHost(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.mailHost", (String)this.m_config.getSendmailHost().getHost()));
                this.m_config.setUseJmta(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.useJMTA", (boolean)this.m_config.getUseJmta()));
                this.m_config.getSendmailProtocol().setMailer(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.mailer", (String)this.m_config.getSendmailProtocol().getMailer()));
                this.m_config.getSendmailProtocol().setTransport(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.transport", (String)this.m_config.getSendmailProtocol().getTransport()));
                this.m_config.getSendmailMessage().setFrom(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.fromAddress", (String)this.m_config.getSendmailMessage().getFrom()));
                this.m_config.setUseAuthentication(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.authenticate", (boolean)this.m_config.getUseAuthentication()));
                this.m_config.getUserAuth().setUserName(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.authenticateUser", (String)this.m_config.getUserAuth().getUserName()));
                this.m_config.getUserAuth().setPassword(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.authenticatePassword", (String)this.m_config.getUserAuth().getPassword()));
                this.m_config.getSendmailProtocol().setMessageContentType(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.messageContentType", (String)this.m_config.getSendmailProtocol().getMessageContentType()));
                this.m_config.getSendmailProtocol().setCharSet(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.charset", (String)this.m_config.getSendmailProtocol().getCharSet()));
                this.m_config.getSendmailProtocol().setMessageEncoding(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.encoding", (String)this.m_config.getSendmailProtocol().getMessageEncoding()));
                this.m_config.getSendmailProtocol().setStartTls(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.starttls.enable", (boolean)this.m_config.getSendmailProtocol().isStartTls()));
                this.m_config.getSendmailProtocol().setQuitWait(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.quitwait", (boolean)this.m_config.getSendmailProtocol().isQuitWait()));
                this.m_config.getSendmailHost().setPort(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.smtpport", (long)this.m_config.getSendmailHost().getPort()));
                this.m_config.getSendmailProtocol().setSslEnable(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.smtpssl.enable", (boolean)this.m_config.getSendmailProtocol().isSslEnable()));
            }
        }
        catch (IOException e) {
            LOG.info("configureProperties: could not load javamail.properties, continuing for is no longer required", (Throwable)e);
        }
        if (props == null) {
            props = new Properties();
        }
        props.putAll((Map<?, ?>)sendmailConfigDefinedProps);
        if (!props.containsKey("mail.smtp.auth")) {
            props.setProperty("mail.smtp.auth", String.valueOf(this.m_config.isUseAuthentication()));
        }
        if (!props.containsKey("mail.smtp.starttls.enable")) {
            props.setProperty("mail.smtp.starttls.enable", String.valueOf(this.m_config.getSendmailProtocol().isStartTls()));
        }
        if (!props.containsKey("mail.smtp.quitwait")) {
            props.setProperty("mail.smtp.quitwait", String.valueOf(this.m_config.getSendmailProtocol().isQuitWait()));
        }
        if (!props.containsKey("mail.smtp.port")) {
            props.setProperty("mail.smtp.port", String.valueOf(this.m_config.getSendmailHost().getPort()));
        }
        if (this.m_config.getSendmailProtocol().isSslEnable()) {
            if (!props.containsKey("mail.smtps.auth")) {
                props.setProperty("mail.smtps.auth", String.valueOf(this.m_config.isUseAuthentication()));
            }
            if (!props.containsKey("mail.smtps.socketFactory.class")) {
                props.setProperty("mail.smtps.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            }
            if (!props.containsKey("mail.smtps.socketFactory.port")) {
                props.setProperty("mail.smtps.socketFactory.port", String.valueOf(this.m_config.getSendmailHost().getPort()));
            }
        }
        if (!props.containsKey("mail.smtp.quitwait")) {
            props.setProperty("mail.smtp.quitwait", String.valueOf(this.m_config.getSendmailProtocol().isQuitWait()));
        }
    }

    public void send() throws JavaMailerException {
        this.m_message.setText(this.m_config.getSendmailMessage().getBody());
        this.send(this.m_message);
    }

    private void send(MimeMailMessage message) throws JavaMailerException {
        Transport t = null;
        try {
            SendmailProtocol protoConfig = this.m_config.getSendmailProtocol();
            t = this.m_session.getTransport(protoConfig.getTransport());
            LOG.debug("for transport name '{}' got: {}@{}", new Object[]{protoConfig.getTransport(), t.getClass().getName(), Integer.toHexString(t.hashCode())});
            JavaMailer2.LoggingTransportListener listener = new JavaMailer2.LoggingTransportListener();
            t.addTransportListener((TransportListener)listener);
            if (t.getURLName().getProtocol().equals("mta")) {
                LOG.debug("transport is 'mta', not trying to connect()");
            } else if (this.m_config.isUseAuthentication()) {
                LOG.debug("authenticating to {}", (Object)this.m_config.getSendmailHost().getHost());
                t.connect(this.m_config.getSendmailHost().getHost(), (int)this.m_config.getSendmailHost().getPort(), this.m_config.getUserAuth().getUserName(), this.m_config.getUserAuth().getPassword());
            } else {
                LOG.debug("not authenticating to {}", (Object)this.m_config.getSendmailHost().getHost());
                t.connect(this.m_config.getSendmailHost().getHost(), (int)this.m_config.getSendmailHost().getPort(), null, null);
            }
            t.sendMessage((Message)message.getMimeMessage(), message.getMimeMessage().getAllRecipients());
            listener.assertAllMessagesDelivered();
        }
        catch (NoSuchProviderException e) {
            LOG.error("Couldn't get a transport: {}", (Object)e, (Object)e);
            throw new JavaMailerException("Couldn't get a transport: " + (Object)((Object)e), e);
        }
        catch (MessagingException e) {
            LOG.error("Java Mailer messaging exception: {}", (Object)e, (Object)e);
            throw new JavaMailerException("Java Mailer messaging exception: " + (Object)((Object)e), e);
        }
        finally {
            try {
                if (t != null && t.isConnected()) {
                    t.close();
                }
            }
            catch (MessagingException e) {
                throw new JavaMailerException("Java Mailer messaging exception on transport close: " + (Object)((Object)e), e);
            }
        }
    }

    public void setConfig(SendmailConfig config) {
        this.m_config = config;
    }

    public SendmailConfig getConfig() {
        return this.m_config;
    }

    public void setMessage(MimeMailMessage message) {
        this.m_message = message;
    }

    public MimeMailMessage getMessage() {
        return this.m_message;
    }

    public void setProperties(Properties properties) {
        this.m_properties = properties;
    }

    public Properties getProperties() {
        return this.m_properties;
    }
}

