/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.beans;

import com.atomikos.beans.AbstractPropertyEditorComponent;
import com.atomikos.beans.PrimitiveClasses;
import com.atomikos.beans.Property;
import com.atomikos.beans.PropertyException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class TextFieldComponent
extends AbstractPropertyEditorComponent
implements CaretListener {
    private JTextField text_;
    private JPanel panel_;
    private Property property_;
    private boolean decimal_;

    public TextFieldComponent(Property property) throws PropertyException {
        this.property_ = property;
        this.panel_ = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        this.panel_.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        JLabel label = new JLabel(property.getName());
        this.text_ = new JTextField(10);
        layout.setConstraints(this.text_, c);
        this.text_.setToolTipText(property.getDescription());
        this.panel_.add(this.text_);
        this.text_.addCaretListener(this);
    }

    public TextFieldComponent(Property property, boolean allowsDecimalPoint) throws PropertyException {
        this(property);
        this.decimal_ = allowsDecimalPoint;
        this.text_.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (!(Character.isDigit(c) || c == '\b' || c == '\u007f' || c == '.' && TextFieldComponent.this.decimal_)) {
                    e.consume();
                    TextFieldComponent.this.panel_.getToolkit().beep();
                }
            }
        });
    }

    @Override
    public Component getComponent() {
        try {
            this.text_.setText(this.property_.getEditor().getStringValue());
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        return this.panel_;
    }

    public void actionPerformed(ActionEvent e) {
        Class wrapperClass = PrimitiveClasses.getWrapperClass(this.property_.getType());
        try {
            if (wrapperClass == null) {
                this.getPropertyEditor().setAsText(this.text_.getText());
            } else {
                Object value = PrimitiveClasses.createWrapperObject(this.text_.getText(), this.property_.getType());
                this.getPropertyEditor().setValue(value);
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (this.text_.getText() == null || this.text_.getText().equals("")) {
            return;
        }
        Class wrapperClass = PrimitiveClasses.getWrapperClass(this.property_.getType());
        try {
            if (wrapperClass == null) {
                this.getPropertyEditor().setAsText(this.text_.getText());
            } else {
                Object value = PrimitiveClasses.createWrapperObject(this.text_.getText(), this.property_.getType());
                this.getPropertyEditor().setValue(value);
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }
}

