/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notifications;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.notifications.Header;
import org.opennms.netmgt.config.notifications.Notification;
import org.xml.sax.ContentHandler;

public class Notifications
implements Serializable {
    private Header _header;
    private List<Notification> _notificationList = new ArrayList<Notification>();

    public void addNotification(Notification vNotification) throws IndexOutOfBoundsException {
        this._notificationList.add(vNotification);
    }

    public void addNotification(int index, Notification vNotification) throws IndexOutOfBoundsException {
        this._notificationList.add(index, vNotification);
    }

    public Enumeration<Notification> enumerateNotification() {
        return Collections.enumeration(this._notificationList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Notifications) {
            Notifications temp = (Notifications)obj;
            if (this._header != null) {
                if (temp._header == null) {
                    return false;
                }
                if (!this._header.equals(temp._header)) {
                    return false;
                }
            } else if (temp._header != null) {
                return false;
            }
            if (this._notificationList != null) {
                if (temp._notificationList == null) {
                    return false;
                }
                if (!this._notificationList.equals(temp._notificationList)) {
                    return false;
                }
            } else if (temp._notificationList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Header getHeader() {
        return this._header;
    }

    public Notification getNotification(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._notificationList.size()) {
            throw new IndexOutOfBoundsException("getNotification: Index value '" + index + "' not in range [0.." + (this._notificationList.size() - 1) + "]");
        }
        return this._notificationList.get(index);
    }

    public Notification[] getNotification() {
        Notification[] array = new Notification[]{};
        return this._notificationList.toArray(array);
    }

    public List<Notification> getNotificationCollection() {
        return this._notificationList;
    }

    public int getNotificationCount() {
        return this._notificationList.size();
    }

    public int hashCode() {
        int result = 17;
        if (this._header != null) {
            result = 37 * result + this._header.hashCode();
        }
        if (this._notificationList != null) {
            result = 37 * result + this._notificationList.hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Notification> iterateNotification() {
        return this._notificationList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllNotification() {
        this._notificationList.clear();
    }

    public boolean removeNotification(Notification vNotification) {
        boolean removed = this._notificationList.remove(vNotification);
        return removed;
    }

    public Notification removeNotificationAt(int index) {
        Notification obj = this._notificationList.remove(index);
        return obj;
    }

    public void setHeader(Header header) {
        this._header = header;
    }

    public void setNotification(int index, Notification vNotification) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._notificationList.size()) {
            throw new IndexOutOfBoundsException("setNotification: Index value '" + index + "' not in range [0.." + (this._notificationList.size() - 1) + "]");
        }
        this._notificationList.set(index, vNotification);
    }

    public void setNotification(Notification[] vNotificationArray) {
        this._notificationList.clear();
        for (int i = 0; i < vNotificationArray.length; ++i) {
            this._notificationList.add(vNotificationArray[i]);
        }
    }

    public void setNotification(List<Notification> vNotificationList) {
        this._notificationList.clear();
        this._notificationList.addAll(vNotificationList);
    }

    public void setNotificationCollection(List<Notification> notificationList) {
        this._notificationList = notificationList;
    }

    public static Notifications unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Notifications)Unmarshaller.unmarshal(Notifications.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

