/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.support;

import org.springframework.binding.expression.Expression;
import org.springframework.util.Assert;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.execution.RequestContext;

public class DefaultTransitionCriteria
implements TransitionCriteria {
    private Expression expression;

    public DefaultTransitionCriteria(Expression expression) {
        Assert.notNull((Object)expression, (String)"The transition criteria expression to test is required");
        this.expression = expression;
    }

    public boolean test(RequestContext context) {
        Object result = this.expression.getValue((Object)context);
        if (result == null) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        String eventId = String.valueOf(result);
        return context.getCurrentEvent().getId().equals(eventId);
    }

    public String toString() {
        return this.expression.toString();
    }
}

