/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.util.HashMap;
import java.util.Map;

public enum SnmpValueType {
    INT32(2, "INTEGER"),
    OCTET_STRING(4, "STRING"),
    NULL(5, "Null"),
    OBJECT_IDENTIFIER(6, "OID"),
    IPADDRESS(64, "IpAddress"),
    COUNTER32(65, "Counter32"),
    GAUGE32(66, "Gauge32"),
    TIMETICKS(67, "Timeticks"),
    OPAQUE(68, "Opaque"),
    COUNTER64(70, "Counter64"),
    NO_SUCH_OBJECT(128, "NoSuchObject"),
    NO_SUCH_INSTANCE(129, "NoSuchInstance"),
    END_OF_MIB(130, "EndOfMib");

    private static final Map<Integer, SnmpValueType> s_intMap;
    private int m_int;
    private String m_displayString;

    private SnmpValueType(int i, String displayString) {
        this.m_int = i;
        this.m_displayString = displayString;
    }

    public int getInt() {
        return this.m_int;
    }

    public String getDisplayString() {
        return this.m_displayString;
    }

    public static SnmpValueType valueOf(int i) {
        return s_intMap.get(i);
    }

    static {
        s_intMap = new HashMap<Integer, SnmpValueType>();
        for (SnmpValueType type : SnmpValueType.values()) {
            s_intMap.put(type.getInt(), type);
        }
    }
}

