/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.queue;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.opennms.core.queue.FifoQueue;

public class FifoQueueImpl<T>
implements FifoQueue<T> {
    protected final BlockingQueue<T> m_delegate = new LinkedBlockingQueue<T>();

    @Override
    public void add(T element) throws InterruptedException {
        this.m_delegate.put(element);
    }

    @Override
    public boolean add(T element, long timeout) throws InterruptedException {
        return this.m_delegate.offer(element, timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public T remove() throws InterruptedException {
        return this.m_delegate.take();
    }

    @Override
    public T remove(long timeout) throws InterruptedException {
        return this.m_delegate.poll(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public int size() {
        return this.m_delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_delegate.isEmpty();
    }
}

