/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.ExtensionProviderInfo;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.IQProviderInfo;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderLoader;

public final class ProviderManager {
    private static final Map<String, Object> extensionProviders = new ConcurrentHashMap<String, Object>();
    private static final Map<String, Object> iqProviders = new ConcurrentHashMap<String, Object>();

    public static void addLoader(ProviderLoader loader) {
        if (loader.getIQProviderInfo() != null) {
            for (IQProviderInfo iQProviderInfo : loader.getIQProviderInfo()) {
                iqProviders.put(ProviderManager.getProviderKey(iQProviderInfo.getElementName(), iQProviderInfo.getNamespace()), iQProviderInfo.getProvider());
            }
        }
        if (loader.getExtensionProviderInfo() != null) {
            for (ExtensionProviderInfo extensionProviderInfo : loader.getExtensionProviderInfo()) {
                extensionProviders.put(ProviderManager.getProviderKey(extensionProviderInfo.getElementName(), extensionProviderInfo.getNamespace()), extensionProviderInfo.getProvider());
            }
        }
    }

    public static Object getIQProvider(String elementName, String namespace) {
        String key = ProviderManager.getProviderKey(elementName, namespace);
        return iqProviders.get(key);
    }

    public static Collection<Object> getIQProviders() {
        return Collections.unmodifiableCollection(iqProviders.values());
    }

    public static void addIQProvider(String elementName, String namespace, Object provider) {
        if (!(provider instanceof IQProvider || provider instanceof Class && IQ.class.isAssignableFrom((Class)provider))) {
            throw new IllegalArgumentException("Provider must be an IQProvider or a Class instance sublcassing IQ.");
        }
        String key = ProviderManager.getProviderKey(elementName, namespace);
        iqProviders.put(key, provider);
    }

    public static void removeIQProvider(String elementName, String namespace) {
        String key = ProviderManager.getProviderKey(elementName, namespace);
        iqProviders.remove(key);
    }

    public static Object getExtensionProvider(String elementName, String namespace) {
        String key = ProviderManager.getProviderKey(elementName, namespace);
        return extensionProviders.get(key);
    }

    public static void addExtensionProvider(String elementName, String namespace, Object provider) {
        if (!(provider instanceof PacketExtensionProvider) && !(provider instanceof Class)) {
            throw new IllegalArgumentException("Provider must be a PacketExtensionProvider or a Class instance.");
        }
        String key = ProviderManager.getProviderKey(elementName, namespace);
        extensionProviders.put(key, provider);
    }

    public static void removeExtensionProvider(String elementName, String namespace) {
        String key = ProviderManager.getProviderKey(elementName, namespace);
        extensionProviders.remove(key);
    }

    public static Collection<Object> getExtensionProviders() {
        return Collections.unmodifiableCollection(extensionProviders.values());
    }

    private static String getProviderKey(String elementName, String namespace) {
        return elementName + '#' + namespace;
    }
}

