/*
 * Decompiled with CFR 0.152.
 */
package simple.util;

import java.io.Serializable;

public class BlockingQueue
implements Serializable {
    private volatile int count;
    private Object[] queue;
    private int front;
    private int rear;
    private int capacity;
    private int enqueuing;
    private int dequeuing;

    public BlockingQueue() {
        this(30);
    }

    public BlockingQueue(int capacity) {
        this.capacity = capacity < 1 ? 1 : capacity;
        this.rear = this.capacity - 1;
        this.queue = new Object[capacity];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object object) throws InterruptedException {
        Object[] objectArray = this.queue;
        synchronized (this.queue) {
            this.enqueuing();
            ++this.count;
            this.rear = (this.rear + 1) % this.capacity;
            this.queue[this.rear] = object;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dequeue() throws InterruptedException {
        Object[] objectArray = this.queue;
        synchronized (this.queue) {
            this.dequeuing();
            Object object = this.queue[this.front];
            this.queue[this.front] = null;
            --this.count;
            this.front = (this.front + 1) % this.capacity;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return object;
        }
    }

    private void enqueuing() throws InterruptedException {
        while (this.count == this.capacity) {
            ++this.enqueuing;
            try {
                this.queue.wait();
            }
            finally {
                --this.enqueuing;
            }
        }
        if (this.dequeuing > 0) {
            this.queue.notify();
        }
    }

    private void dequeuing() throws InterruptedException {
        while (this.count == 0) {
            ++this.dequeuing;
            try {
                this.queue.wait();
            }
            finally {
                --this.dequeuing;
            }
        }
        if (this.enqueuing > 0) {
            this.queue.notify();
        }
    }

    public int length() {
        return this.count;
    }
}

