/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

class BufferedOutputStream
extends OutputStream {
    private OutputStream out;
    private byte[] buf;
    private int count;

    public BufferedOutputStream(Socket sock) throws IOException {
        this(sock, 1024);
    }

    public BufferedOutputStream(Socket sock, int size) throws IOException {
        this.out = sock.getOutputStream();
        this.buf = new byte[size];
    }

    public void write(int b) throws IOException {
        int size = this.buf.length;
        if (this.count >= size) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
        this.buf[this.count++] = (byte)b;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int size = this.buf.length;
        if (len > size - this.count) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
        if (len > this.buf.length) {
            this.out.write(b, off, len);
        } else {
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count += len;
        }
    }

    public void flush() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
        this.out.flush();
    }

    public void close() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
        this.out.close();
    }
}

