/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.daemon;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.Callable;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.logging.Logging;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.daemon.BaseOnmsMBean;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public abstract class AbstractSpringContextJmxServiceDaemon<T extends SpringServiceDaemon>
implements BaseOnmsMBean {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSpringContextJmxServiceDaemon.class);
    public static final String DAEMON_BEAN_NAME = "daemon";
    private ClassPathXmlApplicationContext m_context;
    private int m_status = 0;

    protected abstract String getSpringContext();

    protected abstract String getLoggingPrefix();

    protected ApplicationContext getContext() {
        return this.m_context;
    }

    @Override
    public final void init() {
        Logging.withPrefix((String)this.getLoggingPrefix(), (Runnable)new Runnable(){

            @Override
            public void run() {
                LOG.info("{} initializing.", (Object)AbstractSpringContextJmxServiceDaemon.this.getLoggingPrefix());
                LOG.debug("SPRING: thread.classLoader={}", (Object)Thread.currentThread().getContextClassLoader());
                AbstractSpringContextJmxServiceDaemon.this.m_context = (ClassPathXmlApplicationContext)BeanUtils.getFactory((String)AbstractSpringContextJmxServiceDaemon.this.getSpringContext(), ClassPathXmlApplicationContext.class);
                LOG.debug("SPRING: context.classLoader= {}", (Object)AbstractSpringContextJmxServiceDaemon.this.m_context.getClassLoader());
                LOG.info("{} initialization complete.", (Object)AbstractSpringContextJmxServiceDaemon.this.getLoggingPrefix());
            }
        });
    }

    @Override
    public final void start() {
        Logging.withPrefix((String)this.getLoggingPrefix(), (Runnable)new Runnable(){

            @Override
            public void run() {
                LOG.info("{} initializing.", (Object)AbstractSpringContextJmxServiceDaemon.this.getLoggingPrefix());
                LOG.debug("SPRING: thread.classLoader={}", (Object)Thread.currentThread().getContextClassLoader());
                AbstractSpringContextJmxServiceDaemon.this.setStatus(1);
                Object daemon = AbstractSpringContextJmxServiceDaemon.this.getDaemon();
                try {
                    daemon.start();
                }
                catch (Throwable t) {
                    LOG.error("Could not start daemon: {}", (Object)t, (Object)t);
                    try {
                        AbstractSpringContextJmxServiceDaemon.this.stop();
                    }
                    catch (Throwable tt) {
                        LOG.error("Could not stop daemon after it failed to start: {}", (Object)tt, (Object)tt);
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new UndeclaredThrowableException(t);
                }
                AbstractSpringContextJmxServiceDaemon.this.setStatus(2);
                LOG.debug("SPRING: context.classLoader= {}", (Object)AbstractSpringContextJmxServiceDaemon.this.m_context.getClassLoader());
                LOG.info("{} initialization complete.", (Object)AbstractSpringContextJmxServiceDaemon.this.getLoggingPrefix());
            }
        });
    }

    public T getDaemon() {
        return (T)((SpringServiceDaemon)this.m_context.getBean(DAEMON_BEAN_NAME, SpringServiceDaemon.class));
    }

    @Override
    public final void stop() {
        Logging.withPrefix((String)this.getLoggingPrefix(), (Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractSpringContextJmxServiceDaemon.this.setStatus(3);
                if (AbstractSpringContextJmxServiceDaemon.this.m_context != null) {
                    AbstractSpringContextJmxServiceDaemon.this.m_context.close();
                }
                AbstractSpringContextJmxServiceDaemon.this.setStatus(4);
            }
        });
    }

    @Override
    public final int getStatus() {
        return this.m_status;
    }

    private void setStatus(int status) {
        this.m_status = status;
    }

    @Override
    public final String status() {
        try {
            return (String)Logging.withPrefix((String)this.getLoggingPrefix(), (Callable)new Callable<String>(){

                @Override
                public String call() {
                    return Fiber.STATUS_NAMES[AbstractSpringContextJmxServiceDaemon.this.getStatus()];
                }
            });
        }
        catch (Exception e) {
            LOG.error("An exception occurred retrieving status for {}", (Object)this.getLoggingPrefix());
            return "failed";
        }
    }

    @Override
    public final String getStatusText() {
        return this.status();
    }
}

