/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.udp;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.eventd.adaptors.EventHandler;
import org.opennms.netmgt.eventd.adaptors.udp.UdpReceivedEvent;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.EventReceipt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;

final class UdpUuidSender
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(UdpUuidSender.class);
    private List<UdpReceivedEvent> m_eventUuidsOut;
    private volatile boolean m_stop;
    private DatagramSocket m_dgSock;
    private Thread m_context = null;
    private List<EventHandler> m_handlers;
    private String m_logPrefix;

    UdpUuidSender(DatagramSocket sock, List<UdpReceivedEvent> uuidsOut, List<EventHandler> handlers) {
        this.m_dgSock = sock;
        this.m_stop = false;
        this.m_eventUuidsOut = uuidsOut;
        this.m_handlers = handlers;
        this.m_logPrefix = "eventd";
    }

    void stop() throws InterruptedException {
        this.m_stop = true;
        if (this.m_context != null) {
            LOG.debug("Stopping and joining thread context {}", (Object)this.m_context.getName());
            this.m_context.interrupt();
            this.m_context.join();
            LOG.debug("Thread context stopped and joined");
        }
    }

    boolean isAlive() {
        return this.m_context == null ? false : this.m_context.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.m_context = Thread.currentThread();
        Logging.putPrefix((String)this.m_logPrefix);
        if (this.m_stop) {
            LOG.debug("Stop flag set before thread started, exiting");
            return;
        }
        LOG.debug("Thread context started");
        ArrayList<UdpReceivedEvent> eventHold = new ArrayList<UdpReceivedEvent>(30);
        HashMap<UdpReceivedEvent, EventReceipt> receipts = new HashMap<UdpReceivedEvent, EventReceipt>();
        block15: while (!this.m_stop) {
            LOG.debug("Waiting on event receipts to be generated");
            Iterator iterator = this.m_eventUuidsOut;
            synchronized (iterator) {
                while (this.m_eventUuidsOut.isEmpty()) {
                    try {
                        this.m_eventUuidsOut.wait(1000L);
                    }
                    catch (InterruptedException ie) {
                        LOG.debug("Thread context interrupted");
                        break block15;
                    }
                }
                eventHold.addAll(this.m_eventUuidsOut);
                this.m_eventUuidsOut.clear();
            }
            LOG.debug("Received {} event receipts to process", (Object)eventHold.size());
            LOG.debug("Processing receipts");
            for (UdpReceivedEvent re : eventHold) {
                for (Event e : re.getAckedEvents()) {
                    if (e.getUuid() == null) continue;
                    EventReceipt receipt = (EventReceipt)receipts.get(re);
                    if (receipt == null) {
                        receipt = new EventReceipt();
                        receipts.put(re, receipt);
                    }
                    receipt.addUuid(e.getUuid());
                }
            }
            eventHold.clear();
            LOG.debug("Event receipts sorted, transmitting receipts");
            for (Map.Entry entry : receipts.entrySet()) {
                UdpReceivedEvent re = (UdpReceivedEvent)entry.getKey();
                EventReceipt receipt = (EventReceipt)entry.getValue();
                StringWriter writer = new StringWriter();
                try {
                    JaxbUtils.marshal((Object)receipt, (Writer)writer);
                }
                catch (DataAccessException e) {
                    LOG.warn("Failed to build event receipt for agent {}:{}", new Object[]{InetAddressUtils.str((InetAddress)re.getSender()), re.getPort(), e});
                }
                String xml = writer.getBuffer().toString();
                try {
                    byte[] xml_bytes = xml.getBytes("US-ASCII");
                    DatagramPacket pkt = new DatagramPacket(xml_bytes, xml_bytes.length, re.getSender(), re.getPort());
                    LOG.debug("Transmitting receipt to destination {}:{}", (Object)InetAddressUtils.str((InetAddress)re.getSender()), (Object)re.getPort());
                    this.m_dgSock.send(pkt);
                    List<EventHandler> list = this.m_handlers;
                    synchronized (list) {
                        for (EventHandler handler : this.m_handlers) {
                            try {
                                handler.receiptSent(receipt);
                            }
                            catch (Throwable t) {
                                LOG.warn("Error processing event receipt", t);
                            }
                        }
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Receipt transmitted OK {");
                    LOG.debug(xml);
                    LOG.debug("}");
                }
                catch (UnsupportedEncodingException e) {
                    LOG.warn("Failed to convert XML to byte array", (Throwable)e);
                }
                catch (IOException e) {
                    LOG.warn("Failed to send packet to host {}:{}", new Object[]{InetAddressUtils.str((InetAddress)re.getSender()), re.getPort(), e});
                }
            }
            receipts.clear();
        }
        LOG.debug("Context finished, returning");
    }

    void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }
}

