/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.jmx.JmxUtils;
import org.opennms.netmgt.jmx.connection.JmxConnectionManager;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionException;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionWrapper;
import org.opennms.netmgt.jmx.impl.connection.connectors.DefaultConnectionManager;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.opennms.netmgt.snmp.InetAddrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public abstract class JMXMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(JMXMonitor.class);

    protected abstract String getConnectionName();

    public PollStatus poll(MonitoredService svc, Map<String, Object> map) {
        NetworkInterface iface = svc.getNetInterface();
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        PollStatus serviceStatus = PollStatus.unavailable();
        try {
            final Timer timer = new Timer();
            DefaultConnectionManager connectionManager = new DefaultConnectionManager(ParameterMap.getKeyedInteger(map, (String)"retry", (int)3));
            JmxConnectionManager.RetryCallback retryCallback = new JmxConnectionManager.RetryCallback(){

                public void onRetry() {
                    timer.reset();
                }
            };
            try (JmxServerConnectionWrapper connection = connectionManager.connect(this.getConnectionName(), InetAddrUtils.str((InetAddress)ipv4Addr), JmxUtils.convertToStringMap(map), retryCallback);){
                connection.getMBeanServerConnection().getMBeanCount();
                long nanoResponseTime = System.nanoTime() - timer.getStartTime();
                serviceStatus = PollStatus.available((Double)((double)nanoResponseTime / 1000000.0));
            }
            catch (JmxServerConnectionException mbse) {
                String reason = "IOException while polling address: " + ipv4Addr;
                LOG.debug(reason);
                serviceStatus = PollStatus.unavailable((String)reason);
            }
        }
        catch (Throwable e) {
            String reason = "Monitor - failed! " + InetAddressUtils.str((InetAddress)ipv4Addr);
            LOG.debug(reason);
            serviceStatus = PollStatus.unavailable((String)reason);
        }
        return serviceStatus;
    }

    private class Timer {
        private long startTime;

        private Timer() {
            this.reset();
        }

        public void reset() {
            this.startTime = System.nanoTime();
        }

        public long getStartTime() {
            return this.startTime;
        }
    }
}

