/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OspfLink;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OspfNbrTableTracker
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(OspfNbrTableTracker.class);
    public static final SnmpObjId OSPF_NBR_IPADDRESS = SnmpObjId.get((String)".1.3.6.1.2.1.14.10.1.1");
    public static final SnmpObjId OSPF_NBR_ADDRESS_LESS_INDEX = SnmpObjId.get((String)".1.3.6.1.2.1.14.10.1.2");
    public static final SnmpObjId OSPF_NBR_ROUTERID = SnmpObjId.get((String)".1.3.6.1.2.1.14.10.1.3");
    public static final SnmpObjId[] s_ospfnbrtable_elemList = new SnmpObjId[]{OSPF_NBR_IPADDRESS, OSPF_NBR_ADDRESS_LESS_INDEX, OSPF_NBR_ROUTERID};

    public OspfNbrTableTracker() {
        super(s_ospfnbrtable_elemList);
    }

    public OspfNbrTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, s_ospfnbrtable_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new OspfNbrRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processOspfNbrRow((OspfNbrRow)row);
    }

    public void processOspfNbrRow(OspfNbrRow row) {
    }

    public static class OspfNbrRow
    extends SnmpRowResult {
        public OspfNbrRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
        }

        public InetAddress getOspfNbrIpAddress() {
            return this.getValue(OSPF_NBR_IPADDRESS).toInetAddress();
        }

        public InetAddress getOspfNbrRouterId() {
            return this.getValue(OSPF_NBR_ROUTERID).toInetAddress();
        }

        public Integer getOspfNbrAddressLessIndex() {
            return this.getValue(OSPF_NBR_ADDRESS_LESS_INDEX).toInt();
        }

        public OspfLink getOspfLink() {
            LOG.info("getOspfLink: row count: {}", (Object)this.getColumnCount());
            OspfLink link = new OspfLink();
            LOG.info("getOspfLink: row ospf nbr router id: {}", (Object)InetAddressUtils.str((InetAddress)this.getOspfNbrRouterId()));
            LOG.info("getOspfLink: row ospf nbr ip address: {}", (Object)InetAddressUtils.str((InetAddress)this.getOspfNbrIpAddress()));
            LOG.info("getOspfLink: row ospf nbr address less ifindex: {}", (Object)this.getOspfNbrAddressLessIndex());
            link.setOspfRemRouterId(this.getOspfNbrRouterId());
            link.setOspfRemIpAddr(this.getOspfNbrIpAddress());
            link.setOspfRemAddressLessIndex(this.getOspfNbrAddressLessIndex());
            return link;
        }
    }
}

