/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.snmp.CdpInterfacePortNameGetter;
import org.opennms.netmgt.model.CdpLink;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdpCacheTableTracker
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(CdpCacheTableTracker.class);
    public static final SnmpObjId CDP_CACHE_TABLE_ENTRY = SnmpObjId.get((String)".1.3.6.1.4.1.9.9.23.1.2.1.1");
    public static final SnmpObjId CDP_CACHE_ADDRESS_TYPE = SnmpObjId.get((String)".1.3.6.1.4.1.9.9.23.1.2.1.1.3");
    public static final SnmpObjId CDP_CACHE_ADDRESS = SnmpObjId.get((String)".1.3.6.1.4.1.9.9.23.1.2.1.1.4");
    public static final SnmpObjId CDP_CACHE_VERSION = SnmpObjId.get((String)".1.3.6.1.4.1.9.9.23.1.2.1.1.5");
    public static final SnmpObjId CDP_CACHE_DEVICE_ID = SnmpObjId.get((String)".1.3.6.1.4.1.9.9.23.1.2.1.1.6");
    public static final SnmpObjId CDP_CACHE_DEVICE_PORT = SnmpObjId.get((String)".1.3.6.1.4.1.9.9.23.1.2.1.1.7");
    public static final SnmpObjId CDP_CACHE_PLATFORM = SnmpObjId.get((String)".1.3.6.1.4.1.9.9.23.1.2.1.1.8");
    public static final SnmpObjId[] cdpCache_elemList = new SnmpObjId[]{CDP_CACHE_ADDRESS_TYPE, CDP_CACHE_ADDRESS, CDP_CACHE_VERSION, CDP_CACHE_DEVICE_ID, CDP_CACHE_DEVICE_PORT, CDP_CACHE_PLATFORM};

    public CdpCacheTableTracker() {
        super(cdpCache_elemList);
    }

    public CdpCacheTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, cdpCache_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new CdpCacheRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processCdpCacheRow((CdpCacheRow)row);
    }

    public void processCdpCacheRow(CdpCacheRow row) {
    }

    public class CdpCacheRow
    extends SnmpRowResult {
        public CdpCacheRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
            LOG.debug("column count = {}, instance = {}", (Object)columnCount, (Object)instance);
        }

        public Integer getCdpCacheIfIndex() {
            return this.getInstance().getSubIdAt(this.getInstance().length() - 2);
        }

        public Integer getCdpCacheDeviceIndex() {
            return this.getInstance().getLastSubId();
        }

        public Integer getCdpCacheAddressType() {
            return this.getValue(CDP_CACHE_ADDRESS_TYPE).toInt();
        }

        public String getCdpCacheAddress() {
            return this.getValue(CDP_CACHE_ADDRESS).toHexString();
        }

        public InetAddress getCdpCacheIpv4Address() {
            return InetAddressUtils.getIpAddressByHexString((String)this.getCdpCacheAddress());
        }

        public String getCdpCacheVersion() {
            return this.getValue(CDP_CACHE_VERSION).toDisplayString();
        }

        public String getCdpCacheDeviceId() {
            if (this.getValue(CDP_CACHE_DEVICE_ID).isDisplayable()) {
                return this.getValue(CDP_CACHE_DEVICE_ID).toDisplayString();
            }
            return this.getValue(CDP_CACHE_DEVICE_ID).toHexString();
        }

        public String getCdpCacheDevicePort() {
            if (this.getValue(CDP_CACHE_DEVICE_PORT).isDisplayable()) {
                return this.getValue(CDP_CACHE_DEVICE_PORT).toDisplayString();
            }
            return this.getValue(CDP_CACHE_DEVICE_PORT).toHexString();
        }

        public String getCdpCachePlatform() {
            return this.getValue(CDP_CACHE_PLATFORM).toDisplayString();
        }

        public CdpLink getLink(CdpInterfacePortNameGetter cdpInterfacePortNameGetter) {
            LOG.info("processCdpCacheRow: row index: cdpCacheIfindex: {} cdpCacheDeviceIndex: {}", (Object)this.getCdpCacheIfIndex(), (Object)this.getCdpCacheDeviceIndex());
            CdpLink link = new CdpLink();
            link.setCdpCacheIfIndex(this.getCdpCacheIfIndex());
            link.setCdpCacheDeviceIndex(this.getCdpCacheDeviceIndex());
            link.setCdpCacheAddressType(CdpLink.CiscoNetworkProtocolType.get((Integer)this.getCdpCacheAddressType()));
            if (CdpLink.CiscoNetworkProtocolType.ip == link.getCdpCacheAddressType()) {
                link.setCdpCacheAddress(InetAddressUtils.str((InetAddress)this.getCdpCacheIpv4Address()));
            } else {
                link.setCdpCacheAddress(this.getCdpCacheAddress());
            }
            link.setCdpCacheVersion(this.getCdpCacheVersion());
            link.setCdpCacheDeviceId(this.getCdpCacheDeviceId());
            link.setCdpCacheDevicePort(this.getCdpCacheDevicePort());
            link.setCdpCacheDevicePlatform(this.getCdpCachePlatform());
            return cdpInterfacePortNameGetter.get(link);
        }
    }
}

