/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import simple.http.Header;
import simple.http.HeaderList;
import simple.http.HeaderParser;
import simple.http.PlainHeader;
import simple.http.Request;
import simple.http.RequestParser;
import simple.util.ByteStore;
import simple.util.parse.DateParser;
import simple.util.parse.ListParser;

abstract class RequestHeader
implements Request {
    private HeaderParser parser;
    private RequestParser req;
    private DateParser date;
    private HeaderList list;
    private String target;
    private String method;
    private int major = -1;
    private int minor = -1;

    protected RequestHeader(ByteStore buf) {
        this.req = new RequestParser(buf);
        this.parser = new HeaderParser(buf);
        this.list = new HeaderList();
        this.date = new DateParser();
        this.init();
    }

    private void init() {
        while (this.parser.hasMore()) {
            this.list.add(this.parser.next());
        }
    }

    public String getURI() {
        if (this.target != null) {
            return this.target;
        }
        this.target = this.req.getURI();
        return this.target;
    }

    public void setURI(String target) {
        this.target = target;
    }

    public String getMethod() {
        if (this.method != null) {
            return this.method;
        }
        this.method = this.req.getMethod();
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public int getMajor() {
        if (this.major != -1) {
            return this.major;
        }
        this.major = this.req.getMajor();
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        if (this.minor != -1) {
            return this.minor;
        }
        this.minor = this.req.getMinor();
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int headerCount() {
        return this.list.headerCount();
    }

    public void add(String name, String val) {
        this.list.add(new PlainHeader(name, val));
    }

    public void set(String name, String val) {
        this.removeAll(name);
        this.add(name, val);
    }

    public void add(String name, int val) {
        this.add(name, String.valueOf(val));
    }

    public void set(String name, int val) {
        this.removeAll(name);
        this.add(name, val);
    }

    public String getValue(int off) {
        return this.list.getValue(off);
    }

    public String getName(int off) {
        return this.list.getName(off);
    }

    public void addDate(String name, long time) {
        this.date.parse(time);
        this.add(name, this.date.toString());
    }

    public void setDate(String name, long time) {
        this.removeAll(name);
        this.addDate(name, time);
    }

    public long getDate(int off) {
        String value = this.getValue(off);
        if (value == null) {
            return -1L;
        }
        this.date.parse(value);
        return this.date.toLong();
    }

    public long getDate(String name) {
        String value = this.getValue(name);
        if (value == null) {
            return -1L;
        }
        this.date.parse(value);
        return this.date.toLong();
    }

    public int indexOf(String name) {
        return this.list.indexOf(name);
    }

    public int indexOf(String name, int from) {
        return this.list.indexOf(name, from);
    }

    public void remove(int off) {
        this.list.remove(off);
    }

    public void removeAll(String name) {
        this.list.removeAll(name);
    }

    public String getValue(String name) {
        return this.list.getValue(name);
    }

    public String[] getValues(String name) {
        return this.getValues(this.list.getValues(name));
    }

    private String[] getValues(String[] list) {
        return new ListParser(list).list();
    }

    public boolean contains(String name) {
        return this.indexOf(name) != -1;
    }

    public boolean contains(String name, String value) {
        String[] list = this.getValues(name);
        int i = 0;
        while (i < list.length) {
            if (list[i].equalsIgnoreCase(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clear() {
        while (this.headerCount() > 0) {
            this.remove(0);
        }
    }

    public String toString() {
        int size = this.headerCount() * 50;
        StringBuffer buf = new StringBuffer(size);
        buf.append(this.getMethod());
        buf.append(" ").append(this.getURI());
        buf.append(" HTTP/");
        buf.append(this.getMajor()).append(".");
        buf.append(this.getMinor()).append("\r\n");
        int i = 0;
        int len = this.headerCount();
        while (i < len) {
            Header head = this.list.get(i);
            buf.append(head.getName());
            buf.append(": ");
            buf.append(head.getValue());
            buf.append("\r\n");
            ++i;
        }
        buf.append("\r\n");
        return buf.toString();
    }
}

