/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Map;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceHelper.class);

    private ResourceHelper() {
    }

    public static boolean hasScheme(String uri) {
        if (uri == null) {
            return false;
        }
        return uri.startsWith("file:") || uri.startsWith("classpath:") || uri.startsWith("http:");
    }

    public static String getScheme(String uri) {
        if (ResourceHelper.hasScheme(uri)) {
            return uri.substring(0, uri.indexOf(":") + 1);
        }
        return null;
    }

    public static InputStream resolveMandatoryResourceAsInputStream(ClassResolver classResolver, String uri) throws IOException {
        InputStream is = ResourceHelper.resolveResourceAsInputStream(classResolver, uri);
        if (is == null) {
            String resolvedName = ResourceHelper.resolveUriPath(uri);
            throw new FileNotFoundException("Cannot find resource: " + resolvedName + " in classpath for URI: " + uri);
        }
        return is;
    }

    public static InputStream resolveResourceAsInputStream(ClassResolver classResolver, String uri) throws IOException {
        if (uri.startsWith("file:")) {
            uri = ObjectHelper.after(uri, "file:");
            uri = ResourceHelper.tryDecodeUri(uri);
            LOG.trace("Loading resource: {} from file system", (Object)uri);
            return new FileInputStream(uri);
        }
        if (uri.startsWith("http:")) {
            URL url = new URL(uri);
            LOG.trace("Loading resource: {} from HTTP", (Object)uri);
            URLConnection con = url.openConnection();
            con.setUseCaches(false);
            try {
                return con.getInputStream();
            }
            catch (IOException e) {
                if (con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).disconnect();
                }
                throw e;
            }
        }
        if (uri.startsWith("classpath:")) {
            uri = ObjectHelper.after(uri, "classpath:");
            uri = ResourceHelper.tryDecodeUri(uri);
        }
        String resolvedName = ResourceHelper.resolveUriPath(uri);
        LOG.trace("Loading resource: {} from classpath", (Object)resolvedName);
        return classResolver.loadResourceAsStream(resolvedName);
    }

    public static URL resolveMandatoryResourceAsUrl(ClassResolver classResolver, String uri) throws FileNotFoundException, MalformedURLException {
        URL url = ResourceHelper.resolveResourceAsUrl(classResolver, uri);
        if (url == null) {
            String resolvedName = ResourceHelper.resolveUriPath(uri);
            throw new FileNotFoundException("Cannot find resource: " + resolvedName + " in classpath for URI: " + uri);
        }
        return url;
    }

    public static URL resolveResourceAsUrl(ClassResolver classResolver, String uri) throws MalformedURLException {
        if (uri.startsWith("file:")) {
            String name = ObjectHelper.after(uri, "file:");
            uri = ResourceHelper.tryDecodeUri(uri);
            LOG.trace("Loading resource: {} from file system", (Object)uri);
            File file = new File(name);
            if (!file.exists()) {
                return null;
            }
            return new URL(uri);
        }
        if (uri.startsWith("http:")) {
            LOG.trace("Loading resource: {} from HTTP", (Object)uri);
            return new URL(uri);
        }
        if (uri.startsWith("classpath:")) {
            uri = ObjectHelper.after(uri, "classpath:");
            uri = ResourceHelper.tryDecodeUri(uri);
        }
        String resolvedName = ResourceHelper.resolveUriPath(uri);
        LOG.trace("Loading resource: {} from classpath", (Object)resolvedName);
        return classResolver.loadResourceAsURL(resolvedName);
    }

    public static boolean isHttpUri(String uri) {
        if (uri == null) {
            return false;
        }
        return uri.startsWith("http:") || uri.startsWith("https:");
    }

    public static String appendParameters(String uri, Map<String, Object> parameters) throws URISyntaxException {
        if (!parameters.isEmpty()) {
            String query = URISupport.createQueryString(parameters);
            URI u = new URI(uri);
            u = URISupport.createURIWithQuery(u, query);
            parameters.clear();
            return u.toString();
        }
        return uri;
    }

    private static String resolveUriPath(String name) {
        return FileUtil.compactPath(name, '/');
    }

    private static String tryDecodeUri(String uri) {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (Exception e) {
            LOG.trace("Error URL decoding uri using UTF-8 encoding: {}. This exception is ignored.", (Object)uri);
        }
        return uri;
    }
}

