/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.monitoringLocations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.EqualsBuilder;

@Entity
@Table(name="monitoringLocations")
@XmlRootElement(name="location")
@XmlAccessorType(value=XmlAccessType.NONE)
public class LocationDef
implements Serializable {
    private static final long serialVersionUID = -7651610012389148818L;
    @XmlAttribute(name="location-name")
    private String m_locationName;
    @XmlAttribute(name="monitoring-area")
    private String m_monitoringArea;
    @XmlElementWrapper(name="foreign-source-names")
    @XmlElement(name="foreign-source-name")
    private List<String> m_foreignSourceNames;
    @XmlElementWrapper(name="polling-package-names")
    @XmlElement(name="polling-package-name")
    private List<String> m_pollingPackageNames;
    @XmlElementWrapper(name="collection-package-names")
    @XmlElement(name="collection-package-name")
    private List<String> m_collectionPackageNames;
    @XmlAttribute(name="geolocation")
    private String m_geolocation;
    @XmlAttribute(name="longitude")
    private Float m_longitude;
    @XmlAttribute(name="latitude")
    private Float m_latitude;
    @XmlAttribute(name="priority")
    private Long m_priority;
    @XmlElementWrapper(name="tags")
    @XmlElement(name="tag")
    private List<String> m_tags;

    public LocationDef() {
    }

    public LocationDef(String locationName, String monitoringArea, String pollingPackageName) {
        this(locationName, monitoringArea, null, new String[]{pollingPackageName}, null, null, null, null, 100L, new String[0]);
    }

    public LocationDef(String locationName, String monitoringArea, String[] foreignSourceNames, String[] pollingPackageNames, String[] collectionPackageNames, String geolocation, Float latitude, Float longitude, Long priority, String ... tags) {
        this.m_locationName = locationName;
        this.m_monitoringArea = monitoringArea;
        this.m_foreignSourceNames = foreignSourceNames == null ? null : Arrays.asList(foreignSourceNames);
        this.m_pollingPackageNames = pollingPackageNames == null ? null : Arrays.asList(pollingPackageNames);
        this.m_collectionPackageNames = collectionPackageNames == null ? null : Arrays.asList(collectionPackageNames);
        this.m_geolocation = geolocation;
        this.m_latitude = latitude;
        this.m_longitude = longitude;
        this.m_priority = priority;
        this.m_tags = tags == null ? null : Arrays.asList(tags);
    }

    @Id
    @Column(name="id", nullable=false)
    public String getLocationName() {
        return this.m_locationName;
    }

    public void setLocationName(String locationName) {
        this.m_locationName = locationName;
    }

    @Column(name="monitoringArea", nullable=false)
    public String getMonitoringArea() {
        return this.m_monitoringArea;
    }

    public void setMonitoringArea(String monitoringArea) {
        this.m_monitoringArea = monitoringArea;
    }

    @Transient
    public List<String> getForeignSourceNames() {
        return this.m_foreignSourceNames;
    }

    public void setForeignSourceNames(List<String> foreignSourceNames) {
        this.m_foreignSourceNames = foreignSourceNames;
    }

    @ElementCollection
    @JoinTable(name="monitoringLocationsPollingPackages", joinColumns={@JoinColumn(name="monitoringLocationId")})
    @Column(name="packageName")
    public List<String> getPollingPackageNames() {
        return this.m_pollingPackageNames;
    }

    public void setPollingPackageNames(List<String> pollingPackageNames) {
        this.m_pollingPackageNames = pollingPackageNames;
    }

    @ElementCollection
    @JoinTable(name="monitoringLocationsCollectionPackages", joinColumns={@JoinColumn(name="monitoringLocationId")})
    @Column(name="packageName")
    public List<String> getCollectionPackageNames() {
        return this.m_collectionPackageNames;
    }

    public void setCollectionPackageNames(List<String> collectionPackageNames) {
        this.m_collectionPackageNames = collectionPackageNames;
    }

    @Column(name="geolocation")
    public String getGeolocation() {
        return this.m_geolocation;
    }

    public void setGeolocation(String geolocation) {
        this.m_geolocation = geolocation;
    }

    @Column(name="longitude")
    public Float getLongitude() {
        return this.m_longitude;
    }

    public void setLongitude(Float longitude) {
        this.m_longitude = longitude;
    }

    @Column(name="latitude")
    public Float getLatitude() {
        return this.m_latitude;
    }

    public void setLatitude(Float latitude) {
        this.m_latitude = latitude;
    }

    @Column(name="priority")
    public Long getPriority() {
        return this.m_priority == null ? 100L : this.m_priority;
    }

    public void setPriority(Long priority) {
        this.m_priority = priority;
    }

    @ElementCollection
    @JoinTable(name="monitoringLocationsTags", joinColumns={@JoinColumn(name="monitoringLocationId")})
    @Column(name="tag")
    public List<String> getTags() {
        if (this.m_tags == null) {
            return null;
        }
        return Collections.unmodifiableList(this.m_tags);
    }

    public void setTags(List<String> tags) {
        this.m_tags = tags == null || tags.size() == 0 ? null : new ArrayList<String>(tags);
    }

    public int hashCode() {
        int prime = 353;
        int result = 1;
        result = 353 * result + (this.m_latitude == null ? 0 : this.m_latitude.hashCode());
        result = 353 * result + (this.m_longitude == null ? 0 : this.m_longitude.hashCode());
        result = 353 * result + (this.m_geolocation == null ? 0 : this.m_geolocation.hashCode());
        result = 353 * result + (this.m_locationName == null ? 0 : this.m_locationName.hashCode());
        result = 353 * result + (this.m_monitoringArea == null ? 0 : this.m_monitoringArea.hashCode());
        result = 353 * result + (this.m_foreignSourceNames == null || this.m_foreignSourceNames.size() == 0 ? 0 : this.m_foreignSourceNames.hashCode());
        result = 353 * result + (this.m_pollingPackageNames == null || this.m_pollingPackageNames.size() == 0 ? 0 : this.m_pollingPackageNames.hashCode());
        result = 353 * result + (this.m_collectionPackageNames == null || this.m_collectionPackageNames.size() == 0 ? 0 : this.m_collectionPackageNames.hashCode());
        result = 353 * result + (this.m_priority == null ? 0 : this.m_priority.hashCode());
        result = 353 * result + (this.m_tags == null || this.m_tags.size() == 0 ? 0 : this.m_tags.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LocationDef)) {
            return false;
        }
        LocationDef other = (LocationDef)obj;
        return new EqualsBuilder().append((Object)this.getLatitude(), (Object)other.getLatitude()).append((Object)this.getLongitude(), (Object)other.getLongitude()).append((Object)this.getGeolocation(), (Object)other.getGeolocation()).append((Object)this.getLocationName(), (Object)other.getLocationName()).append((Object)this.getMonitoringArea(), (Object)other.getMonitoringArea()).append(this.getForeignSourceNames(), other.getForeignSourceNames()).append(this.getPollingPackageNames(), other.getPollingPackageNames()).append(this.getCollectionPackageNames(), other.getCollectionPackageNames()).append((Object)this.getPriority(), (Object)other.getPriority()).append(this.getTags(), other.getTags()).isEquals();
    }

    public String toString() {
        return "LocationDef [location-name=" + this.m_locationName + ", monitoring-area=" + this.m_monitoringArea + ", foreign-source-names=" + this.m_foreignSourceNames + ", polling-package-names=" + this.m_pollingPackageNames + ", collection-package-names=" + this.m_collectionPackageNames + ", geolocation=" + this.m_geolocation + ", latitude=" + this.m_latitude + ", longitude=" + this.m_longitude + ", priority=" + this.m_priority + ", tags=" + this.m_tags + "]";
    }
}

