/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.SnmpInterfaceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessorFactory;

public class NetworkBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkBuilder.class);
    private final OnmsDistPoller m_distPoller;
    OnmsNode m_currentNode;
    BeanWrapper m_assetBean;
    OnmsIpInterface m_currentIf;
    OnmsSnmpInterface m_currentSnmpIf;
    OnmsMonitoredService m_currentMonSvc;
    private Map<String, OnmsServiceType> m_serviceTypeCache = new HashMap<String, OnmsServiceType>();
    private Map<String, OnmsCategory> m_categoryCache = new HashMap<String, OnmsCategory>();

    public NetworkBuilder(OnmsDistPoller distPoller) {
        this.m_distPoller = distPoller;
    }

    public NetworkBuilder() {
        this.m_distPoller = new OnmsDistPoller("00000000-0000-0000-0000-000000000000");
        this.m_distPoller.setLabel("localhost");
        this.m_distPoller.setLocation("localhost");
        this.m_distPoller.setType("OpenNMS");
    }

    public OnmsDistPoller getDistPoller() {
        return this.m_distPoller;
    }

    public NodeBuilder addNode(String label) {
        this.m_currentNode = new OnmsNode(label);
        this.m_assetBean = PropertyAccessorFactory.forBeanPropertyAccess((Object)this.m_currentNode.getAssetRecord());
        return new NodeBuilder(this.m_currentNode);
    }

    public InterfaceBuilder addInterface(String ipAddr) {
        return this.addInterface(InetAddressUtils.addr((String)ipAddr));
    }

    public InterfaceBuilder addInterface(InetAddress ipAddr) {
        this.m_currentIf = new OnmsIpInterface(ipAddr, this.m_currentNode);
        return new InterfaceBuilder(this.m_currentIf);
    }

    public InterfaceBuilder addInterface(String ipAddr, OnmsSnmpInterface snmpInterface) {
        this.m_currentIf = new OnmsIpInterface(InetAddressUtils.addr((String)ipAddr), this.m_currentNode);
        this.m_currentIf.setSnmpInterface(snmpInterface);
        return new InterfaceBuilder(this.m_currentIf);
    }

    public SnmpInterfaceBuilder addSnmpInterface(int ifIndex) {
        OnmsSnmpInterface snmp = new OnmsSnmpInterface(this.m_currentNode, ifIndex);
        if (this.m_currentIf != null) {
            snmp.getIpInterfaces().add(this.m_currentIf);
        }
        SnmpInterfaceBuilder snmpInterfaceBuilder = new SnmpInterfaceBuilder(snmp);
        this.m_currentSnmpIf = snmp;
        return snmpInterfaceBuilder;
    }

    public OnmsMonitoredService addService(OnmsServiceType serviceType) {
        this.m_serviceTypeCache.put(serviceType.getName(), serviceType);
        if (this.m_currentIf != null) {
            this.m_currentMonSvc = new OnmsMonitoredService(this.m_currentIf, serviceType);
            return this.m_currentMonSvc;
        }
        Set<OnmsIpInterface> ipInterfaces = this.m_currentSnmpIf.getIpInterfaces();
        if (this.m_currentSnmpIf != null && ipInterfaces != null && ipInterfaces.size() > 0) {
            OnmsIpInterface current = ipInterfaces.toArray(new OnmsIpInterface[0])[ipInterfaces.size() - 1];
            this.m_currentMonSvc = new OnmsMonitoredService(current, serviceType);
            return this.m_currentMonSvc;
        }
        this.m_currentMonSvc = null;
        return null;
    }

    public void setDisplayCategory(String displayCategory) {
        this.m_currentNode.getAssetRecord().setDisplayCategory(displayCategory);
    }

    public void setBuilding(String building) {
        this.m_currentNode.getAssetRecord().setBuilding(building);
    }

    public OnmsNode getCurrentNode() {
        return this.m_currentNode;
    }

    public void addCategory(OnmsCategory cat) {
        this.m_categoryCache.put(cat.getName(), cat);
        this.m_currentNode.addCategory(cat);
    }

    public void addCategory(String categoryName) {
        this.addCategory(this.getCategory(categoryName));
    }

    public void clearInterface() {
        this.m_currentIf = null;
        this.m_currentMonSvc = null;
    }

    public OnmsMonitoredService addService(String serviceName) {
        return this.addService(this.getServiceType(serviceName));
    }

    public void setAssetAttribute(String name, String value) {
        try {
            this.m_assetBean.setPropertyValue(name, (Object)value);
        }
        catch (BeansException e) {
            LOG.warn("Could not set property '{}' on asset '{}'", new Object[]{value, name, e});
        }
    }

    public OnmsServiceType getServiceType(String serviceName) {
        if (!this.m_serviceTypeCache.containsKey(serviceName)) {
            this.m_serviceTypeCache.put(serviceName, new OnmsServiceType(serviceName));
        }
        return this.m_serviceTypeCache.get(serviceName);
    }

    public OnmsCategory getCategory(String categoryName) {
        if (!this.m_categoryCache.containsKey(categoryName)) {
            this.m_categoryCache.put(categoryName, new OnmsCategory(categoryName));
        }
        return this.m_categoryCache.get(categoryName);
    }

    public static class InterfaceBuilder {
        final OnmsIpInterface m_iface;

        InterfaceBuilder(OnmsIpInterface iface) {
            this.m_iface = iface;
        }

        public InterfaceBuilder setIsManaged(String managed) {
            this.m_iface.setIsManaged(managed);
            return this;
        }

        public InterfaceBuilder setIsSnmpPrimary(String isSnmpPrimary) {
            this.m_iface.setIsSnmpPrimary(PrimaryType.get(isSnmpPrimary));
            return this;
        }

        public OnmsIpInterface getInterface() {
            return this.m_iface;
        }

        @Deprecated
        public SnmpInterfaceBuilder addSnmpInterface(int ifIndex) {
            OnmsSnmpInterface snmpIf = new OnmsSnmpInterface(this.m_iface.getNode(), ifIndex);
            this.m_iface.setSnmpInterface(snmpIf);
            snmpIf.getIpInterfaces().add(this.m_iface);
            return new SnmpInterfaceBuilder(snmpIf);
        }

        public InterfaceBuilder setId(int id) {
            this.m_iface.setId(id);
            return this;
        }
    }

    public static class NodeBuilder {
        OnmsNode m_node;

        NodeBuilder(OnmsNode node) {
            this.m_node = node;
        }

        public OnmsNode getNode() {
            return this.m_node;
        }

        public NodeBuilder setId(Integer id) {
            this.m_node.setId(id);
            return this;
        }

        public NodeBuilder setForeignSource(String foreignSource) {
            this.m_node.setForeignSource(foreignSource);
            return this;
        }

        public NodeBuilder setForeignId(String foreignId) {
            this.m_node.setForeignId(foreignId);
            return this;
        }

        public OnmsAssetRecord getAssetRecord() {
            return this.m_node.getAssetRecord();
        }

        public NodeBuilder setLabelSource(OnmsNode.NodeLabelSource labelSource) {
            this.m_node.setLabelSource(labelSource);
            return this;
        }

        public NodeBuilder setType(OnmsNode.NodeType type) {
            this.m_node.setType(type);
            return this;
        }

        public NodeBuilder setSysObjectId(String sysObjectId) {
            this.m_node.setSysObjectId(sysObjectId);
            return this;
        }

        public NodeBuilder setSysName(String nodesysname) {
            this.m_node.setSysName(nodesysname);
            return this;
        }
    }
}

