/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.datacollection.DatacollectionGroup;
import org.opennms.netmgt.config.datacollection.Group;
import org.opennms.netmgt.config.datacollection.Groups;
import org.opennms.netmgt.config.datacollection.IncludeCollection;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.datacollection.SnmpCollection;
import org.opennms.netmgt.config.datacollection.SystemDef;
import org.opennms.netmgt.config.datacollection.Systems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessResourceFailureException;

public class DataCollectionConfigParser {
    private static final Logger LOG = LoggerFactory.getLogger(DataCollectionConfigParser.class);
    private String configDirectory;
    private final Map<String, DatacollectionGroup> externalGroupsMap;

    public DataCollectionConfigParser(String configDirectory) {
        this.configDirectory = configDirectory;
        this.externalGroupsMap = new ConcurrentHashMap<String, DatacollectionGroup>();
    }

    protected Map<String, DatacollectionGroup> getExternalGroupMap() {
        return Collections.unmodifiableMap(this.externalGroupsMap);
    }

    public void parseCollection(SnmpCollection collection) {
        if (collection.getIncludeCollections().size() > 0) {
            this.parseExternalResources();
            this.checkCollection(collection);
            for (IncludeCollection include : collection.getIncludeCollections()) {
                if (include.getDataCollectionGroup() != null) {
                    this.addDatacollectionGroup(collection, include.getDataCollectionGroup(), include.getExcludeFilters());
                    continue;
                }
                if (include.getSystemDef() == null) {
                    this.throwException("You must specify at least the data collection group name or system definition name for the include-collection attribute", null);
                    continue;
                }
                this.addSystemDef(collection, include.getSystemDef());
            }
        } else {
            LOG.info("parse: SNMP collection {} doesn't have any external reference.", (Object)collection.getName());
        }
    }

    public Set<ResourceType> getAllResourceTypes() {
        this.parseExternalResources();
        HashSet<ResourceType> resourceTypes = new HashSet<ResourceType>();
        for (DatacollectionGroup group : this.externalGroupsMap.values()) {
            for (ResourceType rt : group.getResourceTypes()) {
                if (this.contains(resourceTypes, rt)) continue;
                resourceTypes.add(rt);
            }
        }
        return resourceTypes;
    }

    private void checkCollection(SnmpCollection collection) {
        if (collection.getSystems() == null) {
            collection.setSystems(new Systems());
        }
        if (collection.getGroups() == null) {
            collection.setGroups(new Groups());
        }
    }

    private boolean contains(Collection<ResourceType> resourceTypes, ResourceType resourceType) {
        for (ResourceType rt : resourceTypes) {
            if (!resourceType.getName().equals(rt.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean contains(Collection<Group> groups, Group group) {
        for (Group g : groups) {
            if (!group.getName().equals(g.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean contains(List<SystemDef> systemDefs, SystemDef systemDef) {
        for (SystemDef sd : systemDefs) {
            if (!systemDef.getName().equals(sd.getName())) continue;
            return true;
        }
        return false;
    }

    private void parseExternalResources() {
        if (this.externalGroupsMap != null && this.externalGroupsMap.size() > 0) {
            LOG.info("parseExternalResources: external data collection groups are already parsed");
            return;
        }
        File folder = new File(this.configDirectory);
        if (!folder.exists() || !folder.isDirectory()) {
            LOG.info("parseExternalResources: directory {} does not exist or is not a folder.", (Object)folder);
            return;
        }
        File[] listOfFiles = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith(".xml");
            }
        });
        final CountDownLatch latch = new CountDownLatch(listOfFiles.length);
        int i = 0;
        for (final File file : listOfFiles) {
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        LOG.debug("parseExternalResources: parsing {}", (Object)file);
                        DatacollectionGroup group = (DatacollectionGroup)JaxbUtils.unmarshal(DatacollectionGroup.class, (Resource)new FileSystemResource(file));
                        Map map = DataCollectionConfigParser.this.externalGroupsMap;
                        synchronized (map) {
                            DataCollectionConfigParser.this.externalGroupsMap.put(group.getName(), group);
                        }
                    }
                    catch (Throwable e) {
                        DataCollectionConfigParser.this.throwException("Can't parse XML file " + file + "; nested exception: " + e.getMessage(), e);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            }, "DataCollectionConfigParser-Thread-" + i++);
            thread.start();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            this.throwException("Exception while waiting for XML parsing threads to complete: " + e.getMessage(), e);
        }
    }

    private SystemDef getSystemDef(String systemDefName) {
        for (DatacollectionGroup group : this.externalGroupsMap.values()) {
            for (SystemDef sd : group.getSystemDefs()) {
                if (!sd.getName().equals(systemDefName)) continue;
                return sd;
            }
        }
        return null;
    }

    private Group getMibObjectGroup(String groupName) {
        for (DatacollectionGroup group : this.externalGroupsMap.values()) {
            for (Group g : group.getGroups()) {
                if (!g.getName().equals(groupName)) continue;
                return g;
            }
        }
        return null;
    }

    private void addSystemDef(SnmpCollection collection, String systemDefName) {
        LOG.debug("addSystemDef: merging system defintion {} into snmp-collection {}", (Object)collection.getName(), (Object)systemDefName);
        SystemDef systemDef = this.getSystemDef(systemDefName);
        if (systemDef == null) {
            this.throwException("Can't find system definition " + systemDefName, null);
        }
        if (this.contains(collection.getSystems().getSystemDefs(), systemDef)) {
            LOG.warn("addSystemDef: system definition {} already exist on SNMP collection {}", (Object)collection.getName(), (Object)systemDefName);
        } else {
            LOG.debug("addSystemDef: adding system definition {} to snmp-collection {}", (Object)collection.getName(), (Object)systemDef.getName());
            collection.getSystems().addSystemDef(systemDef);
            for (String groupName : systemDef.getCollect().getIncludeGroups()) {
                Group group = this.getMibObjectGroup(groupName);
                if (group == null) {
                    LOG.warn("addSystemDef: group {} does not exist on global container", (Object)groupName);
                    continue;
                }
                if (this.contains(collection.getGroups().getGroups(), group)) {
                    LOG.debug("addSystemDef: group {} already exist on SNMP collection {}", (Object)collection.getName(), (Object)groupName);
                    continue;
                }
                LOG.debug("addSystemDef: adding mib object group {} to snmp-collection {}", (Object)collection.getName(), (Object)group.getName());
                collection.getGroups().addGroup(group);
            }
        }
    }

    private void addDatacollectionGroup(SnmpCollection collection, String dataCollectionGroupName, List<String> excludeList) {
        DatacollectionGroup group = this.externalGroupsMap.get(dataCollectionGroupName);
        if (group == null) {
            this.throwException("Group " + dataCollectionGroupName + " does not exist.", null);
        }
        LOG.debug("addDatacollectionGroup: adding all definitions from group {} to snmp-collection {}", (Object)collection.getName(), (Object)group.getName());
        for (SystemDef systemDef : group.getSystemDefs()) {
            String sysDef = systemDef.getName();
            if (!this.shouldAdd(sysDef, excludeList)) continue;
            this.addSystemDef(collection, sysDef);
        }
    }

    private boolean shouldAdd(String sysDef, List<String> excludeList) {
        if (excludeList != null) {
            for (String re : excludeList) {
                try {
                    Pattern p = Pattern.compile(re);
                    Matcher m = p.matcher(sysDef);
                    if (!m.matches()) continue;
                    LOG.info("addDatacollectionGroup: system definition {} is blacklisted by filter {}", (Object)re, (Object)sysDef);
                    return false;
                }
                catch (PatternSyntaxException e) {
                    LOG.warn("the regular expression {} is invalid: ", (Object)re, (Object)e);
                }
            }
        }
        return true;
    }

    private void throwException(String msg, Throwable e) {
        if (e == null) {
            LOG.error(msg);
            throw new DataAccessResourceFailureException(msg);
        }
        LOG.error(msg, e);
        throw new DataAccessResourceFailureException(msg, e);
    }
}

