/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.xml.eventconf.EnterpriseIdPartition;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.EventLabelComparator;
import org.opennms.netmgt.xml.eventconf.EventOrdering;
import org.opennms.netmgt.xml.eventconf.Events;
import org.opennms.netmgt.xml.eventconf.Partition;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.util.Assert;

public class MockEventConfDao
implements EventConfDao,
InitializingBean {
    private Resource m_resource;
    private Events m_events;

    public void setResource(Resource resource) {
        this.m_resource = resource;
    }

    public Resource getResource() {
        return this.m_resource;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.m_resource);
        this.reload();
    }

    public void reload() throws DataAccessException {
        InputStream is = null;
        InputStreamReader isr = null;
        try {
            is = this.m_resource.getInputStream();
            isr = new InputStreamReader(is);
            this.m_events = Events.unmarshal((Reader)isr);
            this.m_events.loadEventFiles(this.m_resource);
            this.m_events.initialize((Partition)new EnterpriseIdPartition(), new EventOrdering());
        }
        catch (IOException e) {
            try {
                throw new DataRetrievalFailureException("Failed to read from " + this.m_resource.toString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(isr);
                IOUtils.closeQuietly((InputStream)is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)isr);
        IOUtils.closeQuietly((InputStream)is);
    }

    public List<Event> getEvents(final String uei) {
        ArrayList<Event> events = new ArrayList<Event>();
        this.m_events.forEachEvent(events, (Events.EventCallback)new Events.EventCallback<List<Event>>(){

            public List<Event> process(List<Event> events, Event event) {
                if (uei.equals(event.getUei())) {
                    events.add(event);
                }
                return events;
            }
        });
        return events;
    }

    public List<String> getEventUEIs() {
        HashSet ueis = new HashSet();
        this.m_events.forEachEvent(ueis, (Events.EventCallback)new Events.EventCallback<Set<String>>(){

            public Set<String> process(Set<String> ueis, Event event) {
                ueis.add(event.getUei());
                return ueis;
            }
        });
        return new ArrayList<String>(ueis);
    }

    public Map<String, String> getEventLabels() {
        HashMap<String, String> labels = new HashMap<String, String>();
        this.m_events.forEachEvent(labels, (Events.EventCallback)new Events.EventCallback<Map<String, String>>(){

            public Map<String, String> process(Map<String, String> labels, Event event) {
                labels.put(event.getUei(), event.getEventLabel());
                return labels;
            }
        });
        return labels;
    }

    public String getEventLabel(String uei) {
        return this.getEventLabels().get(uei);
    }

    public void saveCurrent() {
        this.m_events.save(this.m_resource);
    }

    public List<Event> getEventsByLabel() {
        SortedSet events = (SortedSet)this.m_events.forEachEvent(new TreeSet(new EventLabelComparator()), (Events.EventCallback)new Events.EventCallback<SortedSet<Event>>(){

            public SortedSet<Event> process(SortedSet<Event> accum, Event event) {
                accum.add(event);
                return accum;
            }
        });
        return new ArrayList<Event>(events);
    }

    public void addEvent(Event event) {
        this.m_events.addEvent(event);
    }

    public void addEventToProgrammaticStore(Event event) {
        this.m_events.addEvent(event);
    }

    public boolean removeEventFromProgrammaticStore(Event event) {
        return this.m_events.removeEvent(event);
    }

    public boolean isSecureTag(String tag) {
        return this.m_events.isSecureTag(tag);
    }

    public Event findByUei(final String uei) {
        return this.m_events.findFirstMatchingEvent(new Events.EventCriteria(){

            public boolean matches(Event e) {
                return uei.equals(e.getUei());
            }
        });
    }

    public Event findByEvent(org.opennms.netmgt.xml.event.Event matchingEvent) {
        return this.m_events.findFirstMatchingEvent(matchingEvent);
    }

    public Events getRootEvents() {
        return this.m_events;
    }
}

