/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.core.utils.LazyList;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;

public class LazyChildResourceLoader
implements LazyList.Loader<OnmsResource> {
    private final ResourceDao m_resourceDao;
    private OnmsResource m_parent;

    public LazyChildResourceLoader(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public void setParent(OnmsResource parent) {
        this.m_parent = parent;
    }

    public List<OnmsResource> load() {
        Preconditions.checkNotNull((Object)this.m_parent, (Object)"parent attribute");
        LinkedList children = Lists.newLinkedList();
        for (OnmsResourceType resourceType : this.getAvailableResourceTypes()) {
            for (OnmsResource resource : resourceType.getResourcesForParent(this.m_parent)) {
                resource.setParent(this.m_parent);
                children.add(resource);
            }
        }
        return children;
    }

    private Collection<OnmsResourceType> getAvailableResourceTypes() {
        return this.m_resourceDao.getResourceTypes().stream().filter(t -> t.isResourceTypeOnParent(this.m_parent)).collect(Collectors.toList());
    }
}

