/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.concurrent.WaterfallExecutor;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.config.syslogd.HideMessage;
import org.opennms.netmgt.config.syslogd.UeiList;
import org.opennms.netmgt.syslogd.SyslogConnection;
import org.opennms.netmgt.syslogd.SyslogReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SyslogReceiverNioThreadPoolImpl
implements SyslogReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogReceiverNioThreadPoolImpl.class);
    private static final int SOCKET_TIMEOUT = 500;
    private volatile boolean m_stop = false;
    private final DatagramChannel m_channel;
    private Thread m_context;
    private final String m_matchPattern;
    private final int m_hostGroup;
    private final int m_messageGroup;
    private final String m_discardUei;
    private final UeiList m_UeiList;
    private final HideMessage m_HideMessages;
    private final ExecutorService m_executor;
    private final ExecutorService m_socketReceivers;

    SyslogReceiverNioThreadPoolImpl(DatagramChannel channel, String matchPattern, int hostGroup, int messageGroup, UeiList ueiList, HideMessage hideMessages, String discardUei) {
        this.m_channel = channel;
        this.m_matchPattern = matchPattern;
        this.m_hostGroup = hostGroup;
        this.m_messageGroup = messageGroup;
        this.m_discardUei = discardUei;
        this.m_UeiList = ueiList;
        this.m_HideMessages = hideMessages;
        this.m_executor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2, Runtime.getRuntime().availableProcessors() * 2, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new LogPreservingThreadFactory(this.getClass().getSimpleName(), Integer.MAX_VALUE));
        this.m_socketReceivers = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new LogPreservingThreadFactory(this.getClass().getSimpleName() + "-SocketReceiver", Integer.MAX_VALUE));
    }

    @Override
    public void stop() throws InterruptedException {
        this.m_stop = true;
        this.m_socketReceivers.shutdown();
        this.m_executor.shutdown();
        if (this.m_context != null) {
            LOG.debug("Stopping and joining thread context {}", (Object)this.m_context.getName());
            this.m_context.interrupt();
            this.m_context.join();
            LOG.debug("Thread context stopped and joined");
        }
    }

    @Override
    public void run() {
        this.m_context = Thread.currentThread();
        Logging.putPrefix((String)"syslogd");
        if (this.m_stop) {
            LOG.debug("Stop flag set before thread started, exiting");
            return;
        }
        LOG.debug("Thread context started");
        try {
            LOG.debug("Setting socket timeout to {}ms", (Object)500);
            this.m_channel.socket().setSoTimeout(500);
        }
        catch (SocketException e) {
            LOG.warn("An I/O error occured while trying to set the socket timeout", (Throwable)e);
        }
        try {
            LOG.debug("Attempting to set receive buffer size to {}", (Object)Integer.MAX_VALUE);
            this.m_channel.socket().setReceiveBufferSize(Integer.MAX_VALUE);
            LOG.debug("Actual receive buffer size is {}", (Object)this.m_channel.socket().getReceiveBufferSize());
        }
        catch (SocketException e) {
            LOG.info("Failed to set the receive buffer to {}", (Object)Integer.MAX_VALUE, (Object)e);
        }
        for (int i = 0; i < Runtime.getRuntime().availableProcessors(); ++i) {
            this.m_socketReceivers.execute(new Runnable(){

                @Override
                public void run() {
                    boolean ioInterrupted = false;
                    ByteBuffer buffer = ByteBuffer.allocate(65535);
                    buffer.clear();
                    while (!SyslogReceiverNioThreadPoolImpl.this.m_stop) {
                        if (SyslogReceiverNioThreadPoolImpl.this.m_context.isInterrupted()) {
                            LOG.debug("Thread context interrupted");
                            break;
                        }
                        try {
                            if (!ioInterrupted) {
                                LOG.debug("Waiting on a datagram to arrive");
                            }
                            InetSocketAddress source = (InetSocketAddress)SyslogReceiverNioThreadPoolImpl.this.m_channel.receive(buffer);
                            buffer.flip();
                            WaterfallExecutor.waterfall((Executor)SyslogReceiverNioThreadPoolImpl.this.m_executor, (Callable)new SyslogConnection(source, buffer, SyslogReceiverNioThreadPoolImpl.this.m_matchPattern, SyslogReceiverNioThreadPoolImpl.this.m_hostGroup, SyslogReceiverNioThreadPoolImpl.this.m_messageGroup, SyslogReceiverNioThreadPoolImpl.this.m_UeiList, SyslogReceiverNioThreadPoolImpl.this.m_HideMessages, SyslogReceiverNioThreadPoolImpl.this.m_discardUei));
                            buffer.clear();
                            ioInterrupted = false;
                        }
                        catch (SocketTimeoutException e) {
                            ioInterrupted = true;
                        }
                        catch (InterruptedIOException e) {
                            ioInterrupted = true;
                        }
                        catch (ExecutionException e) {
                            LOG.error("Task execution failed in {}", (Object)this.getClass().getSimpleName(), (Object)e);
                            break;
                        }
                        catch (InterruptedException e) {
                            LOG.error("Task interrupted in {}", (Object)this.getClass().getSimpleName(), (Object)e);
                            break;
                        }
                        catch (IOException e) {
                            LOG.error("An I/O exception occured on the datagram receipt port, exiting", (Throwable)e);
                            break;
                        }
                    }
                    LOG.debug("Thread context exiting");
                }
            });
        }
    }

    @Override
    public void setLogPrefix(String prefix) {
    }
}

