/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;
import org.jboss.netty.buffer.ChannelBuffer;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.concurrent.WaterfallExecutor;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.syslogd.HideMessage;
import org.opennms.netmgt.config.syslogd.UeiList;
import org.opennms.netmgt.syslogd.SyslogConnection;
import org.opennms.netmgt.syslogd.SyslogReceiver;
import org.opennms.netmgt.syslogd.SyslogReceiverNioThreadPoolImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SyslogReceiverCamelNettyImpl
implements SyslogReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogReceiverNioThreadPoolImpl.class);
    private static final int SOCKET_TIMEOUT = 500;
    private final InetAddress m_host;
    private final int m_port;
    private final String m_matchPattern;
    private final int m_hostGroup;
    private final int m_messageGroup;
    private final String m_discardUei;
    private final UeiList m_UeiList;
    private final HideMessage m_HideMessages;
    private final ExecutorService m_executor;
    private DefaultCamelContext m_camel;

    SyslogReceiverCamelNettyImpl(InetAddress host, int port, String matchPattern, int hostGroup, int messageGroup, UeiList ueiList, HideMessage hideMessages, String discardUei) {
        this.m_host = host == null ? InetAddressUtils.getLocalHostAddress() : host;
        this.m_port = port;
        this.m_matchPattern = matchPattern;
        this.m_hostGroup = hostGroup;
        this.m_messageGroup = messageGroup;
        this.m_discardUei = discardUei;
        this.m_UeiList = ueiList;
        this.m_HideMessages = hideMessages;
        this.m_executor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2, Runtime.getRuntime().availableProcessors() * 2, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new LogPreservingThreadFactory(this.getClass().getSimpleName(), Integer.MAX_VALUE));
    }

    @Override
    public void stop() throws InterruptedException {
        try {
            this.m_camel.shutdown();
        }
        catch (Exception e) {
            LOG.warn("Exception while shutting down syslog Camel context", (Throwable)e);
        }
        this.m_executor.shutdown();
    }

    @Override
    public void run() {
        Logging.putPrefix((String)"syslogd");
        SimpleRegistry registry = new SimpleRegistry();
        this.m_camel = new DefaultCamelContext((Registry)registry);
        try {
            this.m_camel.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    String from = String.format("netty:udp://%s:%s?sync=false&allowDefaultCodec=false&receiveBufferSize=%d&connectTimeout=%d", InetAddressUtils.str((InetAddress)SyslogReceiverCamelNettyImpl.this.m_host), SyslogReceiverCamelNettyImpl.this.m_port, Integer.MAX_VALUE, 500);
                    this.from(from).process(new Processor(){

                        public void process(Exchange exchange) throws Exception {
                            ChannelBuffer buffer = (ChannelBuffer)exchange.getIn().getBody(ChannelBuffer.class);
                            InetSocketAddress source = (InetSocketAddress)exchange.getIn().getHeader("CamelNettyRemoteAddress");
                            WaterfallExecutor.waterfall((Executor)SyslogReceiverCamelNettyImpl.this.m_executor, (Callable)new SyslogConnection(source, buffer.toByteBuffer(), SyslogReceiverCamelNettyImpl.this.m_matchPattern, SyslogReceiverCamelNettyImpl.this.m_hostGroup, SyslogReceiverCamelNettyImpl.this.m_messageGroup, SyslogReceiverCamelNettyImpl.this.m_UeiList, SyslogReceiverCamelNettyImpl.this.m_HideMessages, SyslogReceiverCamelNettyImpl.this.m_discardUei));
                        }
                    });
                }
            });
            this.m_camel.start();
        }
        catch (Exception e) {
            LOG.error("Could not configure Camel routes for syslog receiver", (Throwable)e);
        }
    }

    @Override
    public void setLogPrefix(String prefix) {
    }
}

