/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.util.EntityUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public class WebMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(WebMonitor.class);
    static Integer DEFAULT_TIMEOUT = 3000;
    static Integer DEFAULT_PORT = 80;
    static String DEFAULT_USER_AGENT = "OpenNMS WebMonitor";
    static String DEFAULT_PATH = "/";
    static String DEFAULT_USER = "admin";
    static String DEFAULT_PASSWORD = "admin";
    static String DEFAULT_HTTP_STATUS_RANGE = "100-399";
    static String DEFAULT_SCHEME = "http";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> map) {
        PollStatus pollStatus = PollStatus.unresponsive();
        HttpClientWrapper clientWrapper = HttpClientWrapper.create();
        try {
            String virtualHost;
            List params;
            String hostAddress = InetAddressUtils.str((InetAddress)svc.getAddress());
            URIBuilder ub = new URIBuilder();
            ub.setScheme(ParameterMap.getKeyedString(map, (String)"scheme", (String)DEFAULT_SCHEME));
            ub.setHost(hostAddress);
            ub.setPort(ParameterMap.getKeyedInteger(map, (String)"port", (int)DEFAULT_PORT));
            ub.setPath(ParameterMap.getKeyedString(map, (String)"path", (String)DEFAULT_PATH));
            String queryString = ParameterMap.getKeyedString(map, (String)"queryString", null);
            if (queryString != null && !queryString.trim().isEmpty() && !(params = URLEncodedUtils.parse((String)queryString, (Charset)Charset.forName("UTF-8"))).isEmpty()) {
                ub.setParameters(params);
            }
            HttpGet getMethod = new HttpGet(ub.build());
            clientWrapper.setConnectionTimeout(Integer.valueOf(ParameterMap.getKeyedInteger(map, (String)"timeout", (int)DEFAULT_TIMEOUT))).setSocketTimeout(Integer.valueOf(ParameterMap.getKeyedInteger(map, (String)"timeout", (int)DEFAULT_TIMEOUT)));
            String userAgent = ParameterMap.getKeyedString(map, (String)"user-agent", (String)DEFAULT_USER_AGENT);
            if (userAgent != null && !userAgent.trim().isEmpty()) {
                clientWrapper.setUserAgent(userAgent);
            }
            if ((virtualHost = ParameterMap.getKeyedString(map, (String)"virtual-host", (String)hostAddress)) != null && !virtualHost.trim().isEmpty()) {
                clientWrapper.setVirtualHost(virtualHost);
            }
            if (ParameterMap.getKeyedBoolean(map, (String)"http-1.0", (boolean)false)) {
                clientWrapper.setVersion(HttpVersion.HTTP_1_0);
            }
            for (String okey : map.keySet()) {
                String key = okey.toString();
                if (!key.matches("header_[0-9]+$")) continue;
                String headerName = ParameterMap.getKeyedString(map, (String)key, null);
                String headerValue = ParameterMap.getKeyedString(map, (String)(key + "_value"), null);
                getMethod.setHeader(headerName, headerValue);
            }
            if (ParameterMap.getKeyedBoolean(map, (String)"use-ssl-filter", (boolean)false)) {
                clientWrapper.trustSelfSigned(ParameterMap.getKeyedString(map, (String)"scheme", (String)DEFAULT_SCHEME));
            }
            if (ParameterMap.getKeyedBoolean(map, (String)"auth-enabled", (boolean)false)) {
                clientWrapper.addBasicCredentials(ParameterMap.getKeyedString(map, (String)"auth-user", (String)DEFAULT_USER), ParameterMap.getKeyedString(map, (String)"auth-password", (String)DEFAULT_PASSWORD));
                if (ParameterMap.getKeyedBoolean(map, (String)"auth-preemptive", (boolean)true)) {
                    clientWrapper.usePreemptiveAuth();
                }
            }
            LOG.debug("getMethod parameters: {}", (Object)getMethod);
            CloseableHttpResponse response = clientWrapper.execute((HttpUriRequest)getMethod);
            int statusCode = response.getStatusLine().getStatusCode();
            String statusText = response.getStatusLine().getReasonPhrase();
            String expectedText = ParameterMap.getKeyedString(map, (String)"response-text", null);
            LOG.debug("returned results are:");
            pollStatus = !this.inRange(ParameterMap.getKeyedString(map, (String)"response-range", (String)DEFAULT_HTTP_STATUS_RANGE), statusCode) ? PollStatus.unavailable((String)statusText) : PollStatus.available();
            if (expectedText != null) {
                String responseText = EntityUtils.toString((HttpEntity)response.getEntity());
                pollStatus = expectedText.charAt(0) == '~' ? (!responseText.matches(expectedText.substring(1)) ? PollStatus.unavailable((String)"Regex Failed") : PollStatus.available()) : (expectedText.equals(responseText) ? PollStatus.available() : PollStatus.unavailable((String)"Did not find expected Text"));
            }
        }
        catch (IOException e) {
            LOG.info(e.getMessage());
        }
        catch (URISyntaxException e) {
            LOG.info(e.getMessage());
        }
        catch (GeneralSecurityException gse) {
            LOG.error("Unable to set SSL trust to allow self-signed certificates", (Throwable)gse);
        }
        finally {
            IOUtils.closeQuietly((Closeable)clientWrapper);
        }
        return pollStatus;
    }

    private boolean inRange(String range, Integer val) {
        String[] boundries = range.split("-");
        return val >= Integer.valueOf(boundries[0]) && val <= Integer.valueOf(boundries[1]);
    }
}

