/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.datacollection.MibObject;
import org.opennms.netmgt.jmx.JmxUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXDataSource
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(JMXDataSource.class);
    public static final String RRD_ERROR = "RRD_ERROR";
    private static final String[] supportedObjectTypes = new String[]{"counter", "gauge", "timeticks", "integer", "octetstring"};
    private static final int COUNTER_INDEX = 0;
    private static final int GAUGE_INDEX = 1;
    private static final int TIMETICKS_INDEX = 2;
    private static final int INTEGER_INDEX = 3;
    private static final int OCTETSTRING_INDEX = 4;
    private static final String DST_GAUGE = "GAUGE";
    private static final String DST_COUNTER = "COUNTER";
    private String m_type;
    private int m_heartbeat;
    private String m_min;
    private String m_max;
    private String m_oid;
    private String m_instance;
    private String m_name;
    private String m_collectionName;

    public static boolean handlesType(String objectType) {
        return JMXDataSource.mapType(objectType) != null;
    }

    public static String mapType(String objectType) {
        int index;
        String rrdType = null;
        objectType = objectType.toLowerCase();
        for (index = 0; index < supportedObjectTypes.length && !objectType.startsWith(supportedObjectTypes[index]); ++index) {
        }
        switch (index) {
            case 0: {
                rrdType = DST_COUNTER;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                rrdType = DST_GAUGE;
                break;
            }
            default: {
                rrdType = null;
            }
        }
        return rrdType;
    }

    public JMXDataSource() {
        this.m_type = null;
        this.m_heartbeat = 600;
        this.m_min = "U";
        this.m_max = "U";
    }

    public JMXDataSource(MibObject obj, String collectionName) {
        this.m_collectionName = collectionName;
        this.setHeartbeat(2 * DataCollectionConfigFactory.getInstance().getStep(collectionName));
        this.setName(JmxUtils.trimAttributeName((String)this.getName()));
        this.setType(JMXDataSource.mapType(obj.getType()));
        this.m_min = "U";
        this.m_max = "U";
        LOG.debug("buildDataSourceList: ds_name: {} ds_oid: {}.{} ds_max: {} ds_min: {}", new Object[]{this.getName(), this.getOid(), this.getInstance(), this.getMax(), this.getMin()});
    }

    public void setOid(String oid) {
        this.m_oid = oid;
    }

    public void setInstance(String instance) {
        this.m_instance = instance;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getOid() {
        return this.m_oid;
    }

    public String getInstance() {
        return this.m_instance;
    }

    public String getName() {
        return this.m_name;
    }

    public JMXDataSource(JMXDataSource second) {
        this.m_oid = second.m_oid;
        this.m_instance = second.m_instance;
        this.m_name = second.m_name;
        this.m_type = second.m_type;
        this.m_heartbeat = second.m_heartbeat;
        this.m_min = second.m_min;
        this.m_max = second.m_max;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public void setHeartbeat(int heartbeat) {
        this.m_heartbeat = heartbeat;
    }

    public void setMin(String minimum) {
        this.m_min = minimum;
    }

    public void setMax(String maximum) {
        this.m_max = maximum;
    }

    public String getType() {
        return this.m_type;
    }

    public int getHeartbeat() {
        return this.m_heartbeat;
    }

    public String getMin() {
        return this.m_min;
    }

    public String getMax() {
        return this.m_max;
    }

    public Object clone() {
        return new JMXDataSource(this);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n   oid:       ").append(this.m_oid);
        buffer.append("\n   name:      ").append(this.m_name);
        buffer.append("\n   type:      ").append(this.m_type);
        buffer.append("\n   heartbeat: ").append(this.m_heartbeat);
        buffer.append("\n   min:       ").append(this.m_min);
        buffer.append("\n   max:       ").append(this.m_max);
        return buffer.toString();
    }
}

